<?php
/**
 * ###############################################
 *
 * SWIFT Framework
 * _______________________________________________
 *
 * @author        Varun Shoor
 *
 * @package        SWIFT
 * @copyright    Copyright (c) 2001-2012, Kayako
 * @license        http://www.kayako.com/license
 * @link        http://www.kayako.com
 *
 * ###############################################
 */

use Base\Models\Staff\SWIFT_Staff;

/**
 * Report Setup Class
 *
 * @author Varun Shoor
 */
class SWIFT_ReportSetup extends SWIFT_Library
{
    /**
     * Install the Reports App
     *
     * @author Varun Shoor
     * @return bool "true" on Success, "false" otherwise
     */
    public static function Install()
    {
        $_SWIFT = SWIFT::GetInstance();

        SWIFT_Loader::LoadModel('Category:ReportCategory', APP_REPORTS);
        SWIFT_Loader::LoadModel('Report:Report', APP_REPORTS);

        $_staffIDContainer = $_SWIFT->Database->QueryFetch("SELECT staffid FROM " . TABLE_PREFIX . "staff");
        if (!isset($_staffIDContainer['staffid']) || empty($_staffIDContainer['staffid'])) {
            throw new SWIFT_Exception('Invalid Staff ID');
        }

        $_SWIFT_StaffObject = new SWIFT_Staff(new SWIFT_DataID($_staffIDContainer['staffid']));
        if (!$_SWIFT_StaffObject instanceof SWIFT_Staff || !$_SWIFT_StaffObject->GetIsClassLoaded()) {
            throw new SWIFT_Exception('Invalid Staff Object');
        }

        $_installedAppList = array();

        $_SWIFT->Database->Query("SELECT * FROM " . TABLE_PREFIX . "settings WHERE section = 'installedapps'");
        while ($_SWIFT->Database->NextRecord()) {
            $_installedAppList[] = $_SWIFT->Database->Record['vkey'];
        }

        $_reportCategoryID_Ratings = (string)SWIFT_ReportCategory::Create($_SWIFT->Language->Get('r_ratings'), SWIFT_ReportCategory::VISIBLE_PUBLIC, $_SWIFT_StaffObject);

        /**
         * ---------------------------------------------
         * Ticket Reports
         * ---------------------------------------------
         */
        if (in_array(APP_TICKETS, $_installedAppList)) {
            $_reportCategoryID_Tickets = (string)SWIFT_ReportCategory::Create($_SWIFT->Language->Get('r_tickets'), SWIFT_ReportCategory::VISIBLE_PUBLIC, $_SWIFT_StaffObject);
            $_reportCategoryID_TicketBilling = (string)SWIFT_ReportCategory::Create($_SWIFT->Language->Get('r_ticketbilling'), SWIFT_ReportCategory::VISIBLE_PUBLIC, $_SWIFT_StaffObject);
            $_reportCategoryID_TicketEscalation = (string)SWIFT_ReportCategory::Create($_SWIFT->Language->Get('r_ticketescalations'), SWIFT_ReportCategory::VISIBLE_PUBLIC, $_SWIFT_StaffObject);
            $_reportCategoryID_TicketAuditLog = (string)SWIFT_ReportCategory::Create($_SWIFT->Language->Get('r_ticketauditlogs'), SWIFT_ReportCategory::VISIBLE_PUBLIC, $_SWIFT_StaffObject);

            // Audit Log Reports
            SWIFT_Report::Create($_reportCategoryID_TicketAuditLog, $_SWIFT->Language->Get('r_workdonethisweek'), 'ticketauditlogs', "SELECT 'Ticket Audit Logs.Action', 'Ticket Audit Logs.Message' FROM 'Ticket Audit Logs' WHERE 'Ticket Audit Logs.Creator' = 'Staff' AND 'Ticket Audit Logs.Creation Date' >= ThisWeek() MULTIGROUP BY 'Ticket Audit Logs.Creation Date':DayName, 'Ticket Audit Logs.Full Name' ORDER BY 'Ticket Audit Logs.Creation Date' ASC", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            SWIFT_Report::Create($_reportCategoryID_TicketAuditLog, $_SWIFT->Language->Get('r_workdonethismonth'), 'ticketauditlogs', "SELECT 'Ticket Audit Logs.Action', 'Ticket Audit Logs.Message' FROM 'Ticket Audit Logs' WHERE 'Ticket Audit Logs.Creator' = 'Staff' AND 'Ticket Audit Logs.Creation Date' >= ThisMonth() MULTIGROUP BY 'Ticket Audit Logs.Creation Date':Week, 'Ticket Audit Logs.Creation Date':DayName, 'Ticket Audit Logs.Full Name' ORDER BY 'Ticket Audit Logs.Creation Date' ASC", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            SWIFT_Report::Create($_reportCategoryID_TicketAuditLog, $_SWIFT->Language->Get('r_ticketsdeletedthismonth'), 'ticketauditlogs', "SELECT 'Ticket Audit Logs.Action', 'Ticket Audit Logs.Message' FROM 'Ticket Audit Logs' WHERE 'Ticket Audit Logs.Creator' = 'Staff' AND 'Ticket Audit Logs.Creation Date' >= ThisMonth() AND ('Ticket Audit Logs.Action' = 'Deleted Ticket' OR 'Ticket Audit Logs.Action' = 'Moved to Trash') MULTIGROUP BY 'Ticket Audit Logs.Full Name' ORDER BY 'Ticket Audit Logs.Creation Date' ASC", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            SWIFT_Report::Create($_reportCategoryID_TicketAuditLog, $_SWIFT->Language->Get('r_completelogforthisweek'), 'ticketauditlogs', "SELECT 'Ticket Audit Logs.Action', 'Ticket Audit Logs.Message' FROM 'Ticket Audit Logs' WHERE 'Ticket Audit Logs.Creation Date' >= ThisWeek() MULTIGROUP BY 'Tickets.Ticket Mask ID', 'Tickets.Subject' ORDER BY 'Ticket Audit Logs.Creation Date' ASC", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            SWIFT_Report::Create($_reportCategoryID_TicketAuditLog, $_SWIFT->Language->Get('r_completelogforthismonth'), 'ticketauditlogs', "SELECT 'Ticket Audit Logs.Action', 'Ticket Audit Logs.Message' FROM 'Ticket Audit Logs' WHERE 'Ticket Audit Logs.Creation Date' >= ThisMonth() MULTIGROUP BY 'Tickets.Ticket Mask ID', 'Tickets.Subject' ORDER BY 'Ticket Audit Logs.Creation Date' ASC", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            // Escalation Reports
            SWIFT_Report::Create($_reportCategoryID_TicketEscalation, $_SWIFT->Language->Get('r_escalationsforthisweek'), 'escalationpaths', "SELECT 'Escalations.Rule', 'Escalations.Department', 'Escalations.Owner', 'Escalations.Status', 'Escalations.Type', 'Escalations.Priority', 'Escalations.Escalation Date' FROM 'Escalations' WHERE 'Escalations.Escalation Date' >= ThisWeek() MULTIGROUP BY 'Escalations.Escalation Date':DayName, 'Tickets.Ticket Mask ID', 'Tickets.Subject' ORDER BY 'Escalations.Escalation Date' ASC", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            SWIFT_Report::Create($_reportCategoryID_TicketEscalation, $_SWIFT->Language->Get('r_escalationsforthismonth'), 'escalationpaths', "SELECT 'Escalations.Rule', 'Escalations.Department', 'Escalations.Owner', 'Escalations.Status', 'Escalations.Type', 'Escalations.Priority', 'Escalations.Escalation Date' FROM 'Escalations' WHERE 'Escalations.Escalation Date' >= ThisMonth() MULTIGROUP BY 'Escalations.Escalation Date':Week, 'Escalations.Escalation Date':DayName, 'Tickets.Ticket Mask ID', 'Tickets.Subject' ORDER BY 'Escalations.Escalation Date' ASC", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            SWIFT_Report::Create($_reportCategoryID_TicketEscalation, $_SWIFT->Language->Get('r_escalationmatrixownerweek'), 'escalationpaths', "SELECT COUNT(*) AS EscalationCount FROM 'Escalations' WHERE 'Escalations.Escalation Date' >= ThisWeek() GROUP BY X('Escalations.Rule'), Y('Escalations.Owner')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            SWIFT_Report::Create($_reportCategoryID_TicketEscalation, $_SWIFT->Language->Get('r_escalationmatrixownermonth'), 'escalationpaths', "SELECT COUNT(*) AS EscalationCount FROM 'Escalations' WHERE 'Escalations.Escalation Date' >= ThisMonth() GROUP BY X('Escalations.Rule'), Y('Escalations.Owner')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            SWIFT_Report::Create($_reportCategoryID_TicketEscalation, $_SWIFT->Language->Get('r_escalationmatrixdepartmentweek'), 'escalationpaths', "SELECT COUNT(*) AS EscalationCount FROM 'Escalations' WHERE 'Escalations.Escalation Date' >= ThisWeek() GROUP BY X('Escalations.Rule'), Y('Escalations.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            SWIFT_Report::Create($_reportCategoryID_TicketEscalation, $_SWIFT->Language->Get('r_escalationmatrixdepartmentmonth'), 'escalationpaths', "SELECT COUNT(*) AS EscalationCount FROM 'Escalations' WHERE 'Escalations.Escalation Date' >= ThisMonth() GROUP BY X('Escalations.Rule'), Y('Escalations.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            SWIFT_Report::Create($_reportCategoryID_TicketEscalation, $_SWIFT->Language->Get('r_escalationmatrixtypeweek'), 'escalationpaths', "SELECT COUNT(*) AS EscalationCount FROM 'Escalations' WHERE 'Escalations.Escalation Date' >= ThisWeek() GROUP BY X('Escalations.Rule'), Y('Escalations.Type')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            SWIFT_Report::Create($_reportCategoryID_TicketEscalation, $_SWIFT->Language->Get('r_escalationmatrixtypemonth'), 'escalationpaths', "SELECT COUNT(*) AS EscalationCount FROM 'Escalations' WHERE 'Escalations.Escalation Date' >= ThisMonth() GROUP BY X('Escalations.Rule'), Y('Escalations.Type')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            // Ticket Billing Reports
            SWIFT_Report::Create($_reportCategoryID_TicketBilling, $_SWIFT->Language->Get('r_totaltimebilledgbstaffthisweek'), 'tickettimetracks', "SELECT SUM('Ticket Billing.Time Spent'), SUM('Ticket Billing.Time Billable') FROM 'Ticket Billing' WHERE 'Ticket Billing.Creation Date' >= ThisWeek() GROUP BY X('Ticket Billing.Creation Date':DayName), Y('Ticket Billing.Worker')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_TicketBilling, $_SWIFT->Language->Get('r_totaltimebilledgbstaffthismonth'), 'tickettimetracks', "SELECT SUM('Ticket Billing.Time Spent'), SUM('Ticket Billing.Time Billable') FROM 'Ticket Billing' WHERE 'Ticket Billing.Creation Date' >= ThisMonth() GROUP BY X('Ticket Billing.Creation Date':Week), X('Ticket Billing.Creation Date':DayName), Y('Ticket Billing.Worker')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_TicketBilling, $_SWIFT->Language->Get('r_totaltimebilledgbdepartmentthisweek'), 'tickettimetracks', "SELECT SUM('Ticket Billing.Time Spent'), SUM('Ticket Billing.Time Billable') FROM 'Ticket Billing' WHERE 'Ticket Billing.Creation Date' >= ThisWeek() GROUP BY X('Ticket Billing.Creation Date':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_TicketBilling, $_SWIFT->Language->Get('r_totaltimebilledgbdepartmentthismonth'), 'tickettimetracks', "SELECT SUM('Ticket Billing.Time Spent'), SUM('Ticket Billing.Time Billable') FROM 'Ticket Billing' WHERE 'Ticket Billing.Creation Date' >= ThisMonth() GROUP BY X('Ticket Billing.Creation Date':Week), X('Ticket Billing.Creation Date':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_TicketBilling, $_SWIFT->Language->Get('r_totaltimebilledgbuserthisweek'), 'tickettimetracks', "SELECT SUM('Ticket Billing.Time Spent'), SUM('Ticket Billing.Time Billable') FROM 'Ticket Billing', 'Tickets' WHERE 'Ticket Billing.Creation Date' >= ThisWeek() GROUP BY X('Ticket Billing.Creation Date':DayName), Y('Users.Full Name')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_TicketBilling, $_SWIFT->Language->Get('r_totaltimebilledgbuserthismonth'), 'tickettimetracks', "SELECT SUM('Ticket Billing.Time Spent'), SUM('Ticket Billing.Time Billable') FROM 'Ticket Billing', 'Tickets' WHERE 'Ticket Billing.Creation Date' >= ThisMonth() GROUP BY X('Ticket Billing.Creation Date':Week), X('Ticket Billing.Creation Date':DayName), Y('Users.Full Name')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_TicketBilling, $_SWIFT->Language->Get('r_listticketsbilledgbstaffthisweek'), 'tickettimetracks', "SELECT 'Tickets.Ticket Mask ID', 'Tickets.Subject', 'Tickets.Department', 'Tickets.Type', 'Tickets.Status', 'Tickets.Priority', 'Tickets.Full Name', 'Tickets.Email', 'Ticket Billing.Time Spent', 'Ticket Billing.Time Billable' FROM 'Ticket Billing', 'Tickets' WHERE 'Ticket Billing.Creation Date' >= ThisWeek() MULTIGROUP BY 'Ticket Billing.Creation Date':DayName, 'Ticket Billing.Worker'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_TicketBilling, $_SWIFT->Language->Get('r_listticketsbilledgbstaffthismonth'), 'tickettimetracks', "SELECT 'Tickets.Ticket Mask ID', 'Tickets.Subject', 'Tickets.Department', 'Tickets.Type', 'Tickets.Status', 'Tickets.Priority', 'Tickets.Full Name', 'Tickets.Email', 'Ticket Billing.Time Spent', 'Ticket Billing.Time Billable' FROM 'Ticket Billing', 'Tickets' WHERE 'Ticket Billing.Creation Date' >= ThisMonth() MULTIGROUP BY 'Ticket Billing.Creation Date':Week, 'Ticket Billing.Creation Date':DayName, 'Ticket Billing.Worker'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_TicketBilling, $_SWIFT->Language->Get('r_listticketsbilledgbuserthisweek'), 'tickettimetracks', "SELECT 'Tickets.Ticket Mask ID', 'Tickets.Subject', 'Tickets.Department', 'Tickets.Type', 'Tickets.Status', 'Tickets.Priority', 'Tickets.Full Name', 'Tickets.Email', 'Ticket Billing.Time Spent', 'Ticket Billing.Time Billable' FROM 'Ticket Billing', 'Tickets' WHERE 'Ticket Billing.Creation Date' >= ThisWeek() MULTIGROUP BY 'Ticket Billing.Creation Date':DayName, 'Users.Full Name'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_TicketBilling, $_SWIFT->Language->Get('r_listticketsbilledgbuserthismonth'), 'tickettimetracks', "SELECT 'Tickets.Ticket Mask ID', 'Tickets.Subject', 'Tickets.Department', 'Tickets.Type', 'Tickets.Status', 'Tickets.Priority', 'Tickets.Full Name', 'Tickets.Email', 'Ticket Billing.Time Spent', 'Ticket Billing.Time Billable' FROM 'Ticket Billing', 'Tickets' WHERE 'Ticket Billing.Creation Date' >= ThisMonth() MULTIGROUP BY 'Ticket Billing.Creation Date':Week, 'Ticket Billing.Creation Date':DayName, 'Users.Full Name'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_TicketBilling, $_SWIFT->Language->Get('r_listticketsbilledgbuserorgthisweek'), 'tickettimetracks', "SELECT 'Tickets.Ticket Mask ID', 'Tickets.Subject', 'Tickets.Department', 'Tickets.Type', 'Tickets.Status', 'Tickets.Priority', 'Tickets.Full Name', 'Tickets.Email', 'Ticket Billing.Time Spent', 'Ticket Billing.Time Billable' FROM 'Ticket Billing', 'Tickets', 'Users' WHERE 'Ticket Billing.Creation Date' >= ThisWeek() MULTIGROUP BY 'Ticket Billing.Creation Date':DayName, 'User Organizations.Name'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_TicketBilling, $_SWIFT->Language->Get('r_listticketsbilledgbuserorgthismonth'), 'tickettimetracks', "SELECT 'Tickets.Ticket Mask ID', 'Tickets.Subject', 'Tickets.Department', 'Tickets.Type', 'Tickets.Status', 'Tickets.Priority', 'Tickets.Full Name', 'Tickets.Email', 'Ticket Billing.Time Spent', 'Ticket Billing.Time Billable' FROM 'Ticket Billing', 'Tickets', 'Users' WHERE 'Ticket Billing.Creation Date' >= ThisMonth() MULTIGROUP BY 'Ticket Billing.Creation Date':Week, 'Ticket Billing.Creation Date':DayName, 'User Organizations.Name'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_TicketBilling, $_SWIFT->Language->Get('r_listticketsbilledgbtypeuserthisweek'), 'tickettimetracks', "SELECT 'Tickets.Ticket Mask ID', 'Tickets.Subject', 'Tickets.Department', 'Tickets.Type', 'Tickets.Status', 'Tickets.Priority', 'Tickets.Full Name', 'Tickets.Email', 'Ticket Billing.Time Spent', 'Ticket Billing.Time Billable' FROM 'Ticket Billing', 'Tickets' WHERE 'Ticket Billing.Creation Date' >= ThisWeek() MULTIGROUP BY 'Ticket Billing.Creation Date':DayName, 'Tickets.Type', 'Users.Full Name'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_TicketBilling, $_SWIFT->Language->Get('r_listticketsbilledgbtypeuserthismonth'), 'tickettimetracks', "SELECT 'Tickets.Ticket Mask ID', 'Tickets.Subject', 'Tickets.Department', 'Tickets.Type', 'Tickets.Status', 'Tickets.Priority', 'Tickets.Full Name', 'Tickets.Email', 'Ticket Billing.Time Spent', 'Ticket Billing.Time Billable' FROM 'Ticket Billing', 'Tickets' WHERE 'Ticket Billing.Creation Date' >= ThisMonth() MULTIGROUP BY 'Ticket Billing.Creation Date':Week, 'Ticket Billing.Creation Date':DayName, 'Tickets.Type', 'Users.Full Name'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_TicketBilling, $_SWIFT->Language->Get('r_listticketsbilledgbdepuserthisweek'), 'tickettimetracks', "SELECT 'Tickets.Ticket Mask ID', 'Tickets.Subject', 'Tickets.Department', 'Tickets.Type', 'Tickets.Status', 'Tickets.Priority', 'Tickets.Full Name', 'Tickets.Email', 'Ticket Billing.Time Spent', 'Ticket Billing.Time Billable' FROM 'Ticket Billing', 'Tickets' WHERE 'Ticket Billing.Creation Date' >= ThisWeek() MULTIGROUP BY 'Ticket Billing.Creation Date':DayName, 'Tickets.Department', 'Users.Full Name'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_TicketBilling, $_SWIFT->Language->Get('r_listticketsbilledgbdepuserthismonth'), 'tickettimetracks', "SELECT 'Tickets.Ticket Mask ID', 'Tickets.Subject', 'Tickets.Department', 'Tickets.Type', 'Tickets.Status', 'Tickets.Priority', 'Tickets.Full Name', 'Tickets.Email', 'Ticket Billing.Time Spent', 'Ticket Billing.Time Billable' FROM 'Ticket Billing', 'Tickets' WHERE 'Ticket Billing.Creation Date' >= ThisMonth() MULTIGROUP BY 'Ticket Billing.Creation Date':Week, 'Ticket Billing.Creation Date':DayName, 'Tickets.Department', 'Users.Full Name'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            // Rating Reports
            SWIFT_Report::Create($_reportCategoryID_Ratings, $_SWIFT->Language->Get('r_avgratticketsgbstaffthismonth'), 'ratingresults', "SELECT AVG('Rating Results.Score') FROM 'Rating Results', 'Tickets' WHERE 'Ratings.Type' = 'Tickets' AND 'Rating Results.Rating Date' = ThisMonth() GROUP BY X('Ratings.Title'), Y('Tickets.Owner')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Ratings, $_SWIFT->Language->Get('r_avgratticketsgbdepthismonth'), 'ratingresults', "SELECT AVG('Rating Results.Score') FROM 'Rating Results', 'Tickets' WHERE 'Ratings.Type' = 'Tickets' AND 'Rating Results.Rating Date' = ThisMonth() GROUP BY X('Ratings.Title'), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Ratings, $_SWIFT->Language->Get('r_avgratticketpostsgbdepthismonth'), 'ratingresults', "SELECT AVG('Rating Results.Score') FROM 'Rating Results', 'Ticket Posts' WHERE 'Ratings.Type' = 'Ticket Posts' AND 'Rating Results.Rating Date' = ThisMonth() AND 'Ticket Posts.Creator' = 'Staff' GROUP BY X('Ratings.Title'), Y('Ticket Posts.Full Name')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Ratings, $_SWIFT->Language->Get('r_avgpratticketsgbstaffthismonth'), 'ratingresults', "SELECT AVG('Rating Results.Score') FROM 'Rating Results', 'Tickets' WHERE 'Ratings.Visibility' = 'Private' AND 'Ratings.Type' = 'Tickets' AND 'Rating Results.Rating Date' = ThisMonth() GROUP BY X('Ratings.Title'), Y('Tickets.Owner')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Ratings, $_SWIFT->Language->Get('r_avgpratticketsgbdepthismonth'), 'ratingresults', "SELECT AVG('Rating Results.Score') FROM 'Rating Results', 'Tickets' WHERE 'Ratings.Visibility' = 'Private' AND 'Ratings.Type' = 'Tickets' AND 'Rating Results.Rating Date' = ThisMonth() GROUP BY X('Ratings.Title'), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Ratings, $_SWIFT->Language->Get('r_avgpratticketpostsgbdepthismonth'), 'ratingresults', "SELECT AVG('Rating Results.Score') FROM 'Rating Results', 'Ticket Posts' WHERE 'Ratings.Visibility' = 'Private' AND 'Ratings.Type' = 'Ticket Posts' AND 'Rating Results.Rating Date' = ThisMonth() AND 'Ticket Posts.Creator' = 'Staff' GROUP BY X('Ratings.Title'), Y('Ticket Posts.Full Name')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Ratings, $_SWIFT->Language->Get('r_listofticketsratinglsthreethismonth'), 'ratingresults', "SELECT 'Ratings.Title', 'Rating Results.Score', 'Tickets.Ticket Mask ID', 'Tickets.Subject', 'Tickets.Department', 'Tickets.Status', 'Tickets.Type', 'Tickets.Priority', 'Tickets.Full Name', 'Tickets.Email', 'Tickets.Creation Date' FROM 'Rating Results', 'Tickets' WHERE 'Ratings.Type' = 'Tickets' AND 'Rating Results.Rating Date' = ThisMonth() AND 'Rating Results.Score' <= 3 MULTIGROUP BY 'Tickets.Owner'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Ratings, $_SWIFT->Language->Get('r_listofticketpostsratinglsthreethismonth'), 'ratingresults', "SELECT 'Ratings.Title', 'Rating Results.Score', 'Tickets.Ticket Mask ID', 'Tickets.Subject', 'Tickets.Department', 'Tickets.Status', 'Tickets.Type', 'Tickets.Priority', 'Ticket Posts.Full Name', 'Ticket Posts.Email', 'Ticket Posts.Creation Date' FROM 'Rating Results', 'Ticket Posts' WHERE 'Ratings.Type' = 'Ticket Posts' AND 'Rating Results.Rating Date' = ThisMonth() AND 'Rating Results.Score' <= 3 MULTIGROUP BY 'Ticket Posts.Full Name'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            // Tickets
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_numunresolvticketsgbdepartment'), 'tickets', "SELECT COUNT(*) AS Total FROM 'Tickets' WHERE 'Tickets.Is Resolved' = '0' GROUP BY X('Tickets.Department'), Y('Tickets.Owner')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_totalticketcountgbdepstatus'), 'tickets', "SELECT COUNT(*) AS Total FROM 'Tickets' GROUP BY 'Tickets.Department', 'Tickets.Status'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_numescalatedthismongbdep'), 'tickets', "SELECT COUNT(*) AS Total FROM 'Tickets' WHERE 'Tickets.Is Escalated' = '1' AND 'Tickets.Escalation Date' = ThisMonth() GROUP BY X('Tickets.Escalation Date':Week), X('Tickets.Escalation Date':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_numescalatedthismongbstatus'), 'tickets', "SELECT COUNT(*) AS Total FROM 'Tickets' WHERE 'Tickets.Is Escalated' = '1' AND 'Tickets.Escalation Date' = ThisMonth() GROUP BY X('Tickets.Escalation Date':Week), X('Tickets.Escalation Date':DayName), Y('Tickets.Status')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_numescalatedthismongbpriority'), 'tickets', "SELECT COUNT(*) AS Total FROM 'Tickets' WHERE 'Tickets.Is Escalated' = '1' AND 'Tickets.Escalation Date' = ThisMonth() GROUP BY X('Tickets.Escalation Date':Week), X('Tickets.Escalation Date':DayName), Y('Tickets.Priority')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_numautoclosedthismongbdepartment'), 'tickets', "SELECT COUNT(*) AS Total FROM 'Tickets' WHERE 'Tickets.Is Auto Closed' = '1' AND 'Tickets.Auto Closed Date' = ThisMonth() GROUP BY X('Tickets.Auto Closed Date':Week), X('Tickets.Auto Closed Date':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_numautoclosedthismongbowner'), 'tickets', "SELECT COUNT(*) AS Total FROM 'Tickets' WHERE 'Tickets.Is Auto Closed' = '1' AND 'Tickets.Auto Closed Date' = ThisMonth() GROUP BY X('Tickets.Auto Closed Date':Week), X('Tickets.Auto Closed Date':DayName), Y('Tickets.Owner')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_listautoclosedthismongbdep'), 'tickets', "SELECT 'Tickets.Ticket Mask ID', 'Tickets.Subject', 'Tickets.Department', 'Tickets.Status', 'Tickets.Type', 'Tickets.Priority', 'Tickets.Full Name', 'Tickets.Email', 'Tickets.Creation Date', 'Tickets.Auto Closed Date' FROM 'Tickets' WHERE 'Tickets.Is Auto Closed' = '1' AND 'Tickets.Auto Closed Date' = ThisMonth() MULTIGROUP BY 'Tickets.Auto Closed Date':Week, 'Tickets.Auto Closed Date':DayName, 'Tickets.Department'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_listautoclosedthismongbowner'), 'tickets', "SELECT 'Tickets.Ticket Mask ID', 'Tickets.Subject', 'Tickets.Department', 'Tickets.Status', 'Tickets.Type', 'Tickets.Priority', 'Tickets.Full Name', 'Tickets.Email', 'Tickets.Creation Date', 'Tickets.Auto Closed Date' FROM 'Tickets' WHERE 'Tickets.Is Auto Closed' = '1' AND 'Tickets.Auto Closed Date' = ThisMonth() MULTIGROUP BY 'Tickets.Auto Closed Date':Week, 'Tickets.Auto Closed Date':DayName, 'Tickets.Owner'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_numticketsgbcreationchannelanddepforthismo'), 'tickets', "SELECT COUNT(*) AS Total FROM 'Tickets' WHERE 'Tickets.Creation Date' = ThisMonth() GROUP BY 'Tickets.Creation Mode', 'Tickets.Department'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgrepliesgbdepthismonth'), 'tickets', "SELECT AVG('Tickets.Total Replies') AS AverageReplies FROM 'Tickets' WHERE 'Tickets.Creation Date' = ThisMonth() GROUP BY 'Tickets.Department'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgrepliesgbownerthismonth'), 'tickets', "SELECT AVG('Tickets.Total Replies') AS AverageReplies FROM 'Tickets' WHERE 'Tickets.Creation Date' = ThisMonth() GROUP BY 'Tickets.Owner'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_totalescthismonthgbweekday'), 'tickets', "SELECT COUNT(*) AS Total FROM 'Tickets' WHERE 'Tickets.Is Escalated' = '1' AND 'Tickets.Escalation Date' = ThisMonth() GROUP BY 'Tickets.Escalation Date':Week, 'Tickets.Escalation Date':DayName", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_numreopenthismonthgbdep'), 'tickets', "SELECT COUNT(*) AS Total FROM 'Tickets' WHERE 'Tickets.Was Reopened' = '1' AND 'Tickets.Reopen Date' = ThisMonth() GROUP BY X('Tickets.Escalation Date':Week), X('Tickets.Escalation Date':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_numreopenthismonthgbowner'), 'tickets', "SELECT COUNT(*) AS Total FROM 'Tickets' WHERE 'Tickets.Was Reopened' = '1' AND 'Tickets.Reopen Date' = ThisMonth() GROUP BY X('Tickets.Escalation Date':Week), X('Tickets.Escalation Date':DayName), Y('Tickets.Owner')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_numresolvedthismonthgbdep'), 'tickets', "SELECT COUNT(*) AS Total FROM 'Tickets' WHERE 'Tickets.Is Resolved' = '1' AND 'Tickets.Resolved Date' = ThisMonth() GROUP BY X('Tickets.Resolved Date':Week), X('Tickets.Resolved Date':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_numresolvedthismonthgbowner'), 'tickets', "SELECT COUNT(*) AS Total FROM 'Tickets' WHERE 'Tickets.Is Resolved' = '1' AND 'Tickets.Resolved Date' = ThisMonth() GROUP BY X('Tickets.Resolved Date':Week), X('Tickets.Resolved Date':DayName), Y('Tickets.Owner')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgescresolvedthismonthgbdep'), 'tickets', "SELECT AVG('Tickets.Escalation Count') FROM 'Tickets' WHERE 'Tickets.Is Resolved' = '1' AND 'Tickets.Resolved Date' = ThisMonth() GROUP BY X('Tickets.Resolved Date':Week), X('Tickets.Resolved Date':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgescresolvedthismonthgbowner'), 'tickets', "SELECT AVG('Tickets.Escalation Count') FROM 'Tickets' WHERE 'Tickets.Is Resolved' = '1' AND 'Tickets.Resolved Date' = ThisMonth() GROUP BY X('Tickets.Resolved Date':Week), X('Tickets.Resolved Date':DayName), Y('Tickets.Owner')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgtimetoresolvethismonthgbdep'), 'tickets', "SELECT AVG('Tickets.Time to Resolve') FROM 'Tickets' WHERE 'Tickets.Is Resolved' = '1' AND 'Tickets.Resolved Date' = ThisMonth() GROUP BY X('Tickets.Resolved Date':Week), X('Tickets.Resolved Date':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgtimetoresolvethismonthgbowner'), 'tickets', "SELECT AVG('Tickets.Time to Resolve') FROM 'Tickets' WHERE 'Tickets.Is Resolved' = '1' AND 'Tickets.Resolved Date' = ThisMonth() GROUP BY X('Tickets.Resolved Date':Week), X('Tickets.Resolved Date':DayName), Y('Tickets.Owner')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgrepliestoresolvethismonthgbdep'), 'tickets', "SELECT AVG('Tickets.Total Replies') FROM 'Tickets' WHERE 'Tickets.Is Resolved' = '1' AND 'Tickets.Resolved Date' = ThisMonth() GROUP BY X('Tickets.Resolved Date':Week), X('Tickets.Resolved Date':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgrepliestoresolvethismonthgbowner'), 'tickets', "SELECT AVG('Tickets.Total Replies') FROM 'Tickets' WHERE 'Tickets.Is Resolved' = '1' AND 'Tickets.Resolved Date' = ThisMonth() GROUP BY X('Tickets.Resolved Date':Week), X('Tickets.Resolved Date':DayName), Y('Tickets.Owner')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgrespthismonthgbdep'), 'tickets', "SELECT AVG('Tickets.Average Response Time') FROM 'Tickets' WHERE 'Tickets.Creation Date' = ThisMonth() GROUP BY X('Tickets.Creation Date':Week), X('Tickets.Creation Date':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgrespthismonthgbowner'), 'tickets', "SELECT AVG('Tickets.Average Response Time') FROM 'Tickets' WHERE 'Tickets.Creation Date' = ThisMonth() GROUP BY X('Tickets.Creation Date':Week), X('Tickets.Creation Date':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgowntoresolvethismonthgbdep'), 'tickets', "SELECT AVG('Tickets.Owners to Resolve') FROM 'Tickets' WHERE 'Tickets.Is Resolved' = '1' AND 'Tickets.Resolved Date' = ThisMonth() GROUP BY X('Tickets.Resolved Date':Week), X('Tickets.Resolved Date':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_listticketsduetoday'), 'tickets', "SELECT 'Tickets.Ticket Mask ID', 'Tickets.Subject', 'Tickets.Department', 'Tickets.Status', 'Tickets.Type', 'Tickets.Priority', 'Tickets.Full Name', 'Tickets.Email', 'Tickets.Creation Date', 'Tickets.Auto Closed Date' FROM 'Tickets' WHERE 'Tickets.Is Resolved' = '0' AND 'Tickets.Reply Due Date' = Today() ORDER BY 'Tickets.Reply Due Date' ASC", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_listoverduetickets'), 'tickets', "SELECT 'Tickets.Ticket Mask ID', 'Tickets.Subject', 'Tickets.Department', 'Tickets.Status', 'Tickets.Type', 'Tickets.Priority', 'Tickets.Full Name', 'Tickets.Email', 'Tickets.Creation Date', 'Tickets.Auto Closed Date' FROM 'Tickets' WHERE 'Tickets.Is Resolved' = '0' AND 'Tickets.Reply Due Date' <= DateNow() ORDER BY 'Tickets.Reply Due Date' ASC", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_totaltimeworkbilledgbdep'), 'tickets', "SELECT SUM('Tickets.Time Worked'), SUM('Tickets.Time Billed') FROM 'Tickets' WHERE 'Tickets.Last Activity' = ThisMonth() GROUP BY X('Tickets.Last Activity':Week), X('Tickets.Last Activity':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_totaltimeworkbilledgbowner'), 'tickets', "SELECT SUM('Tickets.Time Worked'), SUM('Tickets.Time Billed') FROM 'Tickets' WHERE 'Tickets.Last Activity' = ThisMonth() GROUP BY X('Tickets.Last Activity':Week), X('Tickets.Last Activity':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_distbslaplansgbdepthismo'), 'tickets', "SELECT COUNT(*) AS Total FROM 'Tickets' WHERE 'Tickets.Last Activity' = ThisMonth() GROUP BY X('Tickets.Last Activity':Week), X('Tickets.Last Activity':DayName), Y('Tickets.SLA Plan')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgresptimegbslathismo'), 'tickets', "SELECT AVG('Tickets.Average Response Time') FROM 'Tickets' WHERE 'Tickets.Last Activity' = ThisMonth() GROUP BY X('Tickets.Last Activity':Week), X('Tickets.Last Activity':DayName), Y('Tickets.SLA Plan')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgrepliesresgbslathismo'), 'tickets', "SELECT AVG('Tickets.Total Replies') FROM 'Tickets' WHERE 'Tickets.Last Activity' = ThisMonth() AND 'Tickets.Is Resolved' = '1' GROUP BY X('Tickets.Last Activity':Week), X('Tickets.Last Activity':DayName), Y('Tickets.SLA Plan')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgrepliesgbslathismo'), 'tickets', "SELECT AVG('Tickets.Total Replies') FROM 'Tickets' WHERE 'Tickets.Last Activity' = ThisMonth() GROUP BY X('Tickets.Last Activity':Week), X('Tickets.Last Activity':DayName), Y('Tickets.SLA Plan')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgttresolvegbslathismo'), 'tickets', "SELECT AVG('Tickets.Time to Resolve') FROM 'Tickets' WHERE 'Tickets.Last Activity' = ThisMonth() AND 'Tickets.Is Resolved' = '1' GROUP BY X('Tickets.Last Activity':Week), X('Tickets.Last Activity':DayName), Y('Tickets.SLA Plan')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_perctickfcrthismonthgbdep'), 'tickets', "SELECT ((SUM(IF('Tickets.Is First Contact Resolved', 1, 0))/COUNT(*))*100) AS FirstContactResolved FROM 'Tickets' WHERE 'Tickets.Last Activity' = ThisMonth() AND 'Tickets.Is Resolved' = '1' GROUP BY Tickets.Department", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_perctickfcrthismonthgbowner'), 'tickets', "SELECT ((SUM(IF('Tickets.Is First Contact Resolved', 1, 0))/COUNT(*))*100) AS FirstContactResolved FROM 'Tickets' WHERE 'Tickets.Last Activity' = ThisMonth() AND 'Tickets.Is Resolved' = '1' GROUP BY Tickets.Owner", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_perctickreopthismonthgbdep'), 'tickets', "SELECT ((SUM(IF('Tickets.Was Reopened', 1, 0))/COUNT(*))*100) AS ReopenedPercentage FROM 'Tickets' WHERE 'Tickets.Last Activity' = ThisMonth() GROUP BY Tickets.Department", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_perctickescthismonthgbdep'), 'tickets', "SELECT ((SUM(IF('Tickets.Is Escalated', 1, 0))/COUNT(*))*100) AS ReopenedPercentage FROM 'Tickets' WHERE 'Tickets.Last Activity' = ThisMonth() GROUP BY Tickets.Department", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgresponsetpgbstaffthismonth'), 'ticketposts', "SELECT AVG('Ticket Posts.Response Time') FROM 'Ticket Posts' WHERE 'Ticket Posts.Creation Date' = ThisMonth() AND 'Ticket Posts.Creator' = 'Staff' AND 'Ticket Posts.Response Time' != '0' GROUP BY X('Ticket Posts.Creation Date':Week), X('Ticket Posts.Creation Date':DayName), Y('Ticket Posts.Full Name')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgresponsetpgbdepthismonth'), 'ticketposts', "SELECT AVG('Ticket Posts.Response Time') FROM 'Ticket Posts' WHERE 'Ticket Posts.Creation Date' = ThisMonth() AND 'Ticket Posts.Creator' = 'Staff' AND 'Ticket Posts.Response Time' != '0' GROUP BY X('Ticket Posts.Creation Date':Week), X('Ticket Posts.Creation Date':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgresponseclienttpgbdepthismonth'), 'ticketposts', "SELECT AVG('Ticket Posts.Response Time') FROM 'Ticket Posts' WHERE 'Ticket Posts.Creation Date' = ThisMonth() AND 'Ticket Posts.Creator' = 'User' AND 'Ticket Posts.Response Time' != '0' GROUP BY X('Ticket Posts.Creation Date':Week), X('Ticket Posts.Creation Date':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgfirstresptimeticketsgbowner'), 'tickets', "SELECT AVG('Tickets.First Response Time') FROM 'Tickets' WHERE 'Tickets.Creation Date' = ThisMonth() AND 'Tickets.Creator' = 'User' AND 'Tickets.First Response Time' != '0' GROUP BY X('Tickets.Creation Date':Week), X('Tickets.Creation Date':DayName), Y('Tickets.Owner')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgfirstresptimeticketsgbdep'), 'tickets', "SELECT AVG('Tickets.First Response Time') FROM 'Tickets' WHERE 'Tickets.Creation Date' = ThisMonth() AND 'Tickets.Creator' = 'User' AND 'Tickets.First Response Time' != '0' GROUP BY X('Tickets.Creation Date':Week), X('Tickets.Creation Date':DayName), Y('Tickets.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Tickets, $_SWIFT->Language->Get('r_avgfirstresptimetpgbstaff'), 'ticketposts', "SELECT AVG('Ticket Posts.First Response Time') FROM 'Ticket Posts' WHERE 'Ticket Posts.Creation Date' = ThisMonth() AND 'Ticket Posts.Creator' = 'Staff' AND 'Ticket Posts.First Response Time' != '0' GROUP BY X('Ticket Posts.Creation Date':Week), X('Ticket Posts.Creation Date':DayName), Y('Ticket Posts.Full Name')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

        }





        /**
         * ---------------------------------------------
         * Live Chat Reports
         * ---------------------------------------------
         */
        if (in_array(APP_LIVECHAT, $_installedAppList)) {
            $_reportCategoryID_Chats = (string) SWIFT_ReportCategory::Create($_SWIFT->Language->Get('r_chats'), SWIFT_ReportCategory::VISIBLE_PUBLIC, $_SWIFT_StaffObject);
            $_reportCategoryID_ChatRouting = (string) SWIFT_ReportCategory::Create($_SWIFT->Language->Get('r_chatrouting'), SWIFT_ReportCategory::VISIBLE_PUBLIC, $_SWIFT_StaffObject);
            $_reportCategoryID_Calls = (string) SWIFT_ReportCategory::Create($_SWIFT->Language->Get('r_calls'), SWIFT_ReportCategory::VISIBLE_PUBLIC, $_SWIFT_StaffObject);

            // Chats
//            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_avgroundrobinhitsgbdepartmentthisweek'), 'chatobjects', "SELECT AVG('Chats.Round Robin Hits') FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisWeek() GROUP BY X('Chats.Creation Date':DayName), Y('Chats.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_avgroundrobinhitsgbdepartmentthismonth'), 'chatobjects', "SELECT AVG('Chats.Round Robin Hits') FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisMonth() GROUP BY X('Chats.Creation Date':Week), X('Chats.Creation Date':DayName), Y('Chats.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

//            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_avgwaittimegbdepartmentthisweek'), 'chatobjects', "SELECT AVG('Chats.Wait Time') FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisWeek() GROUP BY X('Chats.Creation Date':DayName), Y('Chats.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_avgwaittimegbdepartmentthismonth'), 'chatobjects', "SELECT AVG('Chats.Wait Time') FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisMonth() GROUP BY X('Chats.Creation Date':Week), X('Chats.Creation Date':DayName), Y('Chats.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

//            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_chatstatusmatrixthisweek'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisWeek() GROUP BY X('Chats.Creation Date':DayName), Y('Chats.Status')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_chatstatusmatrixthismonth'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisMonth() GROUP BY X('Chats.Creation Date':Week), X('Chats.Creation Date':DayName), Y('Chats.Status')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

//            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_transfermatrixgbdepartmentthisweek'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisWeek() AND 'Chats.Transfer Status' != 'None' GROUP BY X('Chats.Creation Date':DayName), Y('Chats.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_transfermatrixgbdepartmentthismonth'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisMonth() AND 'Chats.Transfer Status' != 'None' GROUP BY X('Chats.Creation Date':Week), X('Chats.Creation Date':DayName), Y('Chats.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

//            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_unansweredchatgbdepartmentthisweek'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisWeek() AND 'Chats.Status' = 'No Answer' GROUP BY X('Chats.Creation Date':DayName), Y('Chats.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_unansweredchatgbdepartmentthismonth'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisMonth() AND 'Chats.Status' = 'No Answer' GROUP BY X('Chats.Creation Date':Week), X('Chats.Creation Date':DayName), Y('Chats.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
//            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_unansweredchatgbhourdepartmentthisweek'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Status' = 'No Answer' GROUP BY 'Chats.Creation Date':Hour, Chats.Department", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_listunansweredchatgbdepartmentthisweek'), 'chatobjects', "SELECT 'Chats.Chat Mask ID', 'Chats.Subject', 'Chats.Full Name', 'Chats.Email', 'Chats.Creation Date' FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Status' = 'No Answer' AND 'Chats.Creation Date' >= ThisWeek() MULTIGROUP BY 'Chats.Creation Date':DayName, Chats.Department", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_listunansweredchatgbdepartmentthismonth'), 'chatobjects', "SELECT 'Chats.Chat Mask ID', 'Chats.Subject', 'Chats.Full Name', 'Chats.Email', 'Chats.Creation Date' FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Status' = 'No Answer' AND 'Chats.Creation Date' >= ThisMonth() MULTIGROUP BY 'Chats.Creation Date':Week, 'Chats.Creation Date':DayName, Chats.Department", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

//            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_proactivechatgbdepartmentthisweek'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisWeek() AND 'Chats.Is Proactive' = '1' GROUP BY X('Chats.Creation Date':DayName), Y('Chats.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_proactivechatgbdepartmentthismonth'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisMonth() AND 'Chats.Is Proactive' = '1' GROUP BY X('Chats.Creation Date':Week), X('Chats.Creation Date':DayName), Y('Chats.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

//            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_answeredchatgbstaffthisweek'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisWeek() AND 'Chats.Status' IN ('In Chat', 'Ended', 'Timeout') GROUP BY X('Chats.Creation Date':DayName), Y('Chats.Staff')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_answeredchatgbstaffthismonth'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisMonth() AND 'Chats.Status' IN ('In Chat', 'Ended', 'Timeout') GROUP BY X('Chats.Creation Date':DayName), Y('Chats.Staff')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

//            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_totalchatgbdepartmentthisweek'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisWeek() GROUP BY X('Chats.Creation Date':DayName), Y('Chats.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_totalchatgbdepartmentthismonth'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisMonth() GROUP BY X('Chats.Creation Date':Week), X('Chats.Creation Date':DayName), Y('Chats.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

//            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_totalchatthisweek'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisWeek() GROUP BY 'Chats.Creation Date':DayName", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_totalchatthismonth'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' AND 'Chats.Creation Date' >= ThisMonth() GROUP BY 'Chats.Creation Date':Week, 'Chats.Creation Date':DayName", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

//            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_totalchatgbcountry'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' GROUP BY 'Chats.Country'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Chats, $_SWIFT->Language->Get('r_totalchatgbcountrycity'), 'chatobjects', "SELECT COUNT(*) AS Total FROM 'Chats' WHERE 'Chats.Type' = 'User' GROUP BY 'Chats.Country', 'Chats.City'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            // Chat Routing
//            SWIFT_Report::Create($_reportCategoryID_ChatRouting, $_SWIFT->Language->Get('r_unansweredchatsgbstaffforthisweek'), 'chathits', "SELECT 'Chats.Chat Mask ID', 'Chats.Subject', 'Chats.Full Name', 'Chats.Email', 'Chat Routing.Creation Date' FROM 'Chat Routing' WHERE 'Chat Routing.Creation Date' >= ThisWeek() AND 'Chat Routing.Is Accepted' = '0' MULTIGROUP BY 'Chat Routing.Creation Date':DayName, 'Chat Routing.Staff' ORDER BY 'Chat Routing.Creation Date' ASC", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_ChatRouting, $_SWIFT->Language->Get('r_unansweredchatsgbstaffforthismonth'), 'chathits', "SELECT 'Chats.Chat Mask ID', 'Chats.Subject', 'Chats.Full Name', 'Chats.Email', 'Chat Routing.Creation Date' FROM 'Chat Routing' WHERE 'Chat Routing.Creation Date' >= ThisMonth() AND 'Chat Routing.Is Accepted' = '0' MULTIGROUP BY 'Chat Routing.Creation Date':Week, 'Chat Routing.Creation Date':DayName, 'Chat Routing.Staff' ORDER BY 'Chat Routing.Creation Date' ASC", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

//            SWIFT_Report::Create($_reportCategoryID_ChatRouting, $_SWIFT->Language->Get('r_unansweredchatcountmatrixgbstaffforthisweek'), 'chathits', "SELECT COUNT(*) AS Total FROM 'Chat Routing' WHERE 'Chat Routing.Creation Date' >= ThisWeek() AND 'Chat Routing.Is Accepted' = '0' GROUP BY X('Chat Routing.Creation Date':DayName), Y('Chat Routing.Staff')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_ChatRouting, $_SWIFT->Language->Get('r_unansweredchatcountmatrixgbstaffforthismonth'), 'chathits', "SELECT COUNT(*) AS Total FROM 'Chat Routing' WHERE 'Chat Routing.Creation Date' >= ThisMonth() AND 'Chat Routing.Is Accepted' = '0' GROUP BY X('Chat Routing.Creation Date':Week), X('Chat Routing.Creation Date':DayName), Y('Chat Routing.Staff')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

            // Call Reports
            SWIFT_Report::Create($_reportCategoryID_Calls, $_SWIFT->Language->Get('r_unansweredcallsthisweek'), 'calls', "SELECT 'Calls.Phone Number', 'Calls.Start Date', 'Calls.User Fullname', 'Calls.Staff', 'Calls.Type', 'Calls.Status' FROM 'Calls' WHERE 'Calls.Start Date' >= ThisWeek() AND 'Calls.Status' IN ('Pending', 'Rejected') ORDER BY 'Calls.Start Date' ASC", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Calls, $_SWIFT->Language->Get('r_unansweredcallsthismonth'), 'calls', "SELECT 'Calls.Phone Number', 'Calls.Start Date', 'Calls.User Fullname', 'Calls.Staff', 'Calls.Type', 'Calls.Status' FROM 'Calls' WHERE 'Calls.Start Date' >= ThisMonth() AND 'Calls.Status' IN ('Pending', 'Rejected') ORDER BY 'Calls.Start Date' ASC", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

//            SWIFT_Report::Create($_reportCategoryID_Calls, $_SWIFT->Language->Get('r_callmatrixgbstaffforthisweek'), 'calls', "SELECT COUNT(*) AS Total FROM 'Calls' WHERE 'Calls.Start Date' >= ThisWeek() GROUP BY X('Calls.Staff'), X('Calls.Type'), Y('Calls.Start Date':DayName)", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Calls, $_SWIFT->Language->Get('r_callmatrixgbstaffforthismonth'), 'calls', "SELECT COUNT(*) AS Total FROM 'Calls' WHERE 'Calls.Start Date' >= ThisMonth() GROUP BY X('Calls.Staff'), X('Calls.Type'), Y('Calls.Start Date':Week), Y('Calls.Start Date':DayName)", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

//            SWIFT_Report::Create($_reportCategoryID_Calls, $_SWIFT->Language->Get('r_avgdurationcallsgbstaffforthisweek'), 'calls', "SELECT AVG('Calls.Duration') FROM 'Calls' WHERE 'Calls.Start Date' >= ThisWeek() GROUP BY X('Calls.Staff'), X('Calls.Type'), Y('Calls.Start Date':DayName)", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Calls, $_SWIFT->Language->Get('r_avgdurationcallsgbstaffforthismonth'), 'calls', "SELECT AVG('Calls.Duration') FROM 'Calls' WHERE 'Calls.Start Date' >= ThisMonth() GROUP BY X('Calls.Staff'), X('Calls.Type'), Y('Calls.Start Date':Week), Y('Calls.Start Date':DayName)", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

//            SWIFT_Report::Create($_reportCategoryID_Calls, $_SWIFT->Language->Get('r_totaldurationcallsgbstaffforthisweek'), 'calls', "SELECT SUM('Calls.Duration') FROM 'Calls' WHERE 'Calls.Start Date' >= ThisWeek() GROUP BY X('Calls.Staff'), X('Calls.Type'), Y('Calls.Start Date':DayName)", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Calls, $_SWIFT->Language->Get('r_totaldurationcallsgbstaffforthismonth'), 'calls', "SELECT SUM('Calls.Duration') FROM 'Calls' WHERE 'Calls.Start Date' >= ThisMonth() GROUP BY X('Calls.Staff'), X('Calls.Type'), Y('Calls.Start Date':Week), Y('Calls.Start Date':DayName)", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

//            SWIFT_Report::Create($_reportCategoryID_Calls, $_SWIFT->Language->Get('r_totalincomingcallsgbdepartmentforthisweek'), 'calls', "SELECT COUNT(*) AS Total FROM 'Calls' WHERE 'Calls.Start Date' >= ThisWeek() GROUP BY Y('Calls.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Calls, $_SWIFT->Language->Get('r_totalincomingcallsgbdepartmentforthismonth'), 'calls', "SELECT COUNT(*) AS Total FROM 'Calls' WHERE 'Calls.Start Date' >= ThisMonth() AND 'Calls.Type' = 'Inbound' GROUP BY Y('Calls.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

//            SWIFT_Report::Create($_reportCategoryID_Calls, $_SWIFT->Language->Get('r_callcountgbdayforthisweek'), 'calls', "SELECT COUNT(*) AS Total FROM 'Calls' WHERE 'Calls.Start Date' >= ThisWeek() GROUP BY Y('Calls.Start Date':DayName)", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Calls, $_SWIFT->Language->Get('r_callcountgbweekforthismonth'), 'calls', "SELECT COUNT(*) AS Total FROM 'Calls' WHERE 'Calls.Start Date' >= ThisMonth() GROUP BY Y('Calls.Start Date':Week), Y('Calls.Start Date':DayName)", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

//            SWIFT_Report::Create($_reportCategoryID_Calls, $_SWIFT->Language->Get('r_callcountmatrixgbdayforthisweek'), 'calls', "SELECT COUNT(*) AS Total FROM 'Calls' WHERE 'Calls.Start Date' >= ThisWeek() GROUP BY X('Calls.Status'), Y('Calls.Start Date':DayName)", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Calls, $_SWIFT->Language->Get('r_callcountmatrixgbweekforthismonth'), 'calls', "SELECT COUNT(*) AS Total FROM 'Calls' WHERE 'Calls.Start Date' >= ThisMonth() GROUP BY X('Calls.Status'), Y('Calls.Start Date':Week), Y('Calls.Start Date':DayName)", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);


            // Rating Reports
            SWIFT_Report::Create($_reportCategoryID_Ratings,$_SWIFT->Language->Get('r_avgratlssurveygbstaffthismonth'), 'ratingresults', "SELECT AVG('Rating Results.Score') FROM 'Rating Results', 'Messages' WHERE 'Ratings.Type' = 'Chat Survey' AND 'Rating Results.Rating Date' = ThisMonth() AND 'Messages.Type' = 'Survey' GROUP BY X('Ratings.Title'), Y('Chats.Staff')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Ratings,$_SWIFT->Language->Get('r_avgratlssurveygbdepthismonth'), 'ratingresults', "SELECT AVG('Rating Results.Score') FROM 'Rating Results', 'Messages' WHERE 'Ratings.Type' = 'Chat Survey' AND 'Rating Results.Rating Date' = ThisMonth() AND 'Messages.Type' = 'Survey' GROUP BY X('Ratings.Title'), Y('Chats.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Ratings,$_SWIFT->Language->Get('r_avgratchathistgbstaffthismonth'), 'ratingresults', "SELECT AVG('Rating Results.Score') FROM 'Rating Results', 'Chats' WHERE 'Ratings.Type' = 'Chat History' AND 'Rating Results.Rating Date' = ThisMonth() GROUP BY X('Ratings.Title'), Y('Chats.Staff')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Ratings,$_SWIFT->Language->Get('r_avgratchathistgbdepthismonth'), 'ratingresults', "SELECT AVG('Rating Results.Score') FROM 'Rating Results', 'Chats' WHERE 'Ratings.Type' = 'Chat History' AND 'Rating Results.Rating Date' = ThisMonth() GROUP BY X('Ratings.Title'), Y('Chats.Department')", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Ratings,$_SWIFT->Language->Get('r_listoflssurveylsthreethismonth'), 'ratingresults', "SELECT 'Ratings.Title', 'Rating Results.Score', 'Messages.Rating', 'Chats.Chat Mask ID', 'Chats.Subject', 'Chats.Department', 'Chats.Full Name', 'Chats.Email', 'Chats.Creation Date' FROM 'Rating Results', 'Messages' WHERE 'Ratings.Type' = 'Chat Survey' AND 'Rating Results.Rating Date' = ThisMonth() AND ('Rating Results.Score' <= 3 OR 'Messages.Rating' <= 3) MULTIGROUP BY 'Chats.Staff'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);
            SWIFT_Report::Create($_reportCategoryID_Ratings,$_SWIFT->Language->Get('r_listofchathistorylsthreethismonth'), 'ratingresults', "SELECT 'Ratings.Title', 'Rating Results.Score', 'Chats.Chat Mask ID', 'Chats.Subject', 'Chats.Department', 'Chats.Full Name', 'Chats.Email', 'Chats.Creation Date' FROM 'Rating Results', 'Chats' WHERE 'Ratings.Type' = 'Chat History' AND 'Rating Results.Rating Date' = ThisMonth() AND 'Rating Results.Score' <= 3 MULTIGROUP BY 'Chats.Staff'", $_SWIFT_StaffObject, SWIFT_Report::VISIBLE_PUBLIC);

        }

        return true;
    }

}
?>
