<?php
    /**
    * ###############################################
    *
    * SWIFT Framework
    * _______________________________________________
    *
    * @author         Varun Shoor
    *
    * @package        SWIFT
    * @copyright      Copyright (c) 2001-2012, Kayako
    * @license        http://www.kayako.com/license
    * @link           http://www.kayako.com
    *
    * ###############################################
    */

    // Initial pass done
    // Usage script run

    $__LANG = array(
    'settings'                             => 'Settings',
    'loginsharesettings'                   => 'LoginShare Settings',
    'staff'                                => 'Staff',
    'users'                                => 'Users',
    'restapi'                              => 'REST API',
    'reports'                              => 'Reports',
    'groups'                               => 'Groups',
    'titleurlinvaliddata'                  => 'Invalid URL format',
    'desc_titleurlinvaliddata'             => 'This URL does not look like it is in the correct format; please check and try again.',

    // ======= SETTING GROUPS =======
    'settings_general'                     => 'General',
    'settings_cpu'                         => 'Server settings and performance',
    'settings_security'                    => 'Security',
    'settings_datetime'                    => 'Date and time',
    'settings_tickets'                     => 'Tickets',
    'settings_parser'                      => 'Email parser',
    'settings_tr'                          => 'Troubleshooter',
    'settings_users'                       => 'User accounts and organizations',
    'settings_nw'                          => 'News',
    'settings_kb'                          => 'Knowledgebase',
    'settings_mail'                        => 'Email',
    'settings_livechat'                    => 'Live support',
    'settings_loginshare'                  => 'LoginShare',

    // ======= IMPORT FROM v3 CVS =======
    't_searchticketidinbody'               => 'Search for ticket ID in email body',
    'd_t_searchticketidinbody'             => 'If a ticket ID cannot be found in the email subject, the helpdesk will search for a ticket ID in the body of an email.',

    // ======= GENERAL SETTINGS =======
    'd_customurl'                          => 'If you wish to update the domain name, contact GFI support team: <a href="https://support.gfi.com" target="_blank" rel="noopener noreferrer">https://support.gfi.com</a>',
    'd_customurlwarning'                   => 'If you need to change the domain name, follow the instructions in <a target="_blank" rel="noopener noreferrer" href="%s">this guide</a>.',
    'general_companyname'                  => 'Organization name',
    'd_general_companyname'                => 'The organization name will be used to brand the support center and outgoing emails. For example: <em>Acme Inc</em>.',
    'general_producturl'                   => 'Helpdesk base URL',
    'd_general_producturl'                 => 'The full URL to the helpdesk, including a trailing slash. For example: <em>https://support.acme.com/</em>',
    'general_returnemail'                  => 'Default return email address',
    'd_general_returnemail'                => 'This address will be used as the return address for emails sent from the helpdesk. Ideally, a corresponding email queue should be configured so that replies from your users can be pulled into the helpdesk.',
    'general_themeoptions'                 => 'Control Panels',
    'g_displaytopheader'                   => 'Display logo in the header',
    'd_g_displaytopheader'                 => 'The logo will be displayed in the header of the control panel.',
    'g_onlusr'                             => 'Display online staff',
    'd_g_onlusr'                           => 'Show a list of online staff users in the control panels.',
    'g_api'                                => 'API Settings',
    'g_enableapiinterface'                 => 'Enable API',
    'd_g_enableapiinterface'               => 'Toggle whether the helpdesk API is active or not.',
    'g_generalsettings'                    => 'General Settings',
    'g_maxtagcloud'                        => 'Maximum number of tags in the tag cloud',
    'd_g_maxtagcloud'                      => 'The maximum number of tags that will be shown in the staff control panel tag cloud.',
    'g_maxsearchresults'                   => 'Maximum number of search results',
    'd_g_maxsearchresults'                 => 'The maximum number of search results that will be returned for searches in the support center.',

    // ======= CPU SAVING & OPTIMIZATION =======
    'cpu_attachments'                      => 'Attachment Settings',
    'cpu_attachtype'                       => 'Storage location for file attachments',
    'd_cpu_attachtype'                     => 'The recommended location is <strong>in the file system</strong>.',
    'database'                             => 'In the database',
    'files'                                => 'In the file system (/files/ directory)',
    'cpu_attachchunksize'                  => 'Database attachment chunk size',
    'd_cpu_attachchunksize'                => 'If storing attachments in the database, they will be chunked into parts no bigger than this size (in bytes). This should be smaller than the <strong>maximum packet size</strong> setting in your MySQL configuration file.',
    'cpu_optimization'                     => 'Optimizations',
    'cpu_winappcompresslevel'              => 'gzip compression level',
    'd_cpu_winappcompresslevel'            => 'Select the gzip compression level for pages rendered by the helpdesk. A higher value results in smaller pages, but greater demand on the server. Nowadays, connections are fast enough that a <em>1</em> is suitable.',
    'nocompression'                        => 'No compression',
    'reccompression'                       => 'Recommended',
    'highestcompression'                   => 'Highest',
    'cpu_compresswinappdata'               => 'Compress Kayako Desktop data',
    'd_cpu_compresswinappdata'             => '',
    'cpu_hidereportexportxlsoption'          => 'Hide Export Report to Excel Option from all Staff Members',
    'd_cpu_hidereportexportxlsoption'        => 'It is advisable to keep Export report to excel option hidden in case of peak load conditions.',
    'cpu_logcleardays'                     => 'Log retention time',
    'd_cpu_logcleardays'                   => 'The number of days after which logs will be deleted from the helpdesk.',
    'cpu_mailsettings'                     => 'Outgoing Mail Settings',
    'cpu_enablehtmlmails'                  => 'Send HTML emails',
    'd_cpu_enablehtmlmails'                => 'All email sent from the helpdesk will be sent using HTML (as well as a plain text version).',
    'cpu_enablemailqueue'                  => 'Queue outgoing emails',
    'd_cpu_enablemailqueue'                => 'The helpdesk will send outgoing emails in batches, rather than all at once. This can prevent the helpdesk slowing down when sending bulk mail.',
    'cpu_mailqueuebatch'                   => 'Email batch size',
    'd_cpu_mailqueuebatch'                 => 'The number of emails to send per batch.',
    'cpu_smtp'                             => 'SMTP Settings',
    'cpu_enablesmtp'                       => 'Use an SMTP server to send email',
    'd_cpu_enablesmtp'                     => 'By default, Kayako will use the server\'s own mail handler to send email (PHP mail()) unless an SMTP server is configured here.',
    'cpu_smtphost'                         => 'SMTP server hostname',
    'd_cpu_smtphost'                       => 'For example: <em>smtp.gmail.com</em>.',
    'cpu_smtpport'                         => 'SMTP server port',
    'd_cpu_smtpport'                       => 'This is usually port number <strong>25</strong>.',
    'cpu_smtpportssl'                      => 'SMTP port (TLS/SSL)',
    'd_cpu_smtpportssl'                    => 'This is usually port number <strong>465</strong>.',
    'cpu_smtpuseauth'                      => 'Use SMTP authentication',
    'd_cpu_smtpuseauth'                    => 'If the SMTP server specified above requires authentication, enable this setting and enter the credentials below.',
    'cpu_smtpuser'                         => 'SMTP server username',
    'd_cpu_smtpuser'                       => '',
    'cpu_smtppass'                         => 'SMTP server password',
    'd_cpu_smtppass'                       => '',
    'cpu_smtptype'                         => 'SMTP connection type',
    'd_cpu_smtptype'                       => 'If you are not sure what this is, contact your server administrator.',
    'smtpssl'                              => 'SSL',
    'smtptls'                              => 'TLS',
    'smtpnonssl'                           => 'Non SSL',
    'smtpssl2'                             => 'SSL v2',
    'smtpssl3'                             => 'SSL v3',
    'encqp'                                => 'quoted-printable',
    'encbase64'                            => 'base64',
    'encbinary'                            => 'binary',
    'cpu_headerencoding'                   => 'Email header encoding',
    'd_cpu_headerencoding'                 => 'The encoding scheme to use for email MIME headers. The default is base64.',
    'cpu_messageencoding'                  => 'Message body encoding',
    'd_cpu_messageencoding'                => 'The encoding scheme to use for email message bodies. The default is quoted-printable.',
    'cpu_maildefaultpriority'              => 'Default mail priority',
    'd_cpu_maildefaultpriority'            => 'All email from the helpdesk will be sent with this priority. This is different to ticket priorities.',
    'mailprioritylow'                      => 'Low (5)',
    'mailprioritynormal'                   => 'Normal (3)',
    'mailpriorityhigh'                     => 'High (1)',

    // ======= SECURITY =======
    'security_sessioninactivity'           => 'Session expiry',
    'd_security_sessioninactivity'         => 'The time (in seconds) after which a user\'s idle session will be removed.',
    'security_sessionvar'                  => 'Session Variable Type',
    'security_visitorinactivity'           => 'Session expiry for site visitors',
    'd_security_visitorinactivity'         => 'The time (in seconds) that a visitor has to be idle for until their session is removed (and are no longer tracked in Kayako Desktop).',
    'security_cookiedomain'                => 'Cookie domain',
    'd_security_cookiedomain'              => 'If there are multiple Kayako installations sharing the same domain name, specify the cookie domain here.',
    'security_cookiepath'                  => 'Cookie path',
    'd_security_cookiepath'                => 'If there are multiple Kayako installations sharing the same domain name, specify the cookie path here.',
    'cookie'                               => 'Cookie',
    'url'                                  => 'URL',
    'urlcookie'                            => 'URL &amp; Cookie',
    'security_staffpasswordpolicy'         => 'Staff Password Policy',
    'security_scpasswordpolicy'            => 'Support Center Users Password Policy',
    'security_sppminchars'                 => 'Minimum password length',
    'security_scpminchars'                 => 'Minimum password length',
    'd_security_sppminchars'               => 'Staff passwords must be longer than this length.',
    'd_security_scpminchars'               => 'User passwords must be longer than this length.',
    'security_sppminnumbers'               => 'Minimum number of digits',
    'security_scpminnumbers'               => 'Minimum number of digits',
    'd_security_sppminnumbers'             => 'Staff passwords must include at least this number of digits.',
    'd_security_scpminnumbers'             => 'User passwords must include at least this number of digits.',
    'security_sppminsymbols'               => 'Minimum number of symbols',
    'security_scpminsymbols'               => 'Minimum number of symbols',
    'd_security_sppminsymbols'             => 'Staff passwords must include at least this number of symbols.',
    'd_security_scpminsymbols'             => 'User passwords must include at least this number of symbols.',
    'security_sppmincapitalchars'          => 'Minimum number of capitalized letters',
    'security_scpmincapitalchars'          => 'Minimum number of capitalized letters',
    'd_security_sppmincapitalchars'        => 'Staff passwords must include at least this number of UPPERCASE characters.',
    'd_security_scpmincapitalchars'        => 'User passwords must include at least this number of UPPERCASE characters.',
    'security_sppexpiredays'               => 'Password expires after',
    'd_security_sppexpiredays'             => 'Staff will be asked to create a new password after this number of days. Set to <em>0</em> to never expire.',
    'security_captcha'                     => 'CAPTCHA Settings',
    'security_comment_settings'            => 'Comments Settings',
    'security_captchatype'                 => 'CAPTCHA type',
    'captchalocal'                         => 'Use standard CAPTCHA',
    'captcharecaptcha'                     => 'Use ReCAPTCHA',
    'd_security_captchatype'               => 'ReCAPTCHA is a more effective CAPTCHA service. For more information, see <a href="http://www.recaptcha.net" target="_blank" rel="noopener noreferrer">recaptcha.net</a>. To use ReCAPTCHA, you will need to create a free ReCAPTCHA account and complete the details below.',
    'security_recpublickey'                => 'ReCAPTCHA public key',
    'd_security_recpublickey'              => 'If using ReCAPTCHA (specified above), enter your public key.',
    'security_recprivatekey'               => 'ReCAPTCHA private key',
    'd_security_recprivatekey'             => 'If using ReCAPTCHA (specified above), enter your private key.',
    'security_autoapprovecomments'         => 'Automatically approve comments',
    'd_security_autoapprovecomments'       => 'The helpdesk will automatically approve comments and they will be immediately visible in the support center. If disabled, they will not be visible until approved by staff.',
    'security_enableakismet'               => 'Enable Akismet spam checking for comments',
    'd_security_enableakismet'             => 'Akismet is an anti-spam service for comments. For more information, visit <a href="http://akismet.com" target="_blank" rel="noopener noreferrer">akismet.com</a>. To use Akismet you will need to register for a free account and API key.',
    'security_akismetkey'                  => 'Akismet API key',
    'd_security_akismetkey'                => 'Your Akismet API key.',
    'security_commentscaptcha'             => 'Require CAPTCHA for comments',
    'd_security_commentscaptcha'           => 'Users will be asked to complete a CAPTCHA while posting a comment to verify that they are human.',
    'security_loginpolicy'                 => 'Login Protection',
    'security_securesessions'              => 'Enable secure sessions',
    'd_security_securesessions'            => 'This setting will prevent an attacker from capturing your staff user\'s session data and hijacking their helpdesk session.',
    'security_scloginpolicy'               => 'Login Protection For Support Center Users',
    'security_loginlocked'                 => 'Prevent staff from logging in for a period of time after too many failed login attempts',
    'security_scloginlocked'               => 'Prevent user from logging in for a period of time after too many failed login attempts',
    'd_security_loginlocked'               => 'Staff will be prevented from trying to log in to the helpdesk if they enter the wrong credentials too many times.',
    'd_security_scloginlocked'             => 'User will be prevented from trying to log in to the helpdesk if they enter the wrong credentials too many times.',
    'security_loginattempts'               => 'Number of failed login attempts before lockout',
    'security_scloginattempts'             => 'Number of failed login attempts before lockout',
    'd_security_loginattempts'             => 'After this number of failed login attempts, the staff user will be prevented from trying to login again.',
    'd_security_scloginattempts'           => 'After this number of failed login attempts, the end user will be prevented from trying to login again.',
    'security_loginlockedtimeline'         => 'Remove lockout after',
    'security_scloginlockedtimeline'       => 'Remove lockout after',
    'd_security_loginlockedtimeline'       => 'The number of seconds the staff user has to wait before they can try to login again.',
    'd_security_scloginlockedtimeline'     => 'The number of seconds the end user has to wait before they can try to login again.',
    'security_sessionipcheck'              => 'Validate sessions by checking IP address',
    'd_security_sessionipcheck'            => 'Secure against cookie and session hijacking by validating the IP address of a user each time they interact with Kayako. We recommend enabling this setting if you do not use secure connections (https://).<br /><br /><strong>More information:</strong><br />Each time a user logs in to Kayako, a session is created. Each session is linked to the IP address of a user. When this setting is enabled, each interaction with Kayako is validated by checking the user\'s current IP address with the one used to create the session. If they don\'t match, the user will need to log in again. If you regularly use an Internet service with dynamic IP addresses that change often, you may wish to disable this setting to prevent your staff users from being logged out.',

    // ======= LOGINSHARE =======
    'loginshare_staff'                     => 'Staff LoginShare Settings',
    'loginshare_staffenable'               => 'Enable external authentication for staff',
    'd_loginshare_staffenable'             => 'The helpdesk will attempt to authenticate staff users using the external LoginShare API (specified below).',
    'loginshare_stafftitle'                => 'Staff LoginShare API name',
    'd_loginshare_stafftitle'              => 'For example, <em>My Active Directory server</em>.',
    'loginshare_staffurl'                  => 'Staff LoginShare API URL',
    'd_loginshare_staffurl'                => 'Enter the URL to the LoginShare API endpoint to use to authenticate staff. <a href="https://go.gfi.com/?pageid=GFIHelpDeskLoginShare" target="_blank" rel="noopener noreferrer">Find out more about LoginShare</a>.',

    'loginshare_user'                      => 'User LoginShare Settings',
    'loginshare_userenable'                => 'Enable external authentication for users',
    'd_loginshare_userenable'              => 'The helpdesk will attempt to authenticate users using the external LoginShare API (specified below).',
    'loginshare_usertitle'                 => 'User LoginShare API name',
    'd_loginshare_usertitle'               => 'For example, <em>My Active Directory server</em>.',
    'loginshare_userurl'                   => 'User LoginShare API URL',
    'd_loginshare_userurl'                 => 'Enter the URL to the LoginShare API endpoint to use to authenticate users.  <a href="https://go.gfi.com/?pageid=GFIHelpDeskLoginShare" target="_blank" rel="noopener noreferrer">Find out more about LoginShare</a>.',

    // ======= DATE & TIME =======
    'dtcalus'                              => 'US (mm/dd/yy + 12hr)',
    'dtcaleu'                              => 'EU (dd/mm/yy + 24hr)',
    'dt_caltype'                           => 'Date picker format',
    'd_dt_caltype'                         => 'This date and time format will be used by the date picker (a popup calendar for easy date and time selection).',
    'dt_dateformat'                        => 'Date format',
    'd_dt_dateformat'                      => 'The helpdesk will format all dates this way. For more information on this syntax, see <a href="http://www.php.net/strftime" target="_blank" rel="noopener noreferrer">strftime()</a>.',
    'dt_timeformat'                        => 'Time format',
    'd_dt_timeformat'                      => 'The helpdesk will format all times this way.',
    'dt_datetimeformat'                    => 'Date and time format',
    'd_dt_datetimeformat'                  => 'Where dates and times are displayed together, the helpdesk will format them this way.',
    'dt_timezonephp'                       => 'Helpdesk default time zone',
    'd_dt_timezonephp'                     => 'This is the default helpdesk time zone. Unless staff and users specify their own respective time zones, this default timezone will be used.',
    'dt_daylightsavings'                   => 'Automatically detect daylight savings time',
    'd_dt_daylightsavings'                 => 'The helpdesk will detect when daylight savings time is in effect and will adjust times accordingly.',

    // ======= LIVE CHAT =======
    'livesupport_routingsettings'          => 'Queueing Settings',
    'ls_routingmode'                       => 'Live chat queueing mode',
    'd_ls_routingmode'                     => '<strong>Round robin</strong> Kayako will send an incoming chat request to the least busy available staff. If they don\'t accept the request, the next least busy staff will be tried.<br /><strong>Open queue</strong> Incoming chat requests will be added to an open queue, where all available staff will be alerted to the new chat request at once. If no one picks up the request, the chat will remain in the queue until someone does.',
    'ls_roundrobin'                        => 'Round robin',
    'ls_openqueue'                         => 'Open queue',
    'ls_openqueuetimeout'                  => 'Maximum wait time',
    'd_ls_openqueuetimeout'                => 'The maximum time (in seconds) that a chat request can wait in an <em>open queue</em> before the user is invited to leave a message instead.',
    'livesupport_roundrobinretries'        => 'Maximum number of round robin tries',
    'd_livesupport_roundrobinretries'      => 'The maximum number of staff the helpdesk will try before inviting the user to leave a message instead.',
    'livesupport_roundrobintimetry'        => 'Round robin try interval',
    'd_livesupport_roundrobintimetry'      => 'The time in seconds that the helpdesk will wait for a staff to accept a chat request. If they do not accept the request in time, the helpdesk will move onto the next staff user.',
    'livesupport_displayclientchatqueue'   => 'Show visitor how many chats are in queue',
    'd_livesupport_displayclientchatqueue' => 'To give an indication to the user how long they will be waiting in the queue, the helpdesk will display how many chats are ahead of them.',
    'livesupport_pagerefresh_invalid'      => 'Visitor data refresh interval invalid',
    'd_livesupport_pagerefresh_invalid'    => 'Visitor data refresh interval must be an integer and greater than or equal 60',
    'livesupport_chatrefresh_invalid'      => 'Chat refresh interval invalid',
    'd_livesupport_chatrefresh_invalid'    => 'Chat refresh interval must be an integer and greater than or equal 10',

    'livesupport_clientchatsettings'       => 'Visitor &amp; Chat Settings',
    'livesupport_chatwidth'                => 'Chat window width',
    'd_livesupport_chatwidth'              => 'The width of the visitor\'s chat window (in pixels).',
    'livesupport_chatheight'               => 'Chat window height',
    'd_livesupport_chatheight'             => 'The height of the visitor\'s chat window (in pixels).',
    'livesupport_clientchatrefresh'        => 'Chat refresh interval',
    'd_livesupport_clientchatrefresh'      => 'A visitor\'s chat window will refresh at this interval (in seconds). A lower value will improve the responsiveness of the chat system, but will increase the demand on the web server.',
    'livesupport_clientpagerefresh'        => 'Visitor data refresh interval',
    'd_livesupport_clientpagerefresh'      => 'Live chat tracking code placed on your web pages will update the helpdesk with visitor information at this interval (in seconds).',
    'livesupport_cachehtmljscode'          => 'Tell visitor\'s browser to cache tracking code',
    'd_livesupport_cachehtmljscode'        => 'The helpdesk will tell the user\'s browser to cache the live chat JavaScript code to improve page load times.',

    'livesupport_winappsettings'           => 'Kayako Desktop Settings',
    'livesupport_searchbgcolor'            => 'Search engine visitor background color',
    'd_livesupport_searchbgcolor'          => 'The background color for a visitor that has been referred to the site by a search engine.',
    'livesupport_searchfrcolor'            => 'Search engine visitor text color',
    'd_livesupport_searchfrcolor'          => 'The text color for a visitor that has been referred to the site by a search engine.',

    'ls_clientarea'                        => 'Support Center Settings',
    'ls_displaystatus'                     => 'Display live support status button',
    'd_ls_displaystatus'                   => 'The helpdesk will show a button indicating live support status (online, offline, busy or be right back).',
    'ls_depname'                           => 'Hide staff names in chats',
    'd_ls_depname'                         => 'The helpdesk will instead use the department name in place of the staff user\'s name.',
    'livesupport_alertttl'                 => 'Visitor rule alert timeout',
    'd_livesupport_alertttl'               => 'Visitor rules can be configured to trigger special alert popups, and will stay on the screen for this amount of time (in seconds).',
    'livesupport_clicktocallsettings'      => 'Click to Call Settings',
    'ls_activecountrycode'                 => 'Your local country code (ITU-T)',
    'd_ls_activecountrycode'               => 'Kayako Desktop can distinguish between local and internatinal calls based on your own local country code, for example: <em>1</em> for the US and <em>44</em> for the UK.',
    'ls_ignoreactivecountrycode'           => 'Do not add country code to calls from local numbers',
    'd_ls_ignoreactivecountrycode'         => 'The helpdesk will not automatically prefix local numbers with your local country code, specified above.',
    'ls_internationalcallprefix'           => 'International call prefix',
    'd_ls_internationalcallprefix'         => 'If your phone provider requires a prefix to dial international numbers, enter it here and Kayako Desktop will add the prefix to outbound international calls automatically.',
    'ls_recordphonecalls'                  => 'Record phone calls',
    'd_ls_recordphonecalls'                => 'Kayako Desktop will upload call recordings to the helpdesk, which can be then played back from the staff control panel.',
    'ls_enableinternationalcalls'          => 'International call requests allowed',
    'd_ls_enableinternationalcalls'        => 'The helpdesk will allow visitors to make click to call requests to international numbers.',
    'livechat_ignorerange'                 => 'Ignore visitors from IP addresses',
    'd_livechat_ignorerange'               => 'Visitors with IP addresses specified here (separated by comma) will be ignored.',

    'livechat_proactivescroll'             => 'Animate floating proactive chat invitation',
    'd_livechat_proactivescroll'           => 'When a visitor is invited to a chat (either by staff or a visitor rule), the invitation popover will animate.',
    'livechat_timestamps'                  => 'Display timestamps in chat',
    'd_livechat_timestamps'                => 'The helpdesk will display timestamps next to each message exchanged in a chat.',
    'livechat_timestampformat'             => 'Timestamp format',
    'd_livechat_timestampformat'           => 'When reviewing chat logs in the staff control panel, timestamps will be displayed in this format.',
    'ls_forcerandomnumber'                 => 'Generate new live support button on each page load',
    'd_ls_forcerandomnumber'               => 'By default, live support buttons are cached for a short time to reduce the demand placed on the server. Enabling this option will request a new, up to date button every time a visitor loads a page with a button.',

    // ======= EMAIL PARSER =======
    'pr_createnewticket'                   => 'Create a new ticket for replies sent to resolved tickets',
    'd_pr_createnewticket'                 => 'Rather than reopening the ticket, the helpdesk will create a new ticket if the reply was sent to a resolved ticket. Note that this setting will override an email rule for <em>always create a new ticket</em>.',
    'pr_allowmultiplecreation'             => 'Create multiple tickets for all email queues',
    'd_pr_allowmultiplecreation'           => 'If someone sends an email to multiple helpdesk email addresses, the helpdesk will create multiple tickets for each email queue address.',
    'pr_generalparser'                     => 'Email Parser Settings',
    'pr_contentpriority'                   => 'Prioritize email content type',
    'd_pr_contentpriority'                 => 'Most email contains two formats, <strong>plain text</strong> and <strong>HTML</strong>. The helpdesk will prioritize this content type when processing email rules. <em>Plain text</em> is highly recommended.',
    'text'                                 => 'Plain text',
    'html'                                 => 'HTML',
    'pr_stripscript'                       => 'Strip &lt;script&gt; tags',
    'd_pr_stripscript'                     => '<strong>&lt;script&gt; tags</strong> can be used to load JavaScript. Enabling this setting is strongly recommended to prevent any malicious code being loaded in a staff user\'s browser.',
    'pr_logoptions'                        => 'Email Parser Log Options',
    'pr_enablelog'                         => 'Enable email logging',
    'd_pr_enablelog'                       => 'The helpdesk will log original copies of all emails coming into the helpdesk. Enabling this setting is strongly recommended so that any email related problems can be diagnosed, if they occur.',
    'pr_enablelog_notification'            => 'Enable failure notifications',
    'd_pr_enablelog_notification'          => 'The helpdesk will send all the failure logs to admin email address. if they occur. This does add overhead and could potentially slow down parsing.',
    'pr_logchurndays'                      => 'Keep email logs for',
    'd_pr_logchurndays'                    => 'The amount of time in days that email logs will be retained.',
    'pr_maxlogsize'                        => 'Maximum email log size',
    'd_pr_maxlogsize'                      => 'The maximum size (in kilobytes) of email log that will be retained. Email logs larger than this size will not be retained.',
    'pr_pop3'                              => 'POP3/IMAP Email Download Settings',
    'pr_procno'                            => 'Maximum number of emails to download in a batch',
    'd_pr_procno'                          => 'The email parser downloads email from mailboxes in batches of this size.',
    'pr_sizelimit'                         => 'Email size limit',
    'd_pr_sizelimit'                       => 'Email larger than this size (in kilobytes) will not be downloaded into the helpdesk.<br /><br/><strong>Kayako Download customers note:</strong> This must be less than the <em>php_memory_limit</em> setting in your <em>php.ini</em>.',
    'pr_parsereplyto'                      => 'Prioritize <strong>reply-to</strong> above <strong>from</strong> addresses',
    'd_pr_parsereplyto'                    => 'The helpdesk will use the email address in the <strong>reply-to</strong> rather than the <strong>from</strong> email header. <strong>Warning</strong> - it is easier to fake <em>reply-to</em>, we do not recommend enabling this setting.',
    'pr_conversion'                        => 'Automatically convert encoding of emails',
    'd_pr_conversion'                      => 'The helpdesk will automatically convert the encoding of incoming email to the default helpdesk character set.',
    'pr_loopoptions'                       => 'Email Loop Blocker Settings',
    'pr_loopcut_prevents_autoresponder'    => 'Stop sending autoresponders if loop detected',
    'd_pr_loopcut_prevents_autoresponder'  => 'The helpdesk will stop sending autoresponders to a particular address it thinks is in an email loop. This setting should be left on, except when diagnosing a problem.',
    'pr_loopcut_ignores_cut_mail'          => 'Ignore email completely',
    'd_pr_loopcut_ignores_cut_mail'        => 'If the helpdesk thinks a particular email is part of an email loop, it will ignore the email completely.',
    'titlephpinierror'                     => 'ERROR: Email size limit too large',
    'msgphpinierror'                       => 'Your email size limit exceeds the memory limit set in your php.ini file. Please set your email size limit to less than %s in the email parser settings.',

    // ======= TICKETS =======
    't_cleanmailsubjects'                  => 'Clean email subjects',
    'd_t_cleanmailsubjects'                => 'If enabled, ticket meta will be suffixed (using a + sign) to the <strong>from</strong> email address (sales+r.abc.123@acme.com) for emails sent by the helpdesk, rather than being included in the email subject.',
    't_spamhandling'                       => 'Spam Handling',
    't_spammovetotrash'                    => 'Automatically move spam to trash',
    'd_t_spammovetotrash'                  => 'Tickets marked as spam will be automatically moved to trash.',
    't_spamban'                            => 'Ban spam email addresses',
    'd_t_spamban'                          => 'Email addresses of tickets marked as spam will be automatically banned.',
    't_restrictnewticket'                  => 'Staff can only create new tickets in their assigned departments',
    'd_t_restrictnewticket'                => 'Staff will only be able to create new tickets in departments they or their team have been assigned.',
    't_autorecip'                          => 'Automatically add CCd email addresses as ticket recipients',
    'd_t_autorecip'                        => 'If an email is received by the helpdesk and it contains CCd email addresses, these email addresses will automatically be added as ticket recipients.',
    't_autorespondercc'                    => 'Send autoresponder to CCd recipients',
    'd_t_autorespondercc'                  => 'The helpdesk will send an autoresponder confirming receipt of their email to CCd recipients.',
    't_parser'                             => 'Email Parser Settings',
    't_pstaffreply'                        => 'Staff can reply to tickets by email',
    'd_t_pstaffreply'                      => 'Staff will be able to reply to tickets by replying to helpdesk notification emails. Their reply will be processed by the helpdesk, added to the ticket and a notification will be sent out to the ticket\'s recipients.',
    't_sla'                                => 'SLA Settings',
    't_encustomoverdue'                    => 'Use default reply and resolution deadlines',
    'd_t_encustomoverdue'                  => 'The times below will be used to calculate ticket reply and resolution deadlines if an SLA plan is not assigned to the ticket, user, user group or department.',
    't_overduehrs'                         => 'Default reply time deadline',
    'd_t_overduehrs'                       => 'If a user is not responded to within these hours, the ticket will be marked as overdue.',
    't_resolutionduehrs'                   => 'Default resolution deadline',
    'd_t_resolutionduehrs'                 => 'If a ticket is not resolved within these hours, the ticket will be marked as overdue.',
    'tickets_resattachments'               => 'Use file attachment type whitelist',
    'd_tickets_resattachments'             => 'Only the file types listed (<em>Tickets &rarr; File Types</em>) will be accepted into the helpdesk if enabled.',
    'tickets_parseemlattachment'           => 'Parse .eml and .msg attachment',
    'd_tickets_parseemlattachment'         => 'If enabled .eml and .msg attachments will be parsed as attachments, else they will get parse inline with in the Ticket Body',
    't_general'                            => 'General Ticket Settings',
    't_tpreview'                           => 'Show ticket preview when hovering',
    'd_t_tpreview'                         => 'A ticket preview will be displayed when a ticket is hovered in the main ticket listing.',
    't_postlimit'                          => 'Ticket replies per page',
    'd_t_postlimit'                        => 'The maximum number of ticket replies to show before splitting across multiple pages.',
    't_ochtml'                             => 'HTML handling (for staff replies)',
    'd_t_ochtml'                           => 'Specify how the helpdesk should handle HTML in email replies sent by staff users. This will affect the content that ultimately reaches the user.<br /><br /><strong>Convert to HTML entities</strong> Converts HTML to normal text so that you can see the code.<br /><strong>Strip HTML tags</strong> Removes HTML completely (except for the tags specified below in <em>Allowed HTML tags</em>), leaving just the text.<br /><strong>Allow HTML</strong> Allow HTML code to be displayed. This setting is <strong>not</strong> recommended as it could allow malicious code to be executed in staff users\' web browsers and/or email client applications.',
    't_chtml'                              => 'HTML handling (on the web and in email notifications)',
    'd_t_chtml'                            => 'Specify how the helpdesk should handle HTML when displaying ticket posts on the web and in notification emails.<br /><br /><strong>Convert to HTML entities</strong> Converts HTML to normal text so that you can see the code.<br /><strong>Strip HTML tags</strong> Removes HTML completely (except for the tags specified below in <em>Allowed HTML tags</em>), leaving just the text.<br /><strong>Allow HTML</strong> Allow HTML code to be displayed. This setting is <strong>not</strong> recommended as it could allow malicious code to be executed in staff users\' web browsers and/or email client applications.',

    't_allowhtml'                          => 'Allow some HTML tags',
    'd_t_allowhtml'                        => 'The helpdesk will allow some HTML tags (specified below), even if <strong>Strip HTML tags</strong> is enabled.',
    't_allowableadvtags'                   => 'Allowed HTML tags',
    'd_t_allowableadvtags'                 => 'The helpdesk will allow these tags if <strong>Allow some HTML tags</strong> is enabled.',
    't_allowableadvtagsattributes'         => 'Allowed HTML attributes',
    'd_t_allowableadvtagsattributes'       => 'The helpdesk will allow these attributes if <strong>Allow some HTML tags</strong> is enabled.',

    't_postorder'                          => 'Display order for ticket replies',
    'd_t_postorder'                        => 'Specify how ticket posts are displayed for staff viewing their tickets in the staff control panel.',
    'tcentities'                           => 'Convert to HTML entities',
    'tchtml'                               => 'Allow HTML',
    'tchtmlpurifier'                       => 'HTML Purifier',
    'tcstrip'                              => 'Strip HTML tags',
    't_enpagin'                            => 'Split ticket replies across pages',
    'd_t_enpagin'                          => 'Rather than listing every ticket reply on the same page, enable this setting to split replies across multiple pages.',
    't_tinymceeditor'                      => 'Enable TinyMCE Editor',
    'd_t_tinymceeditor'                    => 'Use the TinyMCE editor (rich text) for creating new tickets or ticket replies.',
    't_editor_format'                      => 'Treat content as',
    'd_t_editor_format'                    => 'Select how the text editor will treat the contents for new tickets and ticket replies',
    'newestfirst'                          => 'Newest reply first',
    'oldestfirst'                          => 'Oldest reply first',
    't_overduecolor'                       => 'Overdue ticket background color',
    'd_t_overduecolor'                     => 'Overdue tickets can be highlighted with a background color. Choose a light color so the text is still readable.',
    't_ticketnoteresetsupdatetime'         => 'Clear reply due deadline when adding a ticket note',
    'd_t_ticketnoteresetsupdatetime'       => 'When a ticket is updated (i.e. replied to by a staff user), the reply due time clock is reset. By enabling this setting, a ticket note will also count as a ticket update.',
    't_resultlimit'                        => 'Limit search results',
    'd_t_resultlimit'                      => 'The maximum number of ticket search results. Setting this too high may cause searches to take too long.',
    't_mailset'                            => 'Email Settings',
    't_clientarea'                         => 'Support Center Settings',
    't_eticketid'                          => 'Ticket ID type',
    'd_t_eticketid'                        => '',
    'tsequential'                          => 'Sequential (#1, #2, #3... #5263458)',
    'trandom'                              => 'Random (#JRQ-368-3621, #BHJ-591-1832)',
    't_slaresets'                          => 'Clear reply due deadline on staff reply',
    'd_t_slaresets'                        => 'When a staff user replies to a ticket, the ticket reply due deadline will be cleared. A new reply due deadline will be calculated when a user next replies to the ticket.',
    't_cstaffname'                         => 'Override staff <em>from</em> name in emails',
    'd_t_cstaffname'                       => 'By default, staff names will be used as the <em>from</em> name in ticket replies from the helpdesk. Enable this setting to use the same from name (specified below) for every email.',
    't_cdisplayname'                       => 'Override <strong>from</strong> name with',
    'd_t_cdisplayname'                     => 'This name will be used for outgoing ticket replies by staff users (instead of their own name), if the setting above is enabled.',
    't_cthirdparty'                        => 'Show third-party ticket replies',
    'd_t_cthirdparty'                      => 'Replies to tickets made by third-party recipients will be visible to users browsing their ticket history in the support center.',
    't_cenattach'                          => 'Users can attach files to tickets',
    'd_t_cenattach'                        => 'Users will be able to attach files when creating or replying to tickets in the support center.',
    't_cpostorder'                         => 'Display order for ticket replies',
    'd_t_cpostorder'                       => 'Specify how ticket posts are displayed for users viewing their tickets in the support center.',
    't_ccaptcha'                           => 'Require users to complete a CAPTCHA when submitting tickets',
    'd_t_ccaptcha'                         => 'To verify that a ticket submission was made by a human and not a spam bot, users will be asked to type out some scrambled letters from an image.',
    't_arnews'                             => 'Include latest news in ticket autoresponder',
    'd_t_arnews'                           => 'Recent news articles published to the helpdesk will be included in the autoresponder sent to users confirming receipt of their ticket.',
    't_ticketlock'                         => 'Ticket Lock Settings',
    't_plockthreshold'                     => 'Ticket reply preview timeout',
    'd_t_plockthreshold'                   => 'Staff can see a ticket reply as it is being typed out by another staff user. If no update is made to the reply after this time (in seconds), it will no longer be shared.',
    't_locktimeout'                        => 'Ticket lock timeout',
    'd_t_locktimeout'                      => 'If a staff user has a ticket open, a lock icon will appear next to the ticket. This lock icon will clear after this amount of time (in seconds) has lapsed, i.e. if the staff who opened the ticket is idle.',
    't_canirs'                             => 'Enable Instant Response System (IRS)',
    'd_t_canirs'                           => 'Kayako will proactively suggest relevant articles from the knowledgebase as the user types out their ticket in the support center.',
    't_maxwcnt'                            => 'Stop IRS searching after this many words',
    'd_t_maxwcnt'                          => 'Once the user has typed this many words, Kayako will no longer continue searching the knowledgebase for suggested answers.',

    't_cstatusupd'                         => 'Set tickets to this status on user reply',
    'd_t_cstatusupd'                       => 'Tickets will be changed to this status when a reply is received from a user (usually an <strong>open</strong> status, as opposed to a <strong>resolved</strong> status).',
    't_enhistory'                          => 'Include ticket reply summary in staff replies',
    'd_t_enhistory'                        => 'The entire history of the ticket will be included in staff replies (and forwarded tickets) to users.',

    't_reciplimit'                         => 'Maximum number of recipients in incoming email',
    'd_t_reciplimit'                       => 'This is the maximum number of recipients that the helpdesk will accept while processing email.',
    't_mergrecip'                          => 'Add users as ticket recipients when merging tickets',
    'd_t_mergrecip'                        => 'If two tickets created by two different users are merged together, their respective email addresses will be added as recipients in the newly merged tickets.',
    'tickets_bayesian'                     => 'Bayesian Filter Settings',
    'tb_minwordlength'                     => 'Minimum word length',
    'd_tb_minwordlength'                   => 'The Bayesian filter will only consider words longer than this length.',
    'tb_maxwordlength'                     => 'Maximum word length',
    'd_tb_maxwordlength'                   => 'The Bayesian filter will only consider words shorter than this length.',
    'tb_indexnumbers'                      => 'Include numbers',
    'd_tb_indexnumbers'                    => 'The Bayesian filter will include numbers when indexing.',
    'tb_minnumberlength'                   => 'Minimum number length',
    'd_tb_minnumberlength'                 => 'Only numbers longer than this length will be considered by the Bayesian filter.',
    'tb_signores'                          => 'Ignore words with symbols',
    'd_tb_signores'                        => 'The Bayesian filter will not consider words with symbols in them.',
    'tb_enablespam'                        => 'Enable spam filtering',
    'd_tb_enablespam'                      => 'If enabled, the Bayesian filter can be trained (by marking tickets as <strong>spam</strong>) to automatically detect spam.',
    't_ticketview'   => 'Maximum tickets per page in staff ticket views.',
    'd_t_ticketview' => 'Specify the maximum number of tickets that staff can display on a single page in their ticket views.',
    'tickets_attachments'                  => '',

    // ======= TROUBLESHOOTER =======
    'tr_displayviews'                      => 'Display number of views',
    'd_tr_displayviews'                    => 'The number of views each troubleshooter category has will be displayed.',

    // ======= USER REGISTRATION =======
    'user_enableemailverification'         => 'New registration email verification',
    'd_user_enableemailverification'       => 'Verify new user registrations (in the support center) by sending an email with an activation link, to verify their registration and that their email address is correct.',
    'user_enablecaptcha'                   => 'CAPTCHA for new user registration',
    'd_user_enablecaptcha'                 => 'To verify that a registration was made by a human and not a spam bot, users will be asked to type out some scrambled letters from an image.',
    'user_autodelete'                      => 'Auto Clear Accounts',
    'user_adelunveri'                      => 'Clean up unverified user accounts',
    'd_user_adelunveri'                    => 'The helpdesk will automatically clear unverified accounts (registered but did not click on the activation link send to the user\'s email address).',
    'user_delcleardays'                    => 'Clean up unverified accounts',
    'd_user_delcleardays'                  => 'If a user has not verified their account by this number of days, their account will be deleted (if unverified account clean up is enabled).',
    'user_organizations'                   => 'User Organizations',
    'user_orgrestrictautoadd'              => 'Allow users to add themselves to <em>shared</em> organizations',
    'd_user_orgrestrictautoadd'            => 'A <strong>shared</strong> organization allows all member users to see each other\'s tickets. If this setting is enabled, users will be able to add themselves to shared organizations by updating their own profile. <strong>This should only be enabled in trusted environments.</strong>',
    'user_orgselection'                    => 'Allows users to specify their own organization',
    'd_user_orgselection'                  => 'By default, users can enter an <strong>organization name</strong> under their profile. This setting determines how the helpdesk will handle this.<br /><br /><strong>Do not allow</strong> Users will not be allowed to add themselves to organizations.<br /><strong>Always create new organization</strong> A new organization will be created whenever a user enters an organization name (and this user will be the only member).<br /><strong>Join existing or create new</strong> If the organization name already exists, the user will be added to it, otherwise a new organization will be created.',
    'uodontallow'                          => 'Do not allow',
    'uocreatenew'                          => 'Always create new organization',
    'uocreatemerge'                        => 'Join existing or create new',
    'user_orgprofileupdate'                => 'Who can update their organization\'s profile?',
    'd_user_orgprofileupdate'              => 'Users who are members of an organization can update their organization\'s profile. Select which type of users can do this.',
    'uoallusers'                           => 'All users',
    'uomanagersonly'                       => 'Users designated as managers',
    'user_orgdefaultclassification'        => 'Default user designation',
    'd_user_orgdefaultclassification'      => 'Select the default designation for new user registrations.<br /><br /><strong>Regular user</strong> A regular user with no special designation.<br /><strong>Manager</strong> A user with a manager designation will be able to access all tickets created by users who share the manager\'s organization.',
    'uouser'                               => 'Regular user',
    'uomanager'                            => 'Manager',
    'user_dispatchregemail'                => 'Send registration confirmation email',
    'd_user_dispatchregemail'              => 'New users will receive an email confirmation of their registration.',
    'user_delcleardays_invalid'            => 'Invalid number of days for cleanup unverified accounts',
    'd_user_delcleardays_invalid'          => 'Number of days should be a positive integer',
    'security_loginattempts_invalid'       => 'Invalid number of login attempts lockout',
    'd_security_loginattempts_invalid'     => 'Number of attempts should be a positive integer',

    // ======= NEWS =======
    'nw_general'                           => 'News Settings',
    'nw_sendstaffemail'                    => 'Email newly published news articles to staff',
    'd_nw_sendstaffemail'                  => 'Staff will receive an email notification when a news article is published.',
    'nw_sync'                              => 'RSS Synchronization Settings',
    'nw_globalsync'                        => 'Global news article feed',
    'd_nw_globalsync'                      => 'The helpdesk can monitor an RSS feed and create news articles from it. This feed will be used to create <strong>global</strong> (support center and staff control panel) articles.',
    'nw_publicsync'                        => 'Public news article feed',
    'd_nw_publicsync'                      => 'This feed will be used to create <strong>public</strong> (support center only) news articles.',
    'nw_privatesync'                       => 'Private news article feed',
    'd_nw_privatesync'                     => 'This feed will be used to create <strong>private</strong> (staff control panel only) news articles.',
    'nw_newsstaffcp'                       => 'Staff Control Panel News Settings',
    'nw_newsclient'                        => 'User Support Center News Settings',
    'nw_enablestaffdashboard'              => 'Display latest news on the home',
    'd_nw_enablestaffdashboard'            => '',
    'nw_maxdashboardnewslist'              => 'Maximum number of news articles to display',
    'd_nw_maxdashboardnewslist'            => '',
    'nw_enablenewsnav'                     => 'Display latest news on the support center home page',
    'd_nw_enablenewsnav'                   => '',
    'nw_maxnewslist'                       => 'Maximum number of news articles to display',
    'd_nw_maxnewslist'                     => '',
    'nw_rss'                               => 'RSS Syndication Settings',
    'nw_enablerss'                         => 'Enable RSS feed of helpdesk news',
    'd_nw_enablerss'                       => 'Users will be able to subscribe to an RSS feed of news published to the helpdesk.',
    'nw_maxrss'                            => 'Maximum number of articles to publish in RSS feed',
    'd_nw_maxrss'                          => 'The RSS feed will contain no more than this number of recent news articles.',
    'nw_svalidate'                         => 'Validate news subscriber email address',
    'd_nw_svalidate'                       => 'The helpdesk will verify a subscriber\'s by sending an activation link to their email address.',
    'nw_pageno'                            => 'Number of news articles to show per page',
    'd_nw_pageno'                          => 'After this number, news articles will be split across other pages.',
    'nw_staffpageno'                       => 'Number of news articles to show per page',
    'd_nw_staffpageno'                     => 'After this number, news articles will be split across other pages.',

    // ======= KNOWLEDGEBASE =======
    'kb_clientarea'                        => 'General Knowledgebase Settings',
    'kb_clientareaindex'                   => 'Support Center Settings',
    'kb_categoryindex'                     => 'Category Settings',
    'kb_enpopulararticles'                 => 'List popular articles',
    'd_kb_enpopulararticles'               => 'A list of the most popular (by views) knowledgebase articles will be displayed.',
    'kb_maxpopulararticles'                => 'Number of popular articles to display',
    'kb_enlatestarticles'                  => 'List latest articles',
    'd_kb_enlatestarticles'                => 'A list of the most recently published knowledgebase articles will be displayed.',
    'kb_maxlatestarticles'                 => 'Number of latest articles to display',
    'kb_maxcatarticles'                    => 'Number of articles to display under a category',
    'd_kb_maxcatarticles'                  => '',
    'kb_alphabetical'                      => 'Sort alphabetically',
    'kb_chrono'                            => 'Sort chronological',
    'kb_catdisplayorder'                   => 'Override category display order',
    'd_kb_catdisplayorder'                 => 'By default, categories are displayed according to their display order number, smallest to largest.',
    'kb_catorder'                          => 'Category order of display',
    'd_kb_catorder'                        => '',
    'kb_asc'                               => 'Smallest to largest (a to z)',
    'kb_desc'                              => 'Largest to smallest (z to a)',
    'kb_arorder'                           => 'Article order of display',
    'd_kb_arorder'                         => '',
    'd_kb_ardisplayorder'                  => 'By default, articles are displayed according to their display order number, smallest to largest.',
    'kb_ardisplayorder'                    => 'Override article display order',
    'kb_datemodified'                      => 'Date last updated',
    'kb_views'                             => 'Sort by total views',
    'kb_rating'                            => 'Sort by article rating',
    'kb_defaultdisp'                       => 'Use category display order',
    'kb_enrss'                             => 'Enable RSS feeds',
    'kb_rss'                               => 'RSS Feed Settings',
    'd_kb_enrss'                           => 'Users will be able to subscribe to RSS feeds of knowledgebase article postings.',
    'kb_climit'                            => 'Article preview character limit',
    'd_kb_climit'                          => 'The maximum number of characters to display under article previews.',
    'kb_rssclimit'                         => 'RSS feed article preview limit',
    'd_kb_rssclimit'                       => 'The maximum number of characters that will be shown in the RSS feeds.',
    'kb_enrating'                          => 'Allow article ratings',
    'd_kb_enrating'                        => 'Staff and users will be able to rate articles (thumbs up or down).',
    'kb_categorycolumns'                   => 'Number of category columns',
    'd_kb_categorycolumns'                 => 'The number of category columns that will be displayed. This setting can be overridden on a per-category basis.',
    'kb_parcount'                          => 'Count articles in sub categories',
    'd_kb_parcount'                        => 'The helpdesk displays the number of articles next to each category. Enable this setting to include the articles in all of the sub-categories in this count, too.',

    // Potentialy unused phrases in settings.php
    'desc_settings'                        => 'From here you can manage all functional and system-related settings and configurations.',
    'systemsettings'                       => 'System Settings',
    'settingsfor'                          => 'Settings for: %s',
    'updatesettings'                       => 'Update Settings',
    'settingsupdatedfor'                   => 'Updated all settings for group "%s"',
    'settings_livesupport'                 => 'Live Chat',
    'settings_reports'                     => 'Reports',
    'g_whmcstgroup'                        => 'WHMCS Template Group',
    'd_g_whmcstgroup'                      => 'Select a default template group for WHMCS integration. This group will override the default template group. This can be used to display a different template group when Kayako is used via WHMCS and another when accessed normally.',
    'g_supportcenter'                      => 'Support Center Settings',
    'g_returnlogout'                       => 'After Logout Return To Default Template Group',
    'd_g_returnlogout'                     => 'Redirect the user to the default template group after logout.',
    'g_overrideswiftpath'                  => 'Override $swiftpath and $themepath variables automatically',
    'd_g_overrideswiftpath'                => 'If enabled, the system tries to determine the $swiftpath and $themepath variables for templates from the URL. This allows you to create multi-point installations of helpdesk based off a single database.',
    'livesupport_usehttps'                 => 'Always Use Secure Connection (https) For Chat',
    'd_livesupport_usehttps'               => 'If this setting is enabled, all chat sessions will always be conducted over https.',
    'tr_captcha'                           => 'Enable CAPTCHA for Comments',
    'd_tr_captcha'                         => 'If enabled, users will be required to verify a CAPTCHA image before submitting a comment.',
    'nw_captcha'                           => 'Enable CAPTCHA for Comments',
    'd_nw_captcha'                         => 'If enabled, users will be required to verify a CAPTCHA image before submitting a comment.',
    'dl_captcha'                           => 'Enable CAPTCHA for Comments',
    'd_dl_captcha'                         => 'If enabled, users will be required to verify a CAPTCHA image before submitting a comment.',
    'kb_captcha'                           => 'Enable CAPTCHA for Comments',
    'd_kb_captcha'                         => 'If enabled, users will be required to verify a CAPTCHA image before submitting a comment.',
    'general_redirecttype'                 => 'Redirect Type',
    'd_general_redirecttype'               => 'Select <i>HTML Meta Refresh</i> to present a confirmation of an action before redirecting to the next page.',
    'refreshunix'                          => 'Header Refresh',
    'refreshwindows'                       => 'HTML META Refresh',
    'general_defaultlanguage'              => 'Default Language',
    'g_cpmenu'                             => 'Tab Menu Navigation Style',
    'd_g_cpmenu'                           => 'Choose the <i>Hover</i> navigation style to activate a tab by placing the mouse cursor over it.',
    'navleft'                              => 'Left',
    'navright'                             => 'Right',
    'g_commentsapproval'                   => 'Moderate Comments',
    'd_g_commentsapproval'                 => 'Require manual approval of comments entered by users.',
    'menuhover'                            => 'Hover',
    'menuclick'                            => 'Click',
    'g_jscache'                            => 'Javascript Cache for Theme Items',
    'd_g_jscache'                          => 'Cache heavy-output items such as the menu and navigation bar to a file so that pages load faster (rather than loading from the database each time). This disables the real-time view of comments and private message counts in the menu.',
    'cpu_smsgateway'                       => 'SMS Gateway',
    'gateway_enable'                       => 'Enable SMS Gateway',
    'd_gateway_enable'                     => 'The Kayako SMS Gateway can send alerts directly to mobile phones. For more information, see the <a target="_blank" rel="noopener noreferrer" href="http://support.gfi.com">GFI Support</a>.',
    'gateway_username'                     => 'Gateway Username',
    'd_gateway_username'                   => 'Your SMS Gateway username. This is the same as the email address used to log in to the <a target="_blank" rel="noopener noreferrer" href="https://support.gfi.com">GFI Support</a>.',
    'gateway_password'                     => 'Gateway Password',
    'd_gateway_password'                   => 'Your SMS Gateway password. This is the same as the password used to log in to the <a target="_blank" rel="noopener noreferrer" href="https://support.gfi.com">GFI Support</a>.',
    'gat_emailfailure'                     => 'Email Failure Reports',
    'd_gat_emailfailure'                   => 'Send delivery failure reports to the primary administrator email address.',
    'dt_timezone'                          => 'Time Zone',
    'd_dt_timezone'                        => 'Select the Default Time Zone. The Staff users have an option to override this Time Zone in their Preferences.',
    'livesupport_enableuseristyping'       => 'Show "User is Typing..."',
    'd_livesupport_enableuseristyping'     => 'If enabled, both visitors and staff users will be able to see when the other is typing. Disable this option to reduce server load.',
    'livesupport_messagesettings'          => 'Offline Messages Settings',
    'livesupport_captcha'                    => 'Require CAPTCHA for offline messages',
    'd_livesupport_captcha'                  => 'Users will be asked to complete a CAPTCHA while leaving an offline message to verify that they are human.',
    'livesupport_enablemessagefw'          => 'Enable Forwarding',
    'd_livesupport_enablemessagefw'        => 'Forward offline messages received by Kayako to the email address entered below.',
    'livesupport_deletemessageafterfw'     => 'Delete After Forward',
    'd_livesupport_deletemessageafterfw'   => 'Automatically delete the forwarded message.',
    'livesupport_fwmessageemail'           => 'Forwarding Email Addresses',
    'd_livesupport_fwmessageemail'         => 'Forward offline messages to these semi-colon separated email addresses.  This will only take effect if the above option, <i>Enable Forwarding</i>, is enabled.<br/><br/>Example: <i>jane.doe@company.com;john.smith@company.com</i>',
    'ls_adbgcolor'                         => 'Ad Tracking Visitor Background Color',
    'd_ls_adbgcolor'                       => 'The background color for a visitor that has been referred to the site by an <b>Ad Campaign</b> (configured within the Staff Control Panel).',
    'ls_adfrcolor'                         => 'Ad Tracking Visitor Foreground Color',
    'd_ls_adfrcolor'                       => 'The foreground color for a visitor that has been referred to the site by an <b>Ad Campaign</b> (configured within the Staff Control Panel).',
    'ls_staffcp'                           => 'Live Support Staff CP Settings',
    'ls_entab'                             => 'Display Live Support Tab In Staff CP',
    'd_ls_entab'                           => 'Show the Live Support tab within the staff control panel.',
    'pr_allowhtml'                         => 'Allow HTML Tags',
    'd_pr_allowhtml'                       => 'Whether or not Parser should allow HTML Tags in the Content.',
    'pr_allowabletags'                     => 'Valid HTML Tags',
    'd_pr_allowabletags'                   => 'Specify the Tags that the Parser will not remove for the incoming email.',
    'desc_pr_conversion'                   => 'If enabled, Kayako will automatically attempt to convert incoming emails to the default encoding of the help desk (<i>e.g. If the help desk is set to UTF-8 and an email is sent in ISO-8859-1, it will be converted to UTF-8 before being added to the system</i>).',
    't_rvalemail'                          => 'Require Valid Email Address',
    'd_t_rvalemail'                        => 'Require users to provide a valid email address when submitting tickets.',
    'tickets_search'                       => 'Search Options',
    't_searchsortdate'                     => 'Sort Results According to Last Activity (Descending)',
    'd_t_searchsortdate'                   => 'Sort search results according to last activity time (descending). Otherwise, the default view sort order is used.',
    't_cntrelevance'                       => 'Advanced Ticket Searching',
    'd_t_cntrelevance'                     => 'Use a more advanced algorithm for searching and determining relevance of results. This setting will increase the search time by up to 40%, but the relevancy of the results will be much higher.',
    'tickets_searchtype'                   => 'Search Index Type',
    'postindex'                            => 'Bulletin Post Index',
    'fulltext'                             => 'MySQL Full Text',
    'tickets_minwordlength'                => 'Minimum Word Length',
    'd_tickets_minwordlength'              => 'Specify the minimum length of a word that will be indexed for search. Any word that does not meet this criteria will be ignored by the indexer and will not be searchable. Shorter words tend to occur more frequently, so allowing their indexing will cause a larger, slower index and thus slower per-word searches.',
    'tickets_maxwordlength'                => 'Maximum Word Length',
    'd_tickets_maxwordlength'              => 'Specify the maximum length of a word that will be indexed for search. Any word that does not meet this criteria will be ignored by the indexer and will not be searchable.',
    'tickets_indexnumbers'                 => 'Index Numbers',
    'd_tickets_indexnumbers'               => 'If enabled, numbers will be indexed and will be searchable.',
    'tickets_minnumberlength'              => 'Minimum Number Length',
    'd_tickets_minnumberlength'            => 'The minimum length of a number, in characters, that will be indexed. Any number shorter than this number of characters will be ignored by the indexer and will not be searchable.',
    'tickets_faulttolerance'               => 'Word Fault Tolerance',
    'd_tickets_faulttolerance'             => 'If a word occurs in a ticket post more than the times specified here, it will be ignored and will not be indexed.',
    't_floodprotection'                    => 'Flood Protection',
    't_fresponder'                         => 'Dont Send Autoresponder Message',
    'd_t_fresponder'                       => 'If Enabled, No Autoresponder Message will be sent when the Flood Protection is triggered.',
    't_fnoadd'                             => 'Dont add the Ticket/Reply',
    'd_t_fnoadd'                           => 'If Enabled, The Incoming Email will be simply ignored if Flood Protection is triggered. It is recommended that you do not enable this option as simply disabling the Autoresponder message should stop any potential mail loop.',
    't_fthreshold'                         => 'Timing Threshold (In Seconds)',
    'd_t_fthreshold'                       => 'Threshold for checking for Potential Flood Protection cases.<BR /><BR /><span class="tabletitle"><i>How Flood Protection Works?</i></span><BR />Whenever an incoming email is received, Kayako checks the Tickets table to see if the user created a ticket with the same subject in the given threshold time, If this check succeeds, Flood Protection gets triggered and the specified actions are carried out.',
    't_enfp'                               => 'Enable/Disable Flood Protection',
    'd_t_enfp'                             => 'Toggle the Status for Flood Protection. It is recommended that you never disable this option as it prevents mail loops that can happen if your client has an autoresponder message set.',
    't_rss'                                => 'RSS View Syndication',
    't_enrss'                              => 'Enable RSS Syndication for Ticket Views',
    'd_t_enrss'                            => 'Allow ticket views (from within the staff control panel) to be syndicated as RSS feeds.',
    't_tidinsub'                           => 'Set Ticket ID in Subject for Outgoing Email',
    'd_t_tidinsub'                         => 'Insert a ticket ID into the subject of emails sent when staff create new tickets. Although it is highly recommended that this option be enabled, Kayako can still check which ticket a message belongs to by searching for the ticket ID within the email body, by comparing the subject or by checking the Message-ID email header.',
    't_stmsgid'                            => 'Check the Message-ID for Staff Replies',
    'd_t_stmsgid'                          => 'Kayako can check the Message-ID header to confirm the identity of a staff user replying to a ticket alert. This adds an extra layer of security and makes sure the replier is a valid staff user. However, it requires that the end mailing client sends the In-Reply-To header, which is not supported by all email clients (in particular, wireless email clients).',
    't_csccrecipients'                     => 'Enable Support Center Users to Specify Custom Recipients',
    'd_t_csccrecipients'                   => 'Allow support center users to specify custom recipients (CC) while creating tickets.',
    't_entab'                              => 'Display Tickets Tab',
    'd_t_entab'                            => 'Display the Tickets tab within the staff control panel.',
    't_cperpage'                           => 'Tickets to Display Per Page',
    'd_t_cperpage'                         => 'The number of tickets that will be listed to users when viewing their ticket list.',
    't_maxattach'                          => 'Maximum Number of Attachments When Replying',
    'd_t_maxattach'                        => 'The maximum number of files that can be attached to a ticket reply. If particularly large files are allowed, it is recommended that the <i>upload_max_filesize</i> setting in your php.ini (PHP configuration file) be edited to reflect the size.',
    't_cmaxattach'                         => 'Maximum Number of Attachments',
    'd_t_cmaxattach'                       => 'The number of attachments a user can add to a new ticket or ticket reply.',
    't_pdainterf'                          => 'PDA Staff Control Panel Interface',
    't_pdenpagin'                          => 'Split Ticket Posts by Page',
    'd_t_pdenpagin'                        => 'Display ticket posts for a ticket will be displayed on separate pages instead of a single page. You may choose how many ticket posts to display per page below.',
    't_pdpostlimit'                        => 'Number of Tickets Posts Per Page',
    'd_t_pdpostlimit'                      => 'If you have enabled the <i>"Split Ticket Posts By Page"</i> option, this specifies how many ticket posts to display on a single page. This applies only to the PDA staff control panel interface.',
    't_pdpostorder'                        => 'Display Order For Ticket Posts',
    'd_t_pdpostorder'                      => 'Whether to display the oldest or newest ticket posts first.',
    't_signores'                           => 'Ignore Words Containing Symbols',
    'd_t_signores'                         => 'If enabled, words containing any of the following symbols will be ignored:<br /><br /><i>- ~ ` @ # $ ^ & * ( ) _ = + [ ] { } | / < > , . ; \' " \</i>',
    't_autoclose'                          => 'Ticket Automatic Close Settings',
    't_enautoclose'                        => 'Enable Auto Closure System',
    'd_t_enautoclose'                      => 'Automatically change the status of tickets that have lingered in the system for the specified amount of time.',
    't_acstatus'                           => 'Affected Ticket Statuses',
    'd_t_acstatus'                         => 'Select the ticket statuses the automatic close system will affect.  Select multiple statuses by holding the CTRL key and selecting multiple entries.',
    't_acdep'                              => 'Affected Departments',
    'd_t_acdep'                            => 'Select the departments that the automatic close system will affect. Select multiple departments by holding the CTRL key and selecting multiple entries.',
    't_acstatusch'                         => 'Target Status',
    'd_t_acstatusch'                       => 'Select the status to which tickets will be changed automatically once they have lingered for the specified time.',
    't_acinactive'                         => 'Automatic Closure Inactivity Threshold',
    'd_t_acinactive'                       => 'After a ticket has remained inactive for this amount of time (in hours), the system will send a notice to the user created the ticket, warning the user of the pending automatic status change.',
    't_acnoticeclose'                      => 'Final Automatic Close Threshold',
    'd_t_acnoticeclose'                    => 'After this amount of time (in hours) has elapsed (this starts after the \"Automatic Closure Inactivity Threshold\" has been reached), the target tickets status will automatically be changed.',
    't_entlock'                            => 'Enable/Disable Ticket Locking',
    't_entplock'                           => 'Enable Reply Ticket Locking',
    'd_t_entplock'                         => 'Allow staff users to see other staff user\'s replies in real-time (as they draft their reply) when viewing the same ticket.',
    'd_t_entlock'                          => 'The ticket locking feature in Kayako will lock a ticket when a staff user opens the ticket. Other staff users will still be able to access the ticket, but a lock icon will be displayed letting other staff users know that the ticket is being viewed.',
    't_reciplist'                          => 'List Recipients Before Replying',
    'd_t_reciplist'                        => 'Display the list of added recipients in a ticket. This adds an overhead of additional database queries in the ticket listing page.',
    't_staffcp'                            => 'Staff Control Panel Settings',
    't_scanirs'                            => 'Enable Instant Response System (IRS)',
    'd_t_scanirs'                          => 'Like the IRS in the client support interface, Kayako will suggest knowledgebase articles as staff users draft their replies.',
    't_advanced'                           => 'Advanced Ticket Settings',
    't_postlist'                           => 'Assign Post List Variable to Staff Replies',
    'd_t_postlist'                         => 'Include the entire history of the ticket to date in replies sent by staff members.  This does add overhead and could potentially slow down replies.',

    // ======= TROUBLESHOOTER =======
    'tr_staffcp'                           => 'Troubleshooter Staff Control Panel Settings',
    'tr_general'                           => 'Client Support Interface Troubleshooter Settings',
    'tr_staffwysiwyg'                      => 'Enable WYSIWYG Editor',
    'd_tr_staffwysiwyg'                    => 'Use the advanced WYSIWYG editor (rich text) for creating troubleshooter articles.',
    'tr_enableclient'                      => 'Display Troubleshooter Widget',
    'd_tr_enableclient'                    => 'Show the troubleshooter icon and link on the index.php page of the client support interface.',
    'tr_enablepopularcat'                  => 'Enable Popular Troubleshooters Box',
    'd_tr_enablepopularcat'                => 'Show a list of the most popular troubleshooters on the index.php page of the client support interface.',
    'tr_maxpopularcat'                     => 'Maximum Number Of Troubleshooters To Display',
    'd_tr_maxpopularcat'                   => 'The maximum number of troubleshooters to display in the popular troubleshooters box.',
    'tr_displaynavbar'                     => 'Display Troubleshooters in Navigation Bar',
    'd_tr_displaynavbar'                   => 'Display troubleshooters at every step in the navigation bar.',
    'tr_entab'                             => 'Display Troubleshooter Tab',
    'd_tr_entab'                           => 'Show the Troubleshooter tab within the Staff Control Panel.',
    'tsnochange'                           => '-- Do Not Change --',
    't_canrecip'                           => 'Users Can Specify Custom Recipients',
    'd_t_canrecip'                         => 'Allow users to specify custom CC Recipients to tickets that they create.',
    'u_sendpw'                             => 'Send Password in Auto Responder (Ticket Receipt)',
    'd_u_sendpw'                           => 'Send the user\'s password to them whenever they create a new ticket.',
    'nw_wysiwyg'                           => 'Enable WYSIWYG Editor',
    'd_nw_wysiwyg'                         => 'Use the advanced WYSIWYG editor (rich text) for creating news articles.',
    'nw_enableclient'                      => 'Display News Widget',
    'd_nw_enableclient'                    => 'Display the news icon and link on the index.php page of the client support interface.',
    'nw_navdisplaydate'                    => 'Display Date Beside News Items',
    'd_nw_navdisplaydate'                  => 'Display the date a news posting was made alongside the title of the posting.',
    'nw_navdateformat'                     => 'Navigation News Date Format',
    'd_nw_navdateformat'                   => 'The format in which the posting date of news items is displayed. For more information, see the documentation for the PHP <a href=\"http://www.php.net/date\" target=\"_blank\">date()</a> function.',
    'nw_entab'                             => 'Display News Tab',
    'd_nw_entab'                           => 'Display the News tab within the Staff Control Panel.',
    'kb_enableclient'                      => 'Display Knowledgebase Widget',
    'd_kb_enableclient'                    => 'Show the knowledgebase icon and link on the index.php page of the client support interface.',
    'kb_dispviews'                         => 'Display View Count Next To Popular Articles',
    'kb_displayarticledate'                => 'Display Creation Date Next To Latest Articles',
    'kb_dateformat'                        => 'Creation Date Format',
    'd_kb_dateformat'                      => 'Specify the format used to display creation dates in articles. For more information, see the documentation for the PHP <a href=\"http://www.php.net/date\" target=\"_blank\">date()</a> function.',
    'kb_displaymore'                       => 'Display \"More Topics\" Link Under Category List',
    'kb_catarticledetails'                 => 'Display Article Details Under Category List',
    'kb_totalarticles'                     => 'Total Articles',
    'kb_staffcp'                           => 'Knowledgebase Staff Control Panel Settings',
    'kb_staffwysiwyg'                      => 'Enable WYSIWYG Editor',
    'd_kb_staffwysiwyg'                    => 'Use the advanced WYSIWYG editor (rich text) for creating new articles.',
    'kb_entab'                             => 'Display Knowledgebase Tab',
    'd_kb_entab'                           => 'Enable the Knowledgebase tab within the Staff Control Panel.',
    'settings_purchase'                    => 'Ticket Purchaser',
    'purchase_admin_email'                 => 'Billing Email',
    'purchase_money_format'                => 'Currency Symbol Position',
    'purchase_number_format_style'         => 'Number Format',
    'purchase_money_sign'                  => 'Currency Symbol',
    'purchase_bluepay_account'             => 'Bluepay Account Number',
    'purchase_bluepay_key'                 => 'Bluepay Secret Key',
    'purchase_bluepay_mode'                => 'Bluepay Transaction Mode',
    'purchase_bluepay_mode_test'           => 'Test',
    'purchase_bluepay_mode_live'           => 'Live',
    'purchase_invoice_address'             => 'Billing address to display on invoices',
    'ons_xmpphost_2'                       => 'XMPP Host',
    'ons_xmppport_2'                       => 'XMPP Port',
    'd_ons_xmppport_2'                     => '',
    'ons_stunhost_2'                       => 'STUN Host',
    'd_ons_stunhost_2'                     => '',
    'ons_stunport_2'                       => 'STUN Port',
    'd_ons_stunport_2'                     => '',
    'ons_turnhost_2'                       => 'TURN Host',
    'd_ons_turnhost_2'                     => '',
    'ons_turnportudp_2'                    => 'TURN Port (UDP)',
    'd_ons_turnportudp_2'                  => '',
    'ons_turnporttcp_2'                    => 'TURN Port (TCP)',
    'd_ons_turnporttcp_2'                  => '',
    'rep_general'                          => 'Reports Settings',
    'rep_maxrows'                          => 'Max Rows',
    'd_rep_maxrows'                        => 'The maximum number of rows to display in a page for tabular/summary reports',
    );



return $__LANG;
