<?php
/**
 * ###############################################
 *
 * SWIFT Framework
 * _______________________________________________
 *
 * @author        Varun Shoor
 *
 * @package        SWIFT
 * @copyright    Copyright (c) 2001-2012, Kayako
 * @license        http://www.kayako.com/license
 * @link        http://www.kayako.com
 *
 * ###############################################
 */

use Base\Library\Help\SWIFT_Help;

$__LANG = array (

    // Reports
    'r_tickets' => 'Tickets',
    'r_numunresolvticketsgbdepartment' => 'Number of unresolved tickets matrix grouped by department and owner',
    'r_totalticketcountgbdepstatus' => 'Total ticket count grouped by department and status',
    'r_numescalatedthismongbdep' => 'Number of tickets that were escalated this month grouped by department',
    'r_numescalatedthismongbstatus' => 'Number of tickets that were escalated this month grouped by status',
    'r_numescalatedthismongbpriority' => 'Number of tickets that were escalated this month grouped by priority',
    'r_numautoclosedthismongbdepartment' => 'Number of tickets that were auto closed this month grouped by department',
    'r_numautoclosedthismongbowner' => 'Number of tickets that were auto closed this month grouped by owner',
    'r_listautoclosedthismongbdep' => 'List of tickets that were auto closed this month grouped by department',
    'r_listautoclosedthismongbowner' => 'List of tickets that were auto closed this month grouped by owner',
    'r_numticketsgbcreationchannelanddepforthismo' => 'Number of tickets grouped by creation channel and department for this month',
    'r_avgrepliesgbdepthismonth' => 'Average number of replies on tickets grouped by department for this month',
    'r_avgrepliesgbownerthismonth' => 'Average number of replies on tickets grouped by owner for this month',
    'r_totalescthismonthgbweekday' => 'Total number of tickets escalated this month grouped by week and day',
    'r_numreopenthismonthgbdep' => 'Number of tickets that were reopened this month grouped by department',
    'r_numreopenthismonthgbowner' => 'Number of tickets that were reopened this month grouped by owner',
    'r_numresolvedthismonthgbdep' => 'Number of tickets that were resolved this month grouped by department',
    'r_numresolvedthismonthgbowner' => 'Number of tickets that were resolved this month grouped by owner',
    'r_avgescresolvedthismonthgbdep' => 'Average number of escalations it took to resolve tickets grouped by department for this month',
    'r_avgescresolvedthismonthgbowner' => 'Average number of escalations it took to resolve tickets grouped by owner for this month',
    'r_avgtimetoresolvethismonthgbdep' => 'Average time to resolve tickets grouped by department for this month',
    'r_avgtimetoresolvethismonthgbowner' => 'Average time to resolve tickets grouped by owner for this month',
    'r_avgrepliestoresolvethismonthgbdep' => 'Average number of replies it takes to resolve tickets grouped by department for this month',
    'r_avgrepliestoresolvethismonthgbowner' => 'Average number of replies it takes to resolve tickets grouped by owner for this month',
    'r_avgrespthismonthgbdep' => 'Average response time for tickets grouped by department for this month',
    'r_avgrespthismonthgbowner' => 'Average response time for tickets grouped by owner for this month',
    'r_avgowntoresolvethismonthgbdep' => 'Average number of owner changes to resolve tickets for this month grouped by department',
    'r_avgresponsetpgbstaffthismonth' => 'Average response time for ticket posts grouped by staff for this month',
    'r_avgresponsetpgbdepthismonth' => 'Average response time for ticket posts grouped by department for this month',
    'r_avgresponseclienttpgbdepthismonth' => 'Average response time for user ticket posts grouped by department for this month',
    'r_avgfirstresptimeticketsgbowner' => 'Average of first response time for tickets grouped by owner for this month',
    'r_avgfirstresptimeticketsgbdep' => 'Average of first response time for tickets grouped by department for this month',
    'r_avgfirstresptimetpgbstaff' => 'Average of first response time for ticket posts grouped by staff for this month',
    'r_listticketsduetoday' => 'List of tickets due today',
    'r_listoverduetickets' => 'List of overdue tickets',
    'r_totaltimeworkbilledgbdep' => 'Total time worked and billed on tickets grouped by department for this month',
    'r_totaltimeworkbilledgbowner' => 'Total time worked and billed on tickets grouped by owner for this month',
    'r_distbslaplansgbdepthismo' => 'Distribution of SLA plans for tickets grouped by department for this month',
    'r_avgresptimegbslathismo' => 'Average response time for tickets grouped by SLA plan for this month',
    'r_avgrepliesresgbslathismo' => 'Average number of replies it takes to resolve tickets grouped by SLA plan for this month',
    'r_avgrepliesgbslathismo' => 'Average number of replies for tickets grouped by SLA plan for this month',
    'r_avgttresolvegbslathismo' => 'Average time to resolve tickets grouped by SLA plan for this month',
    'r_perctickfcrthismonthgbdep' => 'Percentage of tickets that are first contact resolved grouped by department for this month',
    'r_perctickfcrthismonthgbowner' => 'Percentage of tickets that are first contact resolved grouped by owner for this month',
    'r_perctickreopthismonthgbdep' => 'Percentage of tickets that are reopened grouped by department for this month',
    'r_perctickescthismonthgbdep' => 'Percentage of tickets that are escalated grouped by department for this month',
    'r_ratings' => 'Ratings',
    'r_avgratticketsgbstaffthismonth' => 'Average of ratings for tickets grouped by staff for this month',
    'r_avgpratticketsgbstaffthismonth' => 'Average of private ratings for tickets grouped by staff for this month',
    'r_avgratticketsgbdepthismonth' => 'Average of ratings for tickets grouped by department for this month',
    'r_avgpratticketsgbdepthismonth' => 'Average of private ratings for tickets grouped by department for this month',
    'r_avgratticketpostsgbdepthismonth' => 'Average of ratings for ticket posts grouped by staff for this month',
    'r_avgpratticketpostsgbdepthismonth' => 'Average of private ratings for ticket posts grouped by staff for this month',
    'r_avgratlssurveygbstaffthismonth' => 'Average of ratings for live chat surveys grouped by staff for this month',
    'r_avgratlssurveygbdepthismonth' => 'Average of ratings for live chat surveys grouped by department for this month',
    'r_avgratchathistgbstaffthismonth' => 'Average of ratings for live chat history grouped by staff for this month',
    'r_avgratchathistgbdepthismonth' => 'Average of ratings for live chat history grouped by department for this month',
    'r_listofticketsratinglsthreethismonth' => 'List of tickets with rating less than three grouped by owner for this month',
    'r_listofticketpostsratinglsthreethismonth' => 'List of ticket posts with rating less than three grouped by creator for this month',
    'r_listoflssurveylsthreethismonth' => 'List of live chat surveys with rating less than three grouped by staff for this month',
    'r_listofchathistorylsthreethismonth' => 'List of live chat history with rating less than three grouped by staff for this month',
    'r_ticketbilling' => 'Billing',
    'r_totaltimebilledgbstaffthisweek' => 'Total time billed grouped by staff for this week',
    'r_totaltimebilledgbstaffthismonth' => 'Total time billed grouped by staff for this month',
    'r_totaltimebilledgbdepartmentthisweek' => 'Total time billed grouped by department for this week',
    'r_totaltimebilledgbdepartmentthismonth' => 'Total time billed grouped by department for this month',
    'r_totaltimebilledgbuserthisweek' => 'Total time billed grouped by user for this week',
    'r_totaltimebilledgbuserthismonth' => 'Total time billed grouped by user for this month',
    'r_listticketsbilledgbstaffthisweek' => 'List of tickets billed grouped by staff for this week',
    'r_listticketsbilledgbstaffthismonth' => 'List of tickets billed grouped by staff for this month',
    'r_listticketsbilledgbuserthisweek' => 'List of tickets billed grouped by user for this week',
    'r_listticketsbilledgbuserthismonth' => 'List of tickets billed grouped by user for this month',
    'r_listticketsbilledgbuserorgthisweek' => 'List of tickets billed grouped by user organizations for this week',
    'r_listticketsbilledgbuserorgthismonth' => 'List of tickets billed grouped by user organizations for this month',
    'r_listticketsbilledgbtypeuserthisweek' => 'List of tickets billed grouped by type and then user for this week',
    'r_listticketsbilledgbtypeuserthismonth' => 'List of tickets billed grouped by type and then user for this month',
    'r_listticketsbilledgbdepuserthisweek' => 'List of tickets billed grouped by department and then user for this week',
    'r_listticketsbilledgbdepuserthismonth' => 'List of tickets billed grouped by department and then user for this month',
    'r_ticketescalations' => 'Escalations',
    'r_ticketauditlogs' => 'Audit Logs',
    'r_workdonethisweek' => 'Work done this week',
    'r_workdonethismonth' => 'Work done this month',
    'r_ticketsdeletedthismonth' => 'Tickets deleted this month',
    'r_completelogforthisweek' => 'Complete log for this week',
    'r_completelogforthismonth' => 'Complete log for this month',
    'r_escalationsforthisweek' => 'Escalations for this week',
    'r_escalationsforthismonth' => 'Escalations for this month',
    'r_escalationmatrixownerweek' => 'Escalation matrix grouped by owner for this week',
    'r_escalationmatrixownermonth' => 'Escalation matrix grouped by owner for this month',
    'r_escalationmatrixdepartmentweek' => 'Escalation matrix grouped by department for this week',
    'r_escalationmatrixdepartmentmonth' => 'Escalation matrix grouped by department for this month',
    'r_escalationmatrixtypeweek' => 'Escalation matrix grouped by type for this week',
    'r_escalationmatrixtypemonth' => 'Escalation matrix grouped by type for this month',
    'r_calls' => 'Calls',
    'r_unansweredcallsthisweek' => 'Unanswered calls this week',
    'r_unansweredcallsthismonth' => 'Unanswered calls this month',
    'r_callmatrixgbstaffforthisweek' => 'Call matrix grouped by staff for this week',
    'r_callmatrixgbstaffforthismonth' => 'Call matrix grouped by staff for this month',
    'r_avgdurationcallsgbstaffforthisweek' => 'Average duration of calls grouped by staff for this week',
    'r_avgdurationcallsgbstaffforthismonth' => 'Average duration of calls grouped by staff for this month',
    'r_totaldurationcallsgbstaffforthisweek' => 'Total duration of calls grouped by staff for this week',
    'r_totaldurationcallsgbstaffforthismonth' => 'Total duration of calls grouped by staff for this month',
    'r_totalincomingcallsgbdepartmentforthisweek' => 'Total incoming calls grouped by department for this week',
    'r_totalincomingcallsgbdepartmentforthismonth' => 'Total incoming calls grouped by department for this month',
    'r_callcountgbdayforthisweek' => 'Call count grouped by day for this week',
    'r_callcountgbweekforthismonth' => 'Call count grouped by week for this month',
    'r_callcountmatrixgbdayforthisweek' => 'Call count matrix grouped by day and status for this week',
    'r_callcountmatrixgbweekforthismonth' => 'Call count matrix grouped by week and status for this month',
    'r_chatrouting' => 'Chat Routing',
    'r_unansweredchatsgbstaffforthisweek' => 'Unanswered chats grouped by staff for this week',
    'r_unansweredchatsgbstaffforthismonth' => 'Unanswered chats grouped by staff for this month',
    'r_unansweredchatcountmatrixgbstaffforthisweek' => 'Unanswered chat count matrix grouped by staff for this week',
    'r_unansweredchatcountmatrixgbstaffforthismonth' => 'Unanswered chat count matrix grouped by staff for this month',
    'r_chats' => 'Chats',
    'r_avgroundrobinhitsgbdepartmentthisweek' => 'Average round robin hits on chats grouped by department for this week',
    'r_avgroundrobinhitsgbdepartmentthismonth' => 'Average round robin hits on chats grouped by department for this month',
    'r_avgwaittimegbdepartmentthisweek' => 'Average wait time on chats grouped by department for this week',
    'r_avgwaittimegbdepartmentthismonth' => 'Average wait time on chats grouped by department for this month',
    'r_chatstatusmatrixthisweek' => 'Chat status matrix for this week',
    'r_chatstatusmatrixthismonth' => 'Chat status matrix for this month',
    'r_transfermatrixgbdepartmentthisweek' => 'Chat transfer matrix grouped by department for this week',
    'r_transfermatrixgbdepartmentthismonth' => 'Chat transfer matrix grouped by department for this month',
    'r_unansweredchatgbdepartmentthisweek' => 'Unanswered chat count matrix grouped by department for this week',
    'r_unansweredchatgbdepartmentthismonth' => 'Unanswered chat count matrix grouped by department for this month',
    'r_unansweredchatgbhourdepartmentthisweek' => 'Unanswered chat count matrix grouped by hour and department',
    'r_listunansweredchatgbdepartmentthisweek' => 'List of unanswered chats grouped by department for this week',
    'r_listunansweredchatgbdepartmentthismonth' => 'List of unanswered chats grouped by department for this month',
    'r_proactivechatgbdepartmentthisweek' => 'Proactive chat count matrix grouped by department for this week',
    'r_proactivechatgbdepartmentthismonth' => 'Proactive chat count matrix grouped by department for this month',
    'r_answeredchatgbstaffthisweek' => 'Total answered chat count matrix grouped by staff for this week',
    'r_answeredchatgbstaffthismonth' => 'Total answered chat count matrix grouped by staff for this month',
    'r_totalchatgbdepartmentthisweek' => 'Total chat count matrix grouped by department for this week',
    'r_totalchatgbdepartmentthismonth' => 'Total chat count matrix grouped by department for this month',
    'r_totalchatthisweek' => 'Total chat count for this week',
    'r_totalchatthismonth' => 'Total chat count for this month',
    'r_totalchatgbcountry' => 'Total chat count grouped by country',
    'r_totalchatgbcountrycity' => 'Total chat count grouped by country and city',

    // ======= BEGIN V4 LOCALES =======
    'myopentickets' => 'My open tickets',
    'mypendingtickets' => 'My pending Tickets',
    'defaultescalationrule' => 'Escalate overdue tickets',
    'overallsatisfaction' => 'Overall Satisfaction',
    'writtencommunication' => 'Written Communication',
    'writtenexplanations' => 'Written Explanations',
    'responsespeeds' => 'Response Speeds',
    'lc_searchenginevisitors' => 'Search Engine Referrals',
    'lc_skillsales' => 'Enterprise sales',
    'lc_skillsupport' => 'ITIL',
    'lc_skillspanish' => 'Spanish',
    'lc_searchenginerule' => 'Search Engine Visitors',
    'workflowcloseticket' => 'Close ticket',
    'scconfirmcleardb' => 'WARNING: Are you sure you wish to clear the database? Every table in this databse will be deleted, even if they were not part of Kayako, and this is completely irreversible',
    'tickettypeissue' => 'Issue',
    'tickettypetask' => 'Task',
    'tickettypebug' => 'Bug',
    'tickettypelead' => 'Lead',
    'tickettypefeedback' => 'Feedback',
    'sladefaultschedule' => 'Default working hours schedule',
    'sladefaultplan' => 'Default 24 hour reply and 5 day resolution deadline',
    'sautocloserule' => 'Close tickets after 5 days if we won\'t hear back from the customer',
    'defaultrule' => 'Default rule',
    'spam' => 'Spam',
    'nospam' => 'Not Spam',
    'setup' => 'Setup',
    'upgrade' => 'Upgrade',
    'upgautosetup' => 'Automatic Upgrade',
    'modify' => 'Modify',
    'diagnostics' => 'Diagnostics',
    'setlicenseagreement' => 'License Agreement',
    'setsysreq' => 'System Requirements',
    'setcollectinfo' => 'Collect Information',
    'setautosetup' => 'Auto Setup',
    'setsettings' => 'Settings',
    'settemplates' => 'Templates',
    'setlocalization' => 'Localization',
    'setdone' => 'Done',
    'eula' => 'End User License Agreement',
    'iagree' => 'I Agree',
    'setupnext' => 'Next &raquo;',
    'setupdroptable' => 'Dropping table %s',
    'coreadministrator' => 'Administrator',
    'corestaff' => 'Staff',
    'coregeneral' => 'General',
    'coreguest' => 'Guest',
    'coreregistered' => 'Registered',
    'coredeftgroup' => 'Default Template Group',
    'tcrelatesto' => 'relates to',
    'tcisrelatedto' => 'is related to',
    'tcduplicates' => 'duplicates',
    'tcisduplicatedby' => 'is duplicated by',
    'tcwasclonedas' => 'was cloned as',
    'tcisderivedfrom' => 'is derived from',
    'errorprefix' => 'Error: ',

    'sccachedir' => 'Checking to see if the cache directory is writable',
    'sccachedirerror' => 'The cache directory (./__swift/cache/) is not writeable. Please make this directory writeable',
    'scfilesdir' => 'Checking to see if the files directory is writable',
    'scfilesdirerror' => 'The files directory (./__swift/files/) is not writeable. Please make this directory writeable',
    'sclogsdir' => 'Checking to see if the logs directory is writable',
    'sclogsdirerror' => 'The logs directory (./__swift/logs/) is not writeable. Please make this directory writeable',
    'scappsdir' => 'Checking to see if the apps directory is writable',
    'scappsdirerror' => 'The apps directory (./__apps/) is not writeable. Please make this directory writeable',
    'scgeoipdir' => 'Checking to see if the GeoIP database directory is writable',
    'scgeoipdirerror' => 'The files directory (./__swift/geoip/) is not writeable. Please make this directory writeable',
    'scminphpversion' => 'Checking the server PHP version (minimum version: %s)',
    'scminphpversionerror' => 'The PHP version installed on this server is too old. Kayako requires PHP version <strong>%s</strong> or newer',
    'scfileup' => 'Checking if file uploading is enabled',
    'scfileuperror' => 'Please change <strong>file_uploads</strong> in the php.ini configuration file to <strong>On</strong>',
    'scmaxupsize' => 'Checking the maximum file size for file uploads',
    'scmaxupnotspec' => 'Not specified',
    'scmaxupsizeerror' => 'Change <strong>upload_max_filesize</strong> in the php.ini configuration file to increase the maximum allowed size of uploaded files if necessary (we recommend at least 10 megabytes)',
    'scsafemodecheck' => 'Checking the status of PHP safe mode',
    'scmagicquotesgpc' => 'Checking if magic quotes are disabled',
    'scmagicquotesgpcerror' => 'Magic quotes is enabled in the php.ini configuration file. Please change <strong>magic_quotes_gpc</strong> to <strong>Off</strong>',
    'scdisabled' => 'Disabled',
    'scenabled' => 'Enabled',
    'ftinstalled' => 'Checking to see if <strong>FreeType2</strong> is installed',
    'ftinstallederror' => 'Please install GD with <strong>FreeType2</strong> support',
    'scstrictmode' => 'Checking to see if MySQL is running in strict mode',
    'scstrictmodeerror' => 'Please remove <strong>STRICT_ALL_TABLES</strong> and/or <strong>STRICT_TRANS_TABLES</strong> from your database configuration file (usually called my.cnf)',
    'scextensionerror' => 'The PHP extension <strong>%1$s</strong> is not available. Please review the <u>instructions</u> for enabling %1$s in the PHP manual',
    'scextensioncheck' => 'Checking if the <strong>%s</strong> PHP extension is installed',
    'scinstalled' => 'INSTALLED',
    'scmissing' => 'MISSING',
    'scdbnotempty' => 'The database is not empty. Please click <strong>Clear Database</strong> to delete all existing tables or click <strong>Continue</strong> to proceed with the setup. It is recommended that you install Kayako in an empty database',
    'sccleardb' => 'Clear Database',
    'sccontinue' => 'Continue',
    'scnext' => 'Next &raquo;',
    'scsyscheckfailed' => 'Unfortunately, Kayako cannot be installed. Either an error has occurred or your web server doesn\'t meet the minimum system requirements. Please review any errors shown above and retry the setup process after those items have been resolved',
    'scstartsetup' => 'Start Setup',
    'scpassnomatch' => 'Passwords do not match',
    'scfieldempty' => 'One of the required fields is empty',
    'scinvalidemail' => 'There is a problem with the email address entered',
    'scusernamelong' => 'The username entered is too long',
    'scfieldlong' => 'One of the fields exceeds a maximum length',
    'scsettingsbut' => 'Settings &raquo;',
    'scmodsetfailed' => 'A problem was encountered (setup failed to run %s). Please contact <a href="https://support.gfi.com">GFI support</a>',
    'setupexecsql' => 'Executing: %s',
    'setupexecinsert' => 'Inserting data into: %s',
    'setupexecindex' => 'Creating index: %s for table: %s',
    'setupexectable' => 'Creating table: %s',
    'scinsertsettings' => 'Inserting settings for: %s',
    'scinsertsettingsgroup' => 'Creating settings group: %s',
    'sctemplates' => 'Templates &raquo;',
    'sctemplatecategory' => 'Creating template category: %s',
    'sctemplate' => 'Creating template: %s',
    'sclanguages' => 'Languages &raquo;',
    'scpleasewait' => 'Please Wait...',

    'sclanguage' => 'Creating language: %s',
    'sclanguagesection' => 'Creating language section: %s',
    'scsetupconfirmation' => 'Kayako is now installed on your web server! Visit the admin control panel to further configure your helpdesk.<br/><br/><span style="color:red"><b>Important note:</b> You will not be able to use Kayako until you delete the \'setup\' directory in the root installation directory.</span><br/><br/><span style="color:darkblue"><b>Importing your data:</b></span> You may import help desk data from earlier Kayako products, or from other products through the import engine in the admin control panel.',
    'scupgradeconfirmation' => '<div class="smalltext">Your helpdesk is now up to date.</div><br/><br/><span style="color:red"><b>Important note:</b> You should immediately delete the \'setup\' directory in the root installation directory. Failure to do so can result in an empty database if someone runs the setup.</span>',
    'scadmincp' => 'Admin control panel',
    'scstaffcp' => 'Staff control panel',
    'scclientsc' => 'Support center',

    'scpdaint' => 'PDA Interface',
    'scfinish' => '&raquo; Finish &laquo;',
    'diagresult' => 'Diagnostics Result',
    'stproduct' => 'Product:',
    'stversion' => 'Version:',
    'stbuilddate' => 'Build date:',
    'stbuildtype' => 'Build type:',
    'stsourcetype' => 'Source type:',
    'stverifyingconnection' => 'Verifying database connection',
    'stcurrentversion' => 'Current version:',
    'scaction' => 'Action',
    'sccheckdbstruct' => 'Check Database Structure',
    'diagmissingtables' => 'Missing tables',
    'diagmissingcolumns' => 'Missing columns',
    'diagcolumnmismatch' => 'Metatype mismatch columns',
    'diagcolumnlengthmismatch' => 'Length mismatch columns',
    'diagresultok' => 'Database structure is up to date',
    'diagmissingindexes' => 'Missing indexes',
    'diagindexmismatch' => 'Metatype mismatch indicies',
    'sticketassigned' => 'Notify on ticket assignment',
    'snewuser' => 'User Registration',
    'scmaxexectime' => 'Checking the maximum PHP script execution time',
    'scmaxexectimelessspec' => '<strong>max_execution_time</strong> is set to %d seconds (at least 90 seconds is recommended)',
    'scmaxexectimeerror' => 'Kayako setup needs a longer maximum execution time. Change <strong>max_execution_time</strong> in the php.ini configuration file',


    'statusonhold' => 'On Hold',
    'prlow' => 'Low',

    'statusopen' => 'Open',
    'statusinprogress' => 'In Progress',
    'statusclosed' => 'Closed',
    'prnormal' => 'Normal',
    'prmedium' => 'Medium',
    'prhigh' => 'High',
    'prurgent' => 'Urgent',
    'premergency' => 'Emergency',
    'prcritical' => 'Critical',

    'defaultview' => 'Default View',
    'alltickets' => 'All Tickets',
    'impex' => 'Import',
    'setupwelcome' => 'Welcome to Kayako setup. Please choose an option to begin.',

    // Potentialy unused phrases in setup.php
    'issuefixed' => 'Fixed',
    'issueimplemented' => 'Implemented',
    'issuewontfix' => 'Won\'t Fix',
    'issuewontimplement' => 'Won\'t Implement',
    'issueduplicate' => 'Duplicate',
    'issueincomplete' => 'Incomplete',
    'issuecannotrep' => 'Cannot Reproduce',
    'issuetimedout' => 'Timed Out',
    'issueobsolete' => 'Obsolete',
    'issuenotbug' => 'Not a Bug',
    'issuedeferred' => 'Deferred',
    'issueblocks' => 'Blocks',
    'issueisblockedby' => 'is blocked by',
    'issuerelatesto' => 'relates to',
    'issueisrelatedto' => 'is related to',
    'issueinc' => 'incorporates',
    'issueincby' => 'is incorporated by',
    'issueduplicates' => 'duplicates',
    'issueduplicatedby' => 'is duplicated by',
    'issueclonedas' => 'was cloned as',
    'issueisderived' => 'is derived from',
    'issuebug' => 'Bug',
    'issuefeaturerequest' => 'Feature Request',
    'issueimprovement' => 'Improvement',
    'issuetask' => 'Task',
    'issueopen' => 'Open',
    'issueinprogress' => 'In Progress',
    'issuereopened' => 'Reopened',
    'issueclosed' => 'Closed',
    'issueresolved' => 'Resolved',
    'issuecritical' => 'Critical',
    'issueurgent' => 'Urgent',
    'issuehigh' => 'High',
    'issuemedium' => 'Medium',
    'issuelow' => 'Low',

    // ======= SAMPLE DATA =======

    // User Information
    'sample_userfullname' => 'Phoebe Todd',
    'sample_useremailaddress' => 'phoebe.todd@mycustomerscompanyinc.com',
    'sample_userorganisation' => 'My Customer\'s Company, Inc',
    'sample_usertitle' => 'Procurement Manager',

    // User Organisation Information
    'sample_userorganisationname' => 'My Customer\'s Company, Inc',
    'sample_emaildomainfilters' => 'mycustomerscompanyinc.com',
    'sample_address' => '123 A Street',
    'sample_city' => 'Hillview',
    'sample_state' => 'CA',
    'sample_postalcode' => '94040',
    'sample_tag' => 'demo',

    // User Notes
    'sample_usernoteemailaddress' => 'phoebe.todd@mycustomerscompanyinc.com',
    'sample_usernotecontents' => 'This is a user note, attached to Phoebe\'s account. This note will appear on all of Phoebe\'s tickets and chats. This is useful to bring information about Phoebe to the attention of your team accross all of Phoebe\'s correspondence.',

    // Knowledgebase
    'sample_kbcategoryname' => 'Kayako tips',
    'sample_kbarticlesubject1' => 'Getting to know tickets',
    'sample_kbarticlecontent1' => '<p>All of your customer conversations are tracked as&nbsp;<strong>tickets</strong> in Kayako (you might also know them as&nbsp;<em>support tickets</em>,&nbsp;<em>support requests</em> or&nbsp;<em>incidents</em>).</p><p>Any message which comes into the helpdesk - whether from the web, the support center or email - is tracked as a ticket, keeping everything related to a conversation in one place.</p> <h1>Ticket basics</h1> <h2>Departments</h2> <p>Tickets belong to <strong>departments</strong>. A department is like a folder for tickets: tickets can only belong to one department, and you can assign staff teams or individual staff users to departments, which allows them to access and manage tickets in that department.</p> <p>Typical departments might include&nbsp;<strong>Sales</strong>, <strong>Support</strong>, <strong>Opportunities</strong>, <strong>Bugs</strong> and <strong>Receipts</strong>. Departments can be public or private: if a department is public, it means your customers can select that department when creating a new ticket in the support center.</p> <h2>Ticket properties overview</h2> <p>In Kayako, a ticket has various ticket properties which let you manage incoming requests effectively and build a speedy workflow.&nbsp;</p> <table> <thead> <tr> <td><strong>Property</strong></td> <td><strong>Examples</strong></td> <td><strong>Description</strong></td> </tr> </thead> <tbody> <tr> <td><strong>Type</strong></td> <td>Issue, Feedback, Bug, Lead</td> <td>A ticket type usually indicates the type of ticket, to label tickets with something specific to their content or context. Which ticket types you create depends on your organization. Some Kayako customers like to use ticket types for improved reporting and analytics: for example, the nature of an&nbsp;<strong>Issue</strong> type ticket may well be different to a sales oriented&nbsp;<strong>Lead</strong> ticket.</td> </tr> <tr> <td><strong>Status</strong></td> <td>Open, On Hold, Closed</td> <td>A ticket has a status, which represents where the ticket is on its journey towards resolution. Typically, tickets come in to the helpdesk as <strong>Open</strong>, are set to <strong>On Hold</strong> while you\'re waiting for a response from the customer and are set to&nbsp;<strong>Closed</strong> once the ticket has been resolved. You can create custom statuses to suit your own workflow.&nbsp;&nbsp;</td> </tr> <tr> <td><strong>Owner</strong></td> <td>&nbsp;</td> <td>Tickets can be assigned to individual staff users (who then become owners of the ticket), which usually means that individual will take responsibility for the ticket.</td> </tr> <tr> <td><strong>Priority</strong></td> <td>Low, Medium, High</td> <td>Ticket priorities are fairly self-explanatory. You can create custom priorities to suit your own workflow, and also allow your customers to select their own priority when creating their own tickets (useful because you can configure Kayako to trigger different notifications depending on a ticket\'s priority as well as other properties).&nbsp;</td> </tr> </tbody> </table> <h1>How your customers create tickets</h1> <h2>Using the support center</h2> <p>By default, your customers can submit new tickets in the customer-facing support center (<a href="%s">%s</a>).</p> <p><img src="http://media.kayako.com/assets/trial-content/submit-ticket-button.png" alt="" width="297" height="122" /></p> <p>Your customers can select the department to create the ticket in, as well as a priority, subject, message and file attachments.</p> <p>This is highly configurable: you can create custom fields to capture specific pieces of information from your customers (more about that below), determine which departments they can select, whether or not they can select their own priority or whether they can create their own tickets at all.</p> <p><img src="http://media.kayako.com/assets/trial-content/support-center-submit-ticket.png" alt="" width="1000" height="502" /></p> <p><em>Tip: If you have started building your knowledgebase, Kayako will automatically search for and suggest answers to your customers as they type out their enquiry (reducing the number of incoming support requests, increasing customer WOW!).</em></p> <h2>Email</h2> <p>You can connect your Kayako helpdesk to any number of POP3 or IMAP mailboxes to bring email into the helpdesk from across your organization.</p> <p>By bringing your organization\'s email into the helpdesk, you can enable your team to distribute and collaborate on tickets in one place, rather than managing lots of separate mailboxes and email addresses.&nbsp;</p> <p>Kayako will take care of all the message processing automatically: determining what is a reply to an existing conversation and should be added to an existing ticket, which emails should create a new ticket and whether an existing ticket should be reopened. You can also use Kayako\'s powerful email parser rules to automate the routing of email and tickets.</p> <p>Find out more about fetching email into Kayako below.</p> <h2>The API</h2> <p>You can use the Kayako REST API to automatically create tickets on behalf of anyone - whether generated by your backend systems or other integrated apps.&nbsp;<a href="'.SWIFT_Help::RetrieveHelpLink('restapi').'" target="_blank" rel="noopener noreferrer">Find out more about the Kayako REST API</a>.</p> <h1>How your team reply to customers and resolve tickets</h1> <p>The magic happens in the staff control panel (<a href="%s/staff">%s/staff</a>).</p> <p>Here, your team can review, assign, reply to and mange tickets. Your team can also create tickets (in effect, sending an email to a customer) or create tickets on a customer\'s behalf (for example, if you want to record the details of a phone conversation or ask someone to follow up with the customer by email at a later date).</p> <p>On the left hand side, you will see the&nbsp;<strong>department tree</strong>. This lists all of departments you have been assigned to. Click on status under each department to view the tickets in that department and set to a particular status.</p> <p><img src="http://media.kayako.com/assets/trial-content/ticket-list-staff.png" alt="" width="1000" height="525" /></p> <p>Above the department tree, there are a couple of shortcut filters: <strong>My Tickets</strong> shows you all of the tickets which are open and are assigned to you.&nbsp;<strong>Inbox</strong> shows tickets which are open.&nbsp;<strong>Unassigned</strong>&nbsp;shows tickets which are open and not yet assigned to anyone.</p> <p>Open a ticket and click on the&nbsp;<strong>Reply</strong> tab to start composing a reply. At the same time, you can change the ticket\'s properties (like the status and priority) which will be saved once you send the reply.</p> <p><img src="http://media.kayako.com/assets/trial-content/reply-to-ticket-staff.png" alt="" width="1128" height="857" /></p> <h1>Fetching email into Kayako</h1> <p>You can connect Kayako to any number of POP3 and IMAP mailboxes using&nbsp;<strong>Email Queues</strong>, which are responsible for connecting to the mailboxes, fetching email and processing the email into tickets.&nbsp;</p> <p>Find&nbsp;<strong>Email Parser</strong> in the admin control panel (<a href="%s/admin">%s/admin</a>) and then click on&nbsp;<strong>Email Queues</strong>. Click on <strong>New</strong>, and then follow the steps to connect your mailbox.</p> <p>If you are a Kayako OnDemand customer (if you are trialing Kayako, you are probably trialing Kayako OnDemand), you will find an email queue already configured:&nbsp;<em>support@yourname.kayako.com</em>. This email queue is active - you can start sending email to it right away.</p> <p><a href="https://classic.kayako.com/article/673-setting-up-email-queues" target="_blank" rel="noopener noreferrer">Find out more about creating email queues</a>.</p> <h1>Custom fields</h1> <p>Kayako\'s powerful custom fields builder lets you customize various forms across the helpdesk - including the new ticket form - allowing you to make sure the right information is collected from customers to equip your team to answer customer enquiries quickly.</p> <p>To create a custom field, find&nbsp;<strong>Custom Fields</strong>&nbsp;in the admin control panel (<a href="%s/admin">%s/admin</a>). First, create a custom field&nbsp;<strong>Group</strong>&nbsp;to organize your custom fields. In this example, we have group called&nbsp;<em>Product information</em>&nbsp;and various fields to collect information about a customer\'s product.</p> <p><img src="http://media.kayako.com/assets/trial-content/custom-field-ticket.png" alt="" width="1098" height="720" /></p> <p><a href="https://classic.kayako.com/article/903-creating-custom-fields-for-capturing-user-and-ticket-information" target="_blank" rel="noopener noreferrer">Find out more about customizing your helpdesk with custom fields</a>.</p> <h1>Turbo charging</h1> <p>Kayako is ready to go out of the box. While we\'ve quickly gone through the basics, there is a lot more Kayako can do to turbo charge your support and enable your team to improve customer satisfaction.&nbsp;</p> <p>If you\'re ready to dive in, we suggest starting here:</p> <ul> <li><a href="https://classic.kayako.com/article/1100-establishing-service-level-agreements-slas-and-escalations" target="_blank" rel="noopener noreferrer">Configuring SLA plans to set reply and ticket resolution deadlines</a></li> <li><a href="https://classic.kayako.com/article/889-reusing-common-replies-and-updates-using-macros" target="_blank" rel="noopener noreferrer">Ticket macros to speed up ticket responses</a></li> <li><a href="https://classic.kayako.com/article/912-viewing-sorting-and-filtering-your-support-tickets" target="_blank" rel="noopener noreferrer">Customizing ticket views in the staff control panel</a></li> <li><a href="https://classic.kayako.com/article/912-viewing-sorting-and-filtering-your-support-tickets" target="_blank" rel="noopener noreferrer">Creating custom ticket filters (saved searches) in the staff control panel</a></li> </ul>',
    'sample_kbarticlesubject2' => 'Getting started with live support',
    'sample_kbarticlecontent2' => '<p>Kayako is the fastest way to start offering an engaging, real-time live support experience to your customers.</p> <p>Communicate with your customers over any channel - the web, email, live chat and phone - switch between them seamlessly, and maintain a single, simple support history in Kayako that is only ever one click away from your team.&nbsp;</p> <p>If your organization is serious about scaling live support as a go-to option for your customers, Kayako already has you covered with the tools needed with visitor monitoring, intelligent chat routing, proactive chat invitations sent to your customers and more.</p> <h1>Kayako Desktop</h1> <p>Your team uses Kayako Desktop (for Windows) to connect to your helpdesk to monitor visitors to your website, handle live chats and calls. It is an easy to use, powerful application built for the desktop for speed.</p> <p><a href="http://hotfix.kayako.com/latest.php?product=kd&amp;platform=win32&amp;buildtype=stable">Download Kayako Desktop</a>.</p> <p><img src="http://media.kayako.com/assets/trial-content/kayako-desktop.png" alt="" width="1036" height="660" /></p> <h1>Get started with live chat</h1> <p>After downloading and installing, Kayako Desktop will walk you through logging in to your helpdesk using your staff user name and password.&nbsp;After logging in to the helpdesk, visit your&nbsp;<strong>support center</strong> in your web browser.</p> <p>You should now see that the&nbsp;<strong>live support&nbsp;</strong>button now says online.</p> <p><img src="http://media.kayako.com/assets/trial-content/live-support-button.png" alt="" width="454" height="121" /></p> <p>Clicking on this button opens a live chat request form. You can try this yourself &nbsp;(but you\'ll be chatting with yourself, if you\'re also the staff user signed into Kayako Desktop!).</p> <p>Once a customer is in a live chat, their chat window looks like this:</p> <p><img style="border-width: 0; background: none;" src="http://media.kayako.com/assets/trial-content/customer-chat-window.png" alt="" width="653" height="801" /></p> <p>Whether the live support is online or offline is determined by who in your team has set their status to&nbsp;<strong>available</strong>&nbsp;in Kayako Desktop (check the top-left icon). If none of your team is available, when a customer clicks on the <em>offline</em>&nbsp;live support button they will be invited to leave a message.</p> <h1>Chat Gateway</h1> <p>Kayako Desktop for Windows is not the only way to handle live chats. Using the Kayako Chat Gateway, your team can log in to your helpdesk using any instant messenger client that supports Jabber (such as Adium, Messages for Mac, Pidgin and Trillian) and handle live chats from anywhere and on the go.</p> <p><img style="border-width: 0; background: none;" src="http://media.kayako.com/assets/trial-content/chat-gateway.png" alt="" width="617" height="560" /></p> <p><a href="http://www.kayako.com/products/chat-gateway">Find out more about connecting to the Kayako Chat Gateway</a>.</p> <h1>Put a live support button on your website</h1> <p>Navigate to the admin control panel and click on&nbsp;<strong>Tag Generator</strong> on the left-hand menu. Walk through the steps, and Kayako will generate a piece of code that you can insert into the HTML of any of your web pages.</p> <p><img src="http://media.kayako.com/assets/trial-content/generate-tag.png" alt="" width="838" height="439" /></p> <p>What happens when your customers click on the live support button is completely configurable. By default, you will be able to monitor visitors on any web page which has the live support button code.</p> <p>You can see how visitors found your website, the search terms they used and what they have browsed so far. This is ideal for delivering proactive customer service: whether that is identifying an opportunity to turn a visitor into a customer, or to offer a helping hand to someone who might be lost.</p> <h1>Getting started with phone and click-to-call</h1> <p>With Kayako Desktop, you can connect to your existing VoIP service to handle and capture call records into the helpdesk. By handling calls with Kayako Desktop, your team will have instant access to your customer\'s support history and information, equipping them to deliver better customer service.</p> <p>Using the software phone built into Kayako Desktop, your team can use their existing VoIP provider, such as Vonage, and sign in to their extension.</p> <p><img src="http://media.kayako.com/assets/trial-content/kayako-desktop-call.png" alt="" width="1032" height="660" /></p> <p>Calls can be answered and made right from Kayako Desktop as with any other software phone. Each call is logged in the helpdesk and added to your customer\'s support history, and if call recording is enabled, can be played back from the helpdesk.</p> <h2>Click-to-call</h2> <p>As well as being able to generate live support button for your customers to request live chats, if you decide to handle calls using Kayako you can create a&nbsp;<strong>click-to-call</strong> request button.</p> <p><img src="http://media.kayako.com/assets/trial-content/click-to-call-button.png" alt="" width="185" height="118" /></p> <p>A click-to-call button works in a similar way to a live chat button. Your customer will be asked for the name, request subject and phone number. Rather than receiving a new chat request, your team will receive a click to call request which they can instantly respond to with a call.</p> <p><img src="http://media.kayako.com/assets/trial-content/click-to-call-request.png" alt="" width="1032" height="243" /></p> <p>If available, Kayako will automatically load the customer\'s support history. Customer WOW, guaranteed.</p> <p><a href="https://classic.kayako.com/article/707-enabling-voip-phone-support-in-kayako-desktop" target="_blank" rel="noopener noreferrer">Find out more about using Kayako Desktop with your VoIP service</a>.</p> <h1>Browse live support history</h1> <p>All of your customers\' live support history - both chats, calls and post-chat satisfaction surveys - can be managed in the staff control panel under the&nbsp;<strong>Live Support</strong> tab. From here, you can search and filter live support records, add notes and play back any call recordings.</p> <p><img src="http://media.kayako.com/assets/trial-content/live-support-history.png" alt="" width="1122" height="705" /></p> <p>In addition, any live chat or call captured by the helpdesk will be visible under a customer\'s profile (in the staff control panel under the&nbsp;<strong>Users</strong> tab) and also any ticket your customer may create in the future.&nbsp;</p> <p>Your team is only ever one click away from a complete customer support history.</p> <h1>Keep going</h1> <p>If you\'re ready to dig even further into what you can achieve with live support using Kayako:</p> <ul> <li><a href="https://classic.kayako.com/article/1324-installing-and-configuring-kayako-desktop" target="_blank" rel="noopener noreferrer">Kayako Desktop user guide</a></li> <li><a href="https://classic.kayako.com/article/914-enabling-live-chat-on-your-support-center-and-websites" target="_blank" rel="noopener noreferrer">Administrator\'s guide to live support</a> (for configuring live support routing, visitor rules, staff skills)</li> <li><a href="https://classic.kayako.com/article/914-enabling-live-chat-on-your-support-center-and-websites" target="_blank" rel="noopener noreferrer">Staff user\'s guide to live support</a> (reviewing live support histories, canned responses)</li> </ul>',

    // News
    'sample_newscatname' => 'General',
    'sample_newsarticletitle1' => 'Welcome to Kayako',
    'sample_newsarticlecontent1' => '<p>Welcome to the&nbsp;<strong>staff control panel</strong> - where the magic happens. This is the place where your team delights your customers: where they respond to and resolve tickets, review live chat histories, manage customers, publish self-service content and run reports.</p> <h2>Types of user</h2> <p>In Kayako, your customers are called&nbsp;<strong>end-users</strong> and your team users are called&nbsp;<strong>staff users</strong> (you might refer to them as agents or operators).</p> <p>These two types of user are distinct. End-users are managed here in the staff control panel (click on&nbsp;<strong>Users</strong> at the top). Staff users are managed in the&nbsp;<strong>admin control panel</strong> (<a href="%s/admin">%s/admin</a>).</p> <p>A staff user can only access the admin control panel if they are part of a&nbsp;<strong>staff team</strong>&nbsp;which has permission to access to the admin control panel.</p> <h2>What next?</h2> <ul> <li>Read through the quick&nbsp;<a href="https://classic.kayako.com/section/194-quick-start-guides" target="_blank" rel="noopener noreferrer">getting started guide</a>.</li> <li>Bring your team - log in to the <a href="%s/admin/">admin control panel</a> and add staff teams and users.</li> </ul> <h2>Other areas of the helpdesk</h2> <p>Kayako has three main areas:</p> <ul> <li><a href="%s/staff">Staff control panel</a>&nbsp;- you are here.</li> <li><a href="%s/admin">Admin control panel</a>&nbsp;- where the configuration happens. Any major configutation of the helpdesk - such as changing settings, configuring email or changing the look and feel of the support center - takes place here.</li> <li><a href="%s/">Support center</a>&nbsp;- the central place for your end-users to get customer support. Here they can find answers to their questions in the knowledgebase, or contact your team by submitting a ticket or starting a live chat.</li> </ul> <h2>This is a news article</h2> <p>This is a <strong>news article</strong>. News articles can be published publicly (available in the support center), privately (only available in the staff control panel and visible to your team, like this one) or globally (both). To manage news articles,&nbsp;click&nbsp;<strong>News</strong> at the top.</p><p>You can delete this demo article at any time.</p>',
    'sample_newsarticletitle2' => 'Welcome to the support center',
    'sample_newsarticlecontent2' => '<p>Welcome to the <strong>support center</strong>, the go-to place for support for your customers.&nbsp;Your customers can browse and search self-service content like the knowledgebase and news.&nbsp;</p> <p>If they can\'t find an answer, they can submit a new ticket or start a live chat (if your staff are available) to get in touch with your team. If your end-user already has an account, they can log in to the support center to browse and manage their previous correspondence with you.</p> <h2>Your customers</h2> <p>In Kayako, your customers are called <strong>end-users</strong> (and members of your team are called <strong>staff users</strong>).</p> <p>By default, your end-users can use the entire support center and submit new tickets without registering. If an end-user submits a ticket, the helpdesk will create an account for them. With Kayako, all of this is&nbsp;configurable: you can control who can submit tickets, who can register and which groups of users can access certain parts of the support center.</p> <h2>What next</h2> <p>While you\'re here, get a feel for how your customers might use the support center.</p> <ul> <li><a href="%s/Knowledgebase/List">Check out the knowledgebase</a>&nbsp;and browse the example articles</li> <li>Try and <a href="%s/Tickets/Submit">submit a ticket</a></li> <li>Start exploring the&nbsp;<a href="%s/staff">staff control panel</a>, and find that ticket you submitted to yourself</li> </ul> <h2>Other areas of the helpdesk</h2> <p>Kayako has three main areas:</p> <ul> <li><a href="%s/">Support center</a> - you\'re here.</li> <li><a href="%s/staff">Staff control panel</a> - where the magic happens. Your team will log in to the staff control panel to answer tickets, manage users and publish self-service content to the support center.</li> <li><a href="%s/admin">Admin control panel</a> - where the configuration happens. Any major configutation of the helpdesk - such as changing settings, configuring email or changing the look and feel of the support center - takes place here.</li> </ul> <h2>This is a news article</h2> <p>This is a&nbsp;<strong>news article</strong>. News articles can be published publicly (available in the support center, like this article), privately (only available in the staff control panel) or globally (both). To manage news articles, log in to the <a href="%s/staff/">staff control panel</a> and click <strong>News</strong>.</p><p>You can delete this demo article at any time.</p>',

    // Livechat
    'sample_livechatsubject' => 'Checking out live chat',
    'sample_livechatvisitorruletitle' => 'Group visitors referred by a search engine',

    // Call logs
    'sample_phonenumber' => '+18005550199',

    // Livechat Messages or Surveys
    'sample_messagesubject' => 'I left this message because live chat was unavailable',
    'sample_messagecontents' => 'When live chat is unavailable (i.e. none of your team are logged in to live chat, or their status has been set to unavailable), the live support button on your support center will say "Offline". Your customers can still click on this button, but will be invited to "Leave a message". You can reply directly to your customers right here, or convert this message to a ticket.',

    // Livechat Canned responses
    'sample_cannedresponsecattitle' => 'Demo canned responses',
    'sample_cannedresponsetitle' => 'A demo canned response',
    'sample_cannedmessagecontent' => 'This is a demo canned response. A canned response is a prescribed reply which can be used by your team in live chat conversations, to speed up support (using Kayako Desktop, they can even assign canned responses to hotkey combinations).',

    // Departments
    'sample_departmentname' => 'Support',

    // Ticket Macros
    'sample_macrocategoryname' => 'Demo macros',
    'sample_macrotitle' => 'Demo ticket macro',
    'sample_macroreplycontents' => 'This is a sample ticket macro. A ticket macro is like a predefined reply on steroids: as well as pasting a prewritten piece of text into the ticket reply area, you can configure a ticket macro to change various ticket properties. For example, this macro will change a ticket\'s priority to High and change its department to Support. Macros are great for automating repetitive tasks and ticket workflow changes, allowing your team to focus on your customer.',

    // CustomField Group
    'sample_customfieldgrouptitle' => 'Product information',
    'sample_customfieldselecttitle' => 'Your product',
    'sample_customfieldselectdescription' => 'Which product are you contacting us about?',
    'sample_customfieldtexttitle' => 'Serial number',
    'sample_customfieldtextdescription' => 'What is your serial number? You can find this on the underside on a red label.',
    'sample_customfieldselectoption1' => 'Acme Anvil 1000',
    'sample_customfieldselectoption2' => 'Acme Anvil 2000',
    'sample_customfieldselectoption3' => 'Acme Anvil 3000',

    // Staff teams
    'sample_staffteamtitle' => 'Observers (read only)',

    // Notifications
    'sample_notificationnewreply' => 'Notify ticket owner on new reply',
    'sample_notificationnewticketcreated' => 'Notify entire department on new ticket',

    // Ratings
    'sample_ratinglabel' => 'Reply rating',


    // Tickets
    'sample_ticketsubject' => 'This is a sample ticket',
    'sample_ticketcontent' => "Hi,\n\nThis is a GFI HelpDesk ticket. I am a customer (a test customer, only created to demo Kayako to you), and I created this ticket through the support center (%s).\n\nIf you are reading this ticket, you are probably doing so through the staff control panel (%s/staff). If you haven't already, I recommend reading the short guide to getting started with tickets - a demo article which has been created in your knowledgebase (%s).\n\nWhy not try closing this ticket, changing its priority and removing yourself as the owner of the ticket?\n\n1) Click on the ticket properties bar above\n2) Change the ticket status to \"Closed\"\n3) Change the priority to \"Low\"\n4) Change the owner to \"Unassigned\"\n5) Hit the \"Update\" button\n\nThis will close the ticket, change the priority and remove yourself as its owner.\n\nBecause you are no longer the owner of this ticket, it will no longer appear under \"My Tickets\" on the left. \n\nYou can always find the ticket again, either by (a) searching for it or (b) clicking on the \"Closed\" status under the \"Support\" Department from the menu on the left to display all of the closed tickets in the \"Support\" department.\n\nIf you have any questions, please do not hesitate to contact the GFI HelpDesk support team from: https://support.gfi.com - we are here to help.\n\nHappy helpdesking,\n\n\n---\nPhoebe Todd\nA Kayako Demo Robot\n",


    // Email Queues
    'sample_emailqueueaddress' => 'support@%s.kayako.com',
);


return $__LANG;
