<?php
/**
 * ###############################################
 *
 * SWIFT Framework
 * _______________________________________________
 *
 * @author         Varun Shoor
 *
 * @package        SWIFT
 * @copyright      Copyright (c) 2001-2014, Kayako
 * @license        http://www.kayako.com/license
 * @link           http://www.kayako.com
 *
 * ###############################################
 */

// Initial pass done
// Usage script run

$__LANG = array(
    'settings'                             => 'Configuración',
    'loginsharesettings'                   => 'Configuración de LoginShare',
    'staff'                                => 'Personal',
    'users'                                => 'Usuarios',
    'restapi'                              => 'REST API',
    'reports'                              => 'Informes',
    'groups'                               => 'Grupos',
    'titleurlinvaliddata'                  => 'Formato de URL no válido',
    'desc_titleurlinvaliddata'             => 'Esta URL no parece estar en el formato correcto; por favor, verifíquela e inténtelo de nuevo.',

    // ======= SETTING GROUPS =======
    'settings_general'                     => 'General',
    'settings_cpu'                         => 'Rendimiento y configuración del servidor',
    'settings_security'                    => 'Seguridad',
    'settings_datetime'                    => 'Fecha y hora',
    'settings_tickets'                     => 'Tickets',
    'settings_parser'                      => 'Analizador de correos electrónicos',
    'settings_tr'                          => 'Solucionador de problemas',
    'settings_users'                       => 'Organizaciones y cuentas de usuario',
    'settings_nw'                          => 'Noticias',
    'settings_kb'                          => 'Base de conocimientos',
    'settings_mail'                        => 'Correo electrónico',
    'settings_livechat'                    => 'Soporte en vivo',
    'settings_loginshare'                  => 'LoginShare',

    // ======= IMPORT FROM v3 CVS =======
    't_searchticketidinbody'               => 'Buscar ID del ticket en el cuerpo del correo electrónico',
    'd_t_searchticketidinbody'             => 'Si no se puede encontrar el ID del ticket en el asunto del correo electrónico, el helpdesk buscará el ID del ticket en el cuerpo del correo electrónico.',

    // ======= GENERAL SETTINGS =======
    'd_customurl'                          => 'Si desea cambiar el dominio debe contactar a soporte de GFI: <a href="https://support.gfi.com" target="_blank" rel="noopener noreferrer">https://support.gfi.com</a>',
    'd_customurlwarning'                   => 'Si desea cambiar el dominio siga las instrucciones en <a target="_blank" rel="noopener noreferrer" href="%s">esta gu&iacute;a</a>.',
    'general_companyname'                  => 'Nombre de la organización',
    'd_general_companyname'                => 'Se utilizará el nombre de la organización para personalizar el centro de soporte y los correos electrónicos salientes. Por ejemplo: <em>Acme S.A.</em>.',
    'general_producturl'                   => 'URL base del helpdesk',
    'd_general_producturl'                 => 'La dirección URL completa al helpdesk, incluyendo una barra. Por ejemplo: <em>https://soporte.acme.com/</em>',
    'general_returnemail'                  => 'Dirección de correo electrónico de retorno por defecto',
    'd_general_returnemail'                => 'Esta dirección se utilizará como la dirección de retorno para correos electrónicos enviados desde el helpdesk. Sería ideal configurar una cola de correo electrónico correspondiente para poder recuperar las respuestas de los usuarios en el helpdesk.',
    'general_themeoptions'                 => 'Paneles de control',
    'g_displaytopheader'                   => 'Mostrar logotipo en cabecera',
    'd_g_displaytopheader'                 => 'El logo aparecerá en la cabecera del panel de control.',
    'g_onlusr'                             => 'Mostrar personal conectado',
    'd_g_onlusr'                           => 'Mostrar una lista de usuarios del personal conectados en los paneles de control.',
    'g_api'                                => 'Configuración de API',
    'g_enableapiinterface'                 => 'Activar API',
    'd_g_enableapiinterface'               => 'Determinar si el la API del helpdesk está activada o no.',
    'g_generalsettings'                    => 'Configuración general',
    'g_maxtagcloud'                        => 'Número máximo de etiquetas en la nube',
    'd_g_maxtagcloud'                      => 'El número máximo de etiquetas que aparecerán en la nube de etiquetas del panel control del personal.',
    'g_maxsearchresults'                   => 'Número máximo de resultados de búsqueda',
    'd_g_maxsearchresults'                 => 'El número máximo de resultados de la búsqueda que será mostrado para búsquedas en el centro de soporte.',

    // ======= CPU SAVING & OPTIMIZATION =======
    'cpu_attachments'                      => 'Configuración de archivos adjuntos',
    'cpu_attachtype'                       => 'Ubicación de almacenamiento de archivos adjuntos',
    'd_cpu_attachtype'                     => 'La ubicación recomendada es <strong>en el sistema de archivos</strong>.',
    'database'                             => 'En la base de datos',
    'files'                                => 'En el sistema de archivos (directorio de /archivos/)',
    'cpu_attachchunksize'                  => 'Tamaño de segmentos de archivos adjuntos en la base de datos',
    'd_cpu_attachchunksize'                => 'Si almacena archivos adjuntos en la base de datos, éstos serán fragmentados en segmentos de hasta este tamaño (en bytes). Este debe ser menor al ajuste <strong>maximum packet size</strong> en su archivo de configuración de MySQL.',
    'cpu_optimization'                     => 'Optimizaciones',
    'cpu_winappcompresslevel'              => 'nivel de compresión gzip',
    'd_cpu_winappcompresslevel'            => 'Seleccione el nivel de compresión gzip para páginas procesadas por el helpdesk. Un valor más alto se traduce en páginas más pequeñas con una mayor demanda en el servidor. Hoy en día, las conexiones son lo suficientemente rápidas como para que un <em>1</em> sea conveniente.',
    'nocompression'                        => 'Sin compresión',
    'reccompression'                       => 'Recomendado',
    'highestcompression'                   => 'El más alto',
    'cpu_compresswinappdata'               => 'Comprimir datos de Kayako Desktop',
    'd_cpu_compresswinappdata'             => '',
    'cpu_hidereportexportxlsoption'        => 'Hide Export Report to Excel Option from all Staff Members',
    'd_cpu_hidereportexportxlsoption'      => 'It is advisable to keep Export report to excel option hidden in case of peak load conditions.',
    'cpu_logcleardays'                     => 'Tiempo de retención de registros',
    'd_cpu_logcleardays'                   => 'El número de días tras el cual se eliminan los registros del helpdesk.',
    'cpu_mailsettings'                     => 'Configuración de correos saliente',
    'cpu_enablehtmlmails'                  => 'Enviar correos electrónicos en HTML',
    'd_cpu_enablehtmlmails'                => 'Todos los correos enviados desde el helpdesk serán enviados usando HTML (así como una versión de texto llano).',
    'cpu_enablemailqueue'                  => 'Colocar correos electrónicos salientes en cola',
    'd_cpu_enablemailqueue'                => 'El helpdesk enviará los correos saliente en lotes y no todos a la vez. Esto puede evitar que el helpdesk se ralentice al enviar correos masivos.',
    'cpu_mailqueuebatch'                   => 'Tamaño del lote de correos electrónicos',
    'd_cpu_mailqueuebatch'                 => 'El número de mensajes de correo electrónico que enviar por lote.',
    'cpu_smtp'                             => 'Configuración de SMTP',
    'cpu_enablesmtp'                       => 'Utilice un servidor SMTP para enviar correos electrónicos',
    'd_cpu_enablesmtp'                     => 'Por defecto, Kayako utilizará el gestor de correos del servidor para enviar correos electrónicos (PHP mail()) a menos que se configure un servidor SMTP aquí.',
    'cpu_smtphost'                         => 'Nombre del host del servidor SMTP',
    'd_cpu_smtphost'                       => 'Por ejemplo: <em>smtp.gmail.com</em>.',
    'cpu_smtpport'                         => 'Puerto del servidor SMTP',
    'd_cpu_smtpport'                       => 'Este es generalmente el puerto número <strong>25</strong>.',
    'cpu_smtpportssl'                      => 'Puerto SMTP (TLS/SSL)',
    'd_cpu_smtpportssl'                    => 'Este es generalmente el puerto número <strong>465</strong>.',
    'cpu_smtpuseauth'                      => 'Usar autenticación SMTP',
    'd_cpu_smtpuseauth'                    => 'Si el servidor SMTP especificado arriba requiere autenticación, habilite esta configuración e introduzca las credenciales más abajo.',
    'cpu_smtpuser'                         => 'Nombre de usuario del servidor SMTP',
    'd_cpu_smtpuser'                       => '',
    'cpu_smtppass'                         => 'Contraseña del servidor SMTP',
    'd_cpu_smtppass'                       => '',
    'cpu_smtptype'                         => 'Tipo de conexión SMTP',
    'd_cpu_smtptype'                       => 'Si no estás seguro de cuál es póngase en contacto con el administrador del servidor.',
    'smtpssl'                              => 'SSL',
    'smtptls'                              => 'TLS',
    'smtpnonssl'                           => 'No SSL',
    'smtpssl2'                             => 'SSL v2',
    'smtpssl3'                             => 'SSL v3',
    'encqp'                                => 'quoted-printable',
    'encbase64'                            => 'base64',
    'encbinary'                            => 'binario',
    'cpu_headerencoding'                   => 'Codificación del encabezado del correo electrónico',
    'd_cpu_headerencoding'                 => 'El esquema de codificación del encabezado MIME del correo. El valor predeterminado es base64.',
    'cpu_messageencoding'                  => 'Codificación de cuerpo del mensaje',
    'd_cpu_messageencoding'                => 'El esquema de codificación para el cuerpo del correo electrónico. El valor predeterminado es quoted-printable.',
    'cpu_maildefaultpriority'              => 'Prioridad del correo por defecto',
    'd_cpu_maildefaultpriority'            => 'Todos los correos electrónicos del helpdesk serán enviados con esta prioridad. Esta es distinta de la prioridad del ticket.',
    'mailprioritylow'                      => 'Baja (5)',
    'mailprioritynormal'                   => 'Normal (3)',
    'mailpriorityhigh'                     => 'Alta (1)',

    // ======= SECURITY =======
    'security_sessioninactivity'           => 'Expiración de sesión',
    'd_security_sessioninactivity'         => 'El tiempo (en segundos) después del cual se eliminará una sesión inactiva de un usuario.',
    'security_sessionvar'                  => 'Tipo variable de sesión',
    'security_visitorinactivity'           => 'Caducidad de sesión para visitantes del sitio',
    'd_security_visitorinactivity'         => 'El tiempo (en segundos) que un visitante tiene que estar inactivo hasta que su sesión se elimine (y ya no sea seguido en el Kayako Desktop).',
    'security_cookiedomain'                => 'Dominio de la cookie',
    'd_security_cookiedomain'              => 'Si hay varias instalaciones de Kayako compartiendo el mismo nombre de dominio, especifique el dominio de la cookie aquí.',
    'security_cookiepath'                  => 'Ruta de la cookie',
    'd_security_cookiepath'                => 'Si hay varias instalaciones de Kayako compartiendo el mismo nombre de dominio, especifique la ruta de la cookie aquí.',
    'cookie'                               => 'Cookie',
    'url'                                  => 'URL',
    'urlcookie'                            => 'URL &amp; Cookie',
    'security_staffpasswordpolicy'         => 'Política de contraseñas del personal',
    'security_scpasswordpolicy'            => 'Support Center Users Password Policy',
    'security_sppminchars'                 => 'Longitud mínima de la contraseña',
    'security_scpminchars'                 => 'Longitud mínima de la contraseña',
    'd_security_sppminchars'               => 'Las contraseñas del personal deben superar esta longitud.',
    'd_security_scpminchars'               => 'Las contraseñas del personal deben superar esta longitud.',
    'security_sppminnumbers'               => 'Número mínimo de dígitos',
    'security_scpminnumbers'               => 'Número mínimo de dígitos',
    'd_security_sppminnumbers'             => 'Las contraseñas del personal deben incluir al menos este número de dígitos.',
    'd_security_scpminnumbers'             => 'Las contraseñas del personal deben incluir al menos este número de dígitos.',
    'security_sppminsymbols'               => 'Número mínimo de símbolos',
    'security_scpminsymbols'               => 'Número mínimo de símbolos',
    'd_security_sppminsymbols'             => 'Las contraseñas del personal deben incluir al menos este número de símbolos.',
    'd_security_scpminsymbols'             => 'Las contraseñas del personal deben incluir al menos este número de símbolos.',
    'security_sppmincapitalchars'          => 'Número mínimo de letras mayúsculas',
    'security_scpmincapitalchars'          => 'Número mínimo de letras mayúsculas',
    'd_security_sppmincapitalchars'        => 'Las contraseñas del personal deben incluir al menos este número de caracteres en MAYÚSCULAS.',
    'd_security_scpmincapitalchars'        => 'Las contraseñas del personal deben incluir al menos este número de caracteres en MAYÚSCULAS.',
    'security_sppexpiredays'               => 'La contraseña caduca en',
    'd_security_sppexpiredays'             => 'Se pedirá al personal que cree una nueva contraseña después de esta cantidad de días. Fíjelo en <em>0</em> para que no caduque.',
    'security_captcha'                     => 'Configuración de CAPTCHA',
    'security_comment_settings'            => 'Configuración de comentarios',
    'security_captchatype'                 => 'Tipo de CAPTCHA',
    'captchalocal'                         => 'Usar CAPTCHA estándar',
    'captcharecaptcha'                     => 'Usar ReCAPTCHA',
    'd_security_captchatype'               => 'ReCAPTCHA es un servicio más eficaz que CAPTCHA. Para obtener más información, vea <a href="http://www.recaptcha.net" target="_blank" rel="noopener noreferrer">recaptcha.net</a>. Para utilizar ReCAPTCHA, debe crear una cuenta gratuita de ReCAPTCHA y completar los datos a continuación.',
    'security_recpublickey'                => 'Clave pública ReCAPTCHA',
    'd_security_recpublickey'              => 'Si está usando ReCAPTCHA (especificado arriba), introduzca su clave pública.',
    'security_recprivatekey'               => 'Clave privada de ReCAPTCHA',
    'd_security_recprivatekey'             => 'If using ReCAPTCHA (specified above), enter your private key.',
    'security_autoapprovecomments'         => 'Aprobar comentarios automáticamente',
    'd_security_autoapprovecomments'       => 'El helpdesk aprobará automáticamente los comentarios y serán inmediatamente visibles en el centro de soporte. Si se deshabilita, no serán visibles hasta que el personal los haya aprobado.',
    'security_enableakismet'               => 'Activar búsqueda de spam Akismet para comentarios',
    'd_security_enableakismet'             => 'Akismet is an anti-spam service for comments. For more information, visit <a href="http://akismet.com" target="_blank" rel="noopener noreferrer">akismet.com</a>. To use Askimet you will need to register for a free account and API key.',
    'security_akismetkey'                  => 'Clave API de Akismet',
    'd_security_akismetkey'                => 'Your Akismet API key.',
    'security_commentscaptcha'             => 'Exigir CAPTCHA para comentarios',
    'd_security_commentscaptcha'           => 'Se pedirá a los usuarios a completar un CAPTCHA para publicar un comentario para verificar que son humanos.',
    'security_loginpolicy'                 => 'Protección de inicio de sesión',
    'security_securesessions'              => 'Enable secure sessions',
    'd_security_securesessions'            => 'This setting will prevent an attacker from capturing your staff user\'s session data and hijacking their helpdesk session.',
    'security_scloginpolicy'               => 'Login Protection For Support Center Users',
    'security_loginlocked'                 => 'Impedir al personal iniciar sesión durante un tiempo después de varios intentos de inicio de sesión fallidos',
    'security_scloginlocked'               => 'Prevent user from logging in for a period of time after too many failed login attempts',
    'd_security_loginlocked'               => 'Se impedirá al personal intentar iniciar sesión en el helpdesk al introducir credenciales equivocadas demasiadas veces.',
    'd_security_scloginlocked'             => 'User will be prevented from trying to log in to the helpdesk if they enter the wrong credentials too many times.',
    'security_loginattempts'               => 'Número de intentos de inicio de sesión fallidos antes de bloqueo',
    'security_scloginattempts'             => 'Número de intentos de inicio de sesión fallidos antes de bloqueo',
    'd_security_loginattempts'             => 'Después de esta cantidad de intentos de inicio de sesión fallidos, el usuario del personal no podrá volver a intentar iniciar sesión.',
    'd_security_scloginattempts'           => 'After this number of failed login attempts, the end user will be prevented from trying to login again.',
    'security_loginlockedtimeline'         => 'Eliminar bloqueo después de',
    'security_scloginlockedtimeline'       => 'Eliminar bloqueo después de',
    'd_security_loginlockedtimeline'       => 'El número de segundos que el usuario del personal debe esperar para poder intentar iniciar sesión nuevamente.',
    'd_security_scloginlockedtimeline'     => 'The number of seconds the end user has to wait before they can try to login again.',
    'security_sessionipcheck'              => 'Validate sessions by checking IP address',
    'd_security_sessionipcheck'            => 'Secure against cookie and session hijacking by validating the IP address of a user each time they interact with Kayako. We recommend enabling this setting if you do not use secure connections (https://).<br /><br /><strong>More information:</strong><br />Each time a user logs in to Kayako, a session is created. Each session is linked to the IP address of a user. When this setting is enabled, each interaction with Kayako is validated by checking the user\'s current IP address with the one used to create the session. If they don\'t match, the user will need to log in again. If you regularly use an Internet service with dynamic IP addresses that change often, you may wish to disable this setting to prevent your staff users from being logged out.',

    // ======= LOGINSHARE =======
    'loginshare_staff'                     => 'Staff LoginShare Settings',
    'loginshare_staffenable'               => 'Habilitar autenticación externa para el personal',
    'd_loginshare_staffenable'             => 'El soporte técnico intentará autenticar a los usuarios del personal usando la API de LoginShare externa (especificada a continuación).',
    'loginshare_stafftitle'                => 'Staff LoginShare API name',
    'd_loginshare_stafftitle'              => 'For example, <em>My Active Directory server</em>.',
    'loginshare_staffurl'                  => 'URL de la API de LoginShare para personal',
    'd_loginshare_staffurl'                => 'Introduzca la URL a la API de LoginShare API que se utilizará para autenticar al personal. <a href="https://go.gfi.com/?pageid=GFIHelpDeskLoginShare" target="_blank" rel="noopener noreferrer">Lea más sobre LoginShare</a>.',

    'loginshare_user'                      => 'User LoginShare Settings',
    'loginshare_userenable'                => 'Activar autenticación externa para usuarios',
    'd_loginshare_userenable'              => 'El helpdesk intentará autenticar a los usuarios usando la API de LoginShare externa (especificada a continuación).',
    'loginshare_usertitle'                 => 'Nombre la API de LoginShare para el usuario',
    'd_loginshare_usertitle'               => 'For example, <em>My Active Directory server</em>.',
    'loginshare_userurl'                   => 'URL de la API de LoginShare para el usuario',
    'd_loginshare_userurl'                 => 'Introduzca la URL a la API de LoginShare API que se utilizará para autenticar usuarios.  <a href="https://go.gfi.com/?pageid=GFIHelpDeskLoginShare" target="_blank" rel="noopener noreferrer">Lea más sobre LoginShare</a>.',

    // ======= DATE & TIME =======
    'dtcalus'                              => 'US (mm/dd/yy + 12hr)',
    'dtcaleu'                              => 'EU (dd/mm/yy + 24hr)',
    'dt_caltype'                           => 'Formato del selector de fecha',
    'd_dt_caltype'                         => 'Este es el formato de fecha y hora que utilizará el selector de fecha (un calendario emergente para una fácil selección de fecha y hora).',
    'dt_dateformat'                        => 'Formato de fecha',
    'd_dt_dateformat'                      => 'El helpdesk formateará todas las fechas de esta forma. Para más información sobre la sintaxis, vea <a href="http://www.php.net/strftime" target="_blank" rel="noopener noreferrer">strftime()</a>.',
    'dt_timeformat'                        => 'Formato de hora',
    'd_dt_timeformat'                      => 'El helpdesk formateará todas las horas así.',
    'dt_datetimeformat'                    => 'Formato de fecha y hora',
    'd_dt_datetimeformat'                  => 'Cuando las fechas y horas se muestren juntas, el helpdesk las formateará así.',
    'dt_timezonephp'                       => 'Zona horaria por defecto del helpdesk',
    'd_dt_timezonephp'                     => 'Esta es la zona horaria por defecto del helpdesk. A menos que el personal y los usuarios especifiquen su propia zona horaria, se utilizará esta zona horaria predeterminada.',
    'dt_daylightsavings'                   => 'Detectar automáticamente horario de verano',
    'd_dt_daylightsavings'                 => 'El helpdesk detectará cuándo al horario de verano entra en vigor y ajustará en consecuencia la hora.',

    // ======= LIVE CHAT =======
    'livesupport_routingsettings'          => 'Configuración de colas',
    'ls_routingmode'                       => 'Modo de colas de chat en vivo',
    'd_ls_routingmode'                     => '<strong>Turno rotatorio</strong> Kayako enviará una petición de chat entrante al personal disponible menos ocupado. Si este no acepta la petición, lo intentará con el siguiente personal menos ocupado.<br /><strong>Cola abierta</strong> Las peticiones de chat entrantes de añadirán a una cola abierta sobre la cual todo el personal disponible será alertado a la vez. Si nadie acepta la petición el chat permanecerá en la cola hasta que alguien lo haga.',
    'ls_roundrobin'                        => 'Turno rotatorio',
    'ls_openqueue'                         => 'Cola abierta',
    'ls_openqueuetimeout'                  => 'Tiempo de espera máximo',
    'd_ls_openqueuetimeout'                => 'El tiempo máximo (en segundos) que una solicitud de chat puede esperar en una <em>cola abierta</em> antes de invitar al usuario a que dejer un mensaje.',
    'livesupport_roundrobinretries'        => 'Número máximo de intentos de turno rotatorio',
    'd_livesupport_roundrobinretries'      => 'El número máximo de personal con el que el helpdesk lo intentará antes de invitar al usuario a que dejer un mensaje.',
    'livesupport_roundrobintimetry'        => 'Intervalo de intento de turno rotatorio',
    'd_livesupport_roundrobintimetry'      => 'El tiempo en segundos que esperará el helpdesk a que un miembro del personal acepte una petición de chat. Si no acepta la petición a tiempo, el helpdesk pasará al siguiente usuario del personal.',
    'livesupport_displayclientchatqueue'   => 'Mostrar al visitante el número de chats en la cola',
    'd_livesupport_displayclientchatqueue' => 'Para darle una idea al usuario del tiempo de espera, el helpdesk puede mostrar cuántos chats van delante de él.',
    'livesupport_chatrefresh_invalid'      => 'Intervalo de actualización de chat no válido',
    'd_livesupport_chatrefresh_invalid'    => 'El intervalo de actualización de chat debe ser un número entero y mayor o igual a 10',

    'livesupport_clientchatsettings'       => 'Visitante &amp; Configuración del chat',
    'livesupport_chatwidth'                => 'Ancho de la ventana de chat',
    'd_livesupport_chatwidth'              => 'El ancho de la ventana de chat del visitante (en píxeles).',
    'livesupport_chatheight'               => 'Altura de la ventana de chat',
    'd_livesupport_chatheight'             => 'Altura de la ventana de chat del visitante (en píxeles).',
    'livesupport_clientchatrefresh'        => 'Intervalo de actualización de chat',
    'd_livesupport_clientchatrefresh'      => 'La ventana de chat del visitante se actualizará en este intervalo (en segundos). Un valor bajo mejora la capacidad de respuesta del sistema de chat pero aumenta la demanda en el servidor web.',
    'livesupport_clientpagerefresh'        => 'Intervalo de actualización de datos de visitantes',
    'd_livesupport_clientpagerefresh'      => 'Se colocará un código de seguimiento de Live Chat sus páginas web que actualizará el helpdesk con la información de visitantes en este intervalo (en segundos).',
    'livesupport_cachehtmljscode'          => 'Decir al navegador del visitante que guarde el código de seguimiento en la caché',
    'd_livesupport_cachehtmljscode'        => 'El helpdesk dirá al navegador del usuario que almacene en caché el código JavaScript del Live Chat para mejorar los tiempos de carga de página.',

    'livesupport_winappsettings'           => 'Configuración de Kayako Desktop',
    'livesupport_searchbgcolor'            => 'Color de fondo del motor de búsqueda del visitante',
    'd_livesupport_searchbgcolor'          => 'El color de fondo para visitantes referidos al sitio por un motor de búsqueda.',
    'livesupport_searchfrcolor'            => 'Color del texto del motor de búsqueda del visitante',
    'd_livesupport_searchfrcolor'          => 'El color de texto para visitantes referidos al sitio por un motor de búsqueda.',

    'ls_clientarea'                        => 'Configuración del centro de soporte',
    'ls_displaystatus'                     => 'Mostrar botón de estado del soporte en vivo',
    'd_ls_displaystatus'                   => 'El helpdesk mostrará un botón que indica el estado del soporte en vivo (conectado, desconectado, ocupado o vuelvo enseguida).',
    'ls_depname'                           => 'Ocultar nombres del personal en chats',
    'd_ls_depname'                         => 'El helpdesk usará el nombre del departamento en lugar del nombre del usuario del personal.',
    'livesupport_alertttl'                 => 'Alerta de expiración de regla de visitantes',
    'd_livesupport_alertttl'               => 'Se pueden configurar las reglas de visitantes de forma que activen alertas especiales en ventanas emergentes que permanecerán en la pantalla durante este tiempo (en segundos).',
    'livesupport_clicktocallsettings'      => 'Configuración de clic para llamar',
    'ls_activecountrycode'                 => 'Su código local del país (ITU-T)',
    'd_ls_activecountrycode'               => 'Kayako Desktop puede distinguir entre las llamadas locales e internacionales, basándose en su propio código local del país, por ejemplo: <em>1</em> para los Estados Unidos y <em>34</em> para España.',
    'ls_ignoreactivecountrycode'           => 'No añada el código del país para llamadas desde números locales',
    'd_ls_ignoreactivecountrycode'         => 'El helpdesk no añadirá automáticamente el prefijo a números locales con el código de su país especificado arriba.',
    'ls_internationalcallprefix'           => 'Prefijo para llamadas internacionales',
    'd_ls_internationalcallprefix'         => 'Si su proveedor telefónico requiere un prefijo para marcar números internacionales, introdúzcalo aquí y Kayako Desktop lo añadirá automáticamente a llamadas internacionales salientes.',
    'ls_recordphonecalls'                  => 'Grabar llamadas telefónicas',
    'd_ls_recordphonecalls'                => 'Kayako Desktop subirá las grabaciones de las llamadas al helpdesk, que despés se pueden reproducir en el panel de control del personal.',
    'ls_enableinternationalcalls'          => 'Petición de llamadas internacionales permitidas',
    'd_ls_enableinternationalcalls'        => 'El helpdesk permitirá a los visitantes utilizar clic para llamar para números internacionales.',
    'livechat_ignorerange'                 => 'Ignorar visitantes de direcciones IP',
    'd_livechat_ignorerange'               => 'Se ignorará a visitantes de las direcciones IP aquí especificadas (separadas por coma).',

    'livechat_proactivescroll'             => 'Animar invitación proactiva a chat flotante',
    'd_livechat_proactivescroll'           => 'Cuando un visitante es invitado a una chat (ya sea por el personal o por una regla de visitantes), se animará la invitación emergente.',
    'livechat_timestamps'                  => 'Mostrar sello de tiempo en el chat',
    'd_livechat_timestamps'                => 'El helpdesk mostrará junto a cada mensaje intercambiado en un chat el sello de tiempo.',
    'livechat_timestampformat'             => 'Formato de sello de tiempo',
    'd_livechat_timestampformat'           => 'Cuando se revisen los registros de chats en el panel de control del personal, se mostrará el sello de tiempo en este formato.',
    'ls_forcerandomnumber'                 => 'Generar nuevo botón de soporte en vivo al cargar página',
    'd_ls_forcerandomnumber'               => 'Por defecto, los botones de soporte en vivo se almacenan en la caché por un tiempo para reducir la demanda en el servidor. Activando esta opción se solicitará un botón nuevo, actualizado, cada vez que un visitante cargue una página con un botón.',

    // ======= EMAIL PARSER =======
    'pr_createnewticket'                   => 'Crea un nuevo ticket para respuestas enviada a tickets resueltos',
    'd_pr_createnewticket'                 => 'En vez de reabrir el ticket, el helpdesk creará un nuevo ticket si se envía una respuesta a un ticket resuelto. Tenga en cuenta que esta opción anulará la regla de correo electrónico de<em>crear siempre un nuevo ticket</em>.',
    'pr_allowmultiplecreation'             => 'Crear múltiples tickets para todas las colas de correo electrónico',
    'd_pr_allowmultiplecreation'           => 'Si alguien envía un correo electrónico a múltiples direcciones de correo electrónico del helpdesk, éste creará múltiples tickets para cada dirección de correo electrónico de la cola.',
    'pr_generalparser'                     => 'Configuración del analizador de correo electrónico',
    'pr_contentpriority'                   => 'Priorizar tipo de contenido de correo electrónico',
    'd_pr_contentpriority'                 => 'La mayoría de los correos electrónicos contiene dos formatos, <strong>texto llano</strong> y <strong>HTML</strong>. El helpdesk priorizará este tipo de contenido al procesar las reglas de correo electrónico. Se recomienda usar <em>texto llano</em>.',
    'text'                                 => 'Texto llano',
    'html'                                 => 'HTML',
    'pr_stripscript'                       => 'Eliminar &lt;etiquetas&gt; del script',
    'd_pr_stripscript'                     => 'Se pueden usar <strong>&lt;etiquetas&gt; de script</strong> para cargar JavaScript. Se recomienda habilitar esta configuración para evitar que se cargue código malicioso en el navegador del usuario.',
    'pr_logoptions'                        => 'Opciones de registro del analizador de correo electrónico',
    'pr_enablelog'                         => 'Activar el registro de correo electrónico',
    'd_pr_enablelog'                       => 'The helpdesk will log original copies of all emails coming into the helpdesk. Enabling this setting is strongly recommended so that any email related problems can be diagnosied, if they occur.',
    'pr_logchurndays'                      => 'Mantener registros de correo electrónico durante',
    'd_pr_logchurndays'                    => 'La cantidad de tiempo en días que se guardarán los registros de correos electrónicos.',
    'pr_maxlogsize'                        => 'Tamaño máximo del registro de correos electrónicos',
    'd_pr_maxlogsize'                      => 'El tamaño máximo (en kilobytes) del registro de correos electrónicos que será guardado. No se conservarán los registros de correo electrónico que excedan este tamaño.',
    'pr_pop3'                              => 'Configuración de descarga de correo electrónico POP3/IMAP',
    'pr_procno'                            => 'Número máximo de correos electrónicos que descargar en un lote',
    'd_pr_procno'                          => 'El analizador de correo electrónico descarga los correos electrónicos a los buzones en lotes de este tamaño.',
    'pr_sizelimit'                         => 'Límite de tamaño de correo electrónico',
    'd_pr_sizelimit'                       => 'Los correos electrónicos que excedan este tamaño (en kilobytes) no serán descargados al helpdesk.<br /><br/><strong>Nota para los clientes de Kayako Download:</strong> Esto debe ser menor a la configuración de <em>php_memory_limit</em> en su <em>php.ini</em>.',
    'pr_parsereplyto'                      => 'Priorizar direcciones <strong>responder a</strong> por encima de <strong>de</strong>',
    'd_pr_parsereplyto'                    => 'El helpdesk utilizará las direcciones de correo de <strong>responder a</strong> antes que las de <strong>de</strong> en el encabezado del correo electrónico. <strong>Advertencia</strong> - es más fácil falsificar una dirección <em>responder a</em>, recomendamos que no active esta configuración.',
    'pr_conversion'                        => 'Convertir automáticamente la codificación de los correos electrónicos',
    'd_pr_conversion'                      => 'El helpdesk convertirá automáticamente la codificación del correo entrante al juego de caracteres por defecto del helpdesk.',
    'pr_loopoptions'                       => 'Configuración del bloqueador de bucles de correos',
    'pr_loopcut_prevents_autoresponder'    => 'Detener el envío de respuestas automáticas si se detectan bucles',
    'd_pr_loopcut_prevents_autoresponder'  => 'El helpdesk detendrá el envío de respuestas automáticas a una dirección particular si piensa que está en un bucle de correos electrónicos. Este ajuste debería dejarse activado, excepto cuando se diagnostica un problema.',
    'pr_loopcut_ignores_cut_mail'          => 'Ignorar completamente el correo electrónico',
    'd_pr_loopcut_ignores_cut_mail'        => 'Si el helpdesk cree que un correo particular es parte de un bucle de correos electrónicos, lo ignorará completamente.',
    'titlephpinierror'                     => 'ERROR: Email size limit too large',
    'msgphpinierror'                       => 'Your email size limit exceeds the memory limit set in your php.ini file. Please set your email size limit to less than %s in the email parser settings.',

    // ======= TICKETS =======
    't_cleanmailsubjects'                  => 'Limpiar asunto del correo electrónico',
    'd_t_cleanmailsubjects'                => 'Si se activa, al meta del ticket se le añadirá un sufijo (usando el signo +) en la dirección de correo <strong>de</strong> (sales+r.abc.123@acme.com) para correos enviado por el helpdesk, en vez de incluirlo en el asunto del correo.',
    't_spamhandling'                       => 'Gestión de spam',
    't_spammovetotrash'                    => 'Mover spam automáticamente a la papelera',
    'd_t_spammovetotrash'                  => 'Los tickets marcados como spam se moverán automáticamente a la papelera.',
    't_spamban'                            => 'Bloquear direcciones de correo electrónico de spam',
    'd_t_spamban'                          => 'Las direcciones de correo electrónico de tickets marcados como spam serán bloqueadas automáticamente.',
    't_restrictnewticket'                  => 'El personal sólo puede crear nuevos tickets en sus departamentos asignados',
    'd_t_restrictnewticket'                => 'El personal solo puede crear nuevos tickets en sus departamentos que le hayan sido asignados a ellos o a sus equipos.',
    't_autorecip'                          => 'Añadir automáticamente direcciones de correo electrónico en CC como destinatarios del ticket',
    'd_t_autorecip'                        => 'Si el helpdesk recibe un correo electrónico y éste contiene una dirección en el apartado CC, esta dirección se añadirá automáticamente a los destinatarios del ticket.',
    't_autorespondercc'                    => 'Enviar respuesta automática a destinatarios CC',
    'd_t_autorespondercc'                  => 'El helpdesk enviará respuestas automáticas acusando recibo de su correo electrónico a los destinatarios en CC.',
    't_parser'                             => 'Configuración del analizador de correo electrónico',
    't_pstaffreply'                        => 'El personal puede responder a tickets por correo electrónico',
    'd_t_pstaffreply'                      => 'El personal podrá responder a tickets respondiendo a correos electrónicos de notificación del helpdesk. Su respuesta será procesada por el helpdesk, agregada al ticket y se enviará una notificación a los destinatarios del ticket.',
    't_sla'                                => 'Configuración de SLA',
    't_encustomoverdue'                    => 'Utilizar fechas de vencimiento de respuesta y resolución predeterminados',
    'd_t_encustomoverdue'                  => 'Los tiempos de abajo se utilizarán para calcular las fechas de vencimiento de respuesta y resolución de tickets si no se ha asignado un plan de SLA al usuario, grupo de usuarios o departamento.',
    't_overduehrs'                         => 'Fecha límite de respuesta por defecto',
    'd_t_overduehrs'                       => 'Si un usuario no recibe respuesta en este periodo se marcará el ticket como vencido.',
    't_resolutionduehrs'                   => 'Fecha límite de resolución por defecto',
    'd_t_resolutionduehrs'                 => 'Si un ticket no es resuelto en este periodo se marcará el ticket como vencido.',
    'tickets_resattachments'               => 'Utilice ista blanca de tipos de archivos adjuntos',
    'd_tickets_resattachments'             => 'Si se activa, solo se admitirán los tipos de archivos aquí mencionados (<em>Tickets &rarr; Tipo de archivos</em>) en el helpdesk.',
    'tickets_parseemlattachment'           => 'Parse .eml and .msg attachment',
    'd_tickets_parseemlattachment'         => 'If enabled .eml and .msg attachments will be parsed as attachments, else they will get parse inline with in the Ticket Body',
    't_general'                            => 'Configuración general de tickets',
    't_tpreview'                           => 'Mostrar vista previa de ticket al pasar con el ratón por encima',
    'd_t_tpreview'                         => 'Se mostrará una vista previa del ticket al pasar el ratón por encima del ticket en la lista de tickets principal.',
    't_postlimit'                          => 'Respuestas a tickets por página',
    'd_t_postlimit'                        => 'El número máximo de respuestas a tickets que se mostrará antes de divirlos en varias páginas.',
    't_ochtml'                             => 'Gestión de HTML (para respuestas del personal)',
    'd_t_ochtml'                           => 'Especifique cómo el helpdesk debe gestionar HTML en respuestas de correo electrónico enviadas por usuarios del personal. Esto afectará al contenido que recibe el usuario.<br /><br /><strong>Convertir a entidades HTML</strong> Convierte HTML a texto normal de forma que puede ver el código.<br /><strong>Eliminar etiquetas HTML</strong> elimina el HTML por completo (menos las etiquetas especificadas abajo en <em>Etiquetas HTML permitidas</em>), dejando solo el texto.<br /><strong>Permitir HTML</strong> Permite mostrar código HTML. <strong>No</strong> se recomienda esta configuración, ya que podría permitir que se ejecutara código malicioso en el navegador y/o aplicaciones de cliente de correo electrónico de los usuarios del personal.',
    't_chtml'                              => 'Gestión de HTML (en la web y notificaciones de correo electrónico)',
    'd_t_chtml'                            => 'Especifique cómo el helpdesk debe gestionar HTML al mostrar entradas de ticket en la web y notificaciones de correo electrónico.<br /><br /><strong>Convertir a entidades HTML</strong> Convierte HTML a texto normal de forma que puede ver el código.<br /><strong>Eliminar etiquetas HTML</strong> elimina el HTML por completo (menos las etiquetas especificadas abajo en <em>Etiquetas HTML permitidas</em>), dejando solo el texto.<br /><strong>Permitir HTML</strong> Permite mostrar código HTML. <strong>No</strong> se recomienda esta configuración, ya que podría permitir que se ejecutara código malicioso en el navegador y/o aplicaciones de cliente de correo electrónico de los usuarios del personal.',

    't_allowhtml'                          => 'Permitir algunas etiquetas HTML',
    'd_t_allowhtml'                        => 'El helpdesk permitirá algunas etiquetas de HTML (especificadas abajo), aunque esté activado <strong>Eliminar etiquetas de HTML</strong>.',
    't_allowableadvtags'                   => 'Etiquetas HTML permitidas',
    'd_t_allowableadvtags'                 => 'El helpdesk permitirá estas etiquetas de HTML si se activa <strong>Permitir algunas etiquetas de HTML</strong>.',
    't_allowableadvtagsattributes'         => 'Atributos HTML permitidos',
    'd_t_allowableadvtagsattributes'       => 'El helpdesk permitirá estos atributos HTML si se activa <strong>Permitir algunas etiquetas de HTML</strong>.',

    't_postorder'                          => 'Orden de visualización de las respuestas a tickets',
    'd_t_postorder'                        => 'Especifique cómo se muestran las entrada de tickets al personal que revisa sus tickets en el panel de control del personal.',
    'tcentities'                           => 'Convertir a entidades HTML',
    'tchtml'                               => 'Permitir HTML',
    'tchtmlpurifier'                       => 'Purificador HTML',
    'tcstrip'                              => 'Eliminar etiquetas HTML',
    't_enpagin'                            => 'Separar respuestas a tickets en distintas páginas',
    'd_t_enpagin'                          => 'En vez de mostrar todas las respuestas a tickets en la misma página, active esta configuración para separarlas en diversas páginas.',
    't_tinymceeditor'                      => 'Habilitar el editor de TinyMCE',
    'd_t_tinymceeditor'                    => 'Use el editor TinyMCE (texto enriquecido) para crear nuevos tickets o respuestas de tickets.',
    't_editor_format'                      => 'Tratar el contenido como',
    'd_t_editor_format'                    => 'Seleccione cómo el editor de texto tratará los contenidos de los nuevos tickets y las respuestas de tickets.',
    'newestfirst'                          => 'Nueva respuesta primero',
    'oldestfirst'                          => 'Respuesta más antigua primero',
    't_overduecolor'                       => 'Color de fondo de tickets vencidos',
    'd_t_overduecolor'                     => 'Se pueden destacar los tickets vencidos con un color de fondo. Elija un color claro para que el texto sea legible.',
    't_ticketnoteresetsupdatetime'         => 'Eliminar fecha de vencimiento cuando se añada una nota de tickets',
    'd_t_ticketnoteresetsupdatetime'       => 'Cuando se actualiza un ticket (es decir, un usuario del personal lo responde) el contador de la fecha de vencimiento se vuelve a iniciar. Si activa este ajuste, una nota de ticket contará como una actualización del ticket.',
    't_resultlimit'                        => 'Límite de resultados de búsqueda',
    'd_t_resultlimit'                      => 'El número máximo de resultados de la búsqueda de tickets. Si se ajusta demasiado alto puede llevar a que las búsquedas tarden mucho tiempo.',
    't_mailset'                            => 'Configuración de correo electrónico',
    't_clientarea'                         => 'Configuración del centro de soporte',
    't_eticketid'                          => 'Tipo de Id del ticket',
    'd_t_eticketid'                        => '',
    'tsequential'                          => 'Secuencial (#1, #2, #3... #5263458)',
    'trandom'                              => 'Aleatorio (#JRQ-368-3621, #BHJ-591-1832)',
    't_slaresets'                          => 'Eliminar fecha de vencimiento de respuestas del personal',
    'd_t_slaresets'                        => 'Cuando un usuario del personal responde a un ticket, se eliminará su plazo de respuesta. Se caculará un nuevo plazo de respuesta cuando el usuario vuelva a responder al ticket.',
    't_cstaffname'                         => 'Reemplazar el nombre del personal en el <em>de</em> en correos electrónicos',
    'd_t_cstaffname'                       => 'De forma predeterminada, se utilizará para los nombres del personal el nombre <em>de</em> de las respuestas a tickets desde el helpdesk. Active esta configuración para utilizar el mismo nombre "de" (especificado a continuación) para todos los correos electrónicos.',
    't_cdisplayname'                       => 'Sobrescribir el nombre<strong>de</strong> con',
    'd_t_cdisplayname'                     => 'Este nombre se utilizará para las respuestas a ticket salientes de usuarios del personal (en lugar de su propio nombre) si se activa la configuración anterior.',
    't_cthirdparty'                        => 'Mostrar respuestas a tickets de terceros',
    'd_t_cthirdparty'                      => 'Las respuestas a tickets de terceros receptores serán visibles para usuarios que revisen su historial de tickets en el centro de soporte.',
    't_cenattach'                          => 'Los usuarios pueden adjuntar archivos a tickets',
    'd_t_cenattach'                        => 'Los usuarios podrán adjuntar archivos cuando creen o respondan a los tickets en el centro de soporte.',
    't_cpostorder'                         => 'Orden de visualización de las respuestas a tickets',
    'd_t_cpostorder'                       => 'Especifique cómo se muestran las entradas de tickets a los usuarios que revisan sus tickets en el centro de soporte.',
    't_ccaptcha'                           => 'Requerir que los usuarios completen un CAPTCHA al enviar tickets',
    'd_t_ccaptcha'                         => 'Para verificar que el envío de un ticket lo realiza un humano y no un spambot, se pedirá a los usuarios que introduzcan algunas letras de la imagen.',
    't_arnews'                             => 'Incluir últimas novedades en la respuesta automática del ticket',
    'd_t_arnews'                           => 'Se incluirán en la respuesta automática enviada a usuarios acusando recibo de sus tickets los artículos recientemente publicados en el helpdesk.',
    't_ticketlock'                         => 'Configuración de bloqueo de tickets',
    't_plockthreshold'                     => 'Expiración de vista preliminar de respuestas a tickets',
    'd_t_plockthreshold'                   => 'El personal puede ver cómo otro usuario del personal escribe una respuesta a un ticket. Si no se actualiza la respuesta en este tiempo (en segundos), ya no se compartirá.',
    't_locktimeout'                        => 'Expiración del bloqueo del ticket',
    'd_t_locktimeout'                      => 'Si un usuario del personal tiene un ticket abierto, aparecerá un icono con un candado junto al ticket. Este icono se borrará transcurrido este tiempo (en segundos), es decir, si el usuario que abrió el billete está inactivo.',
    't_canirs'                             => 'Activar sistema de respuesta inmediata (IRS)',
    'd_t_canirs'                           => 'Kayako sugerirá proactivamente artículos pertinentes de la base de conocimientos mientras el usuario redacta su ticket en el centro de soporte.',
    't_maxwcnt'                            => 'Detener búsqueda de IRS después de esta cantidad de palabras',
    'd_t_maxwcnt'                          => 'Cuando un usuario haya introducido esta cantidad de palabras, Kayako dejará de buscar en la base de conocimientos respuestas sugeridas.',

    't_cstatusupd'                         => 'Cambiar ticket a este estado al recibir una respuesta de usuario',
    'd_t_cstatusupd'                       => 'Los tickets cambiarán a este estado cuando se reciba una respuesta de un usuario (normalmente un estado <strong>abierto</strong> frente a uno <strong>resuelto</strong>).',
    't_enhistory'                          => 'Incluir resumen de la respuesta a tickets en las respuestas del personal',
    'd_t_enhistory'                        => 'Se incluirá el historial completo del ticket en las respuestas del personal (y los tickets reenviados) a usuarios.',

    't_reciplimit'                         => 'Número máximo de destinatarios en correos electrónicos entrantes',
    'd_t_reciplimit'                       => 'El número máximo de destinatarios que el helpdesk aceptará cuando procesa correos electrónicos.',
    't_mergrecip'                          => 'Añadir usuarios como destinatarios al fusionar tickets',
    'd_t_mergrecip'                        => 'Si dos tickets creados por dos usuarios diferentes son fusionados, sus direcciones de correo electrónico se añadirán como destinatarios en el nuevo ticket fusionado.',
    'tickets_bayesian'                     => 'Configuración del filtro bayesiano',
    'tb_minwordlength'                     => 'Tamaño mínimo de palabra',
    'd_tb_minwordlength'                   => 'El filtro bayesiano solo considerará palabras que excedan esta longitud.',
    'tb_maxwordlength'                     => 'Tamaño máximo de palabra',
    'd_tb_maxwordlength'                   => 'El filtro bayesiano solo considerará palabras que no excedan esta longitud.',
    'tb_indexnumbers'                      => 'incluir números',
    'd_tb_indexnumbers'                    => 'El filtro bayesiano incluirá números al indexar.',
    'tb_minnumberlength'                   => 'Tamaño mínimo de número',
    'd_tb_minnumberlength'                 => 'El filtro bayesiano solo considerará números que excedan esta longitud.',
    'tb_signores'                          => 'Ignorar palabras con símbolos',
    'd_tb_signores'                        => 'El filtro bayesiano no considerará palabras que incluyan símbolos.',
    'tb_enablespam'                        => 'Activar filtro de spam',
    'd_tb_enablespam'                      => 'Si se activa, el filtro bayesiano puede ser entrenado (marcando tickets como <strong>spam</strong>) para detectar spam automáticamente.',
    't_ticketview'   => 'Maximum tickets per page in staff ticket views.',
    'd_t_ticketview' => 'Specify the maximum number of tickets that staff can display on a single page in their ticket views.',
    'tickets_attachments'                  => '',

    // ======= TROUBLESHOOTER =======
    'tr_displayviews'                      => 'Mostrar número de visitas',
    'd_tr_displayviews'                    => 'El número de visitas de cada categoría del solucionador de problemas se mostrará.',

    // ======= USER REGISTRATION =======
    'user_enableemailverification'         => 'Correo electrónico de verificación de nuevo registro',
    'd_user_enableemailverification'       => 'Verifique los nuevos registros de usuarios (en el centro de soporte) enviando un correo electrónico con un enlace de activación para verificar su registro y que la dirección de correo es correcta.',
    'user_enablecaptcha'                   => 'CAPTCHA para nuevo registro de usuario',
    'd_user_enablecaptcha'                 => 'Para verificar que se ha registrado una personal y no un spambot, se pedirá a los usuarios que introduzcan las letras que ven en una imagen.',
    'user_autodelete'                      => 'Limpieza automática de cuentas',
    'user_adelunveri'                      => 'Limpiar cuentas de usuario no verificadas',
    'd_user_adelunveri'                    => 'El helpdesk borrará automáticamente cuentas no verificadas (registradas pero que no han utilizado el enlace de activación enviado a la dirección de correos del usuario).',
    'user_delcleardays'                    => 'Limpiar cuentas no verificadas',
    'd_user_delcleardays'                  => 'Si un usuario no ha verificado su cuenta en este número de días, se eliminará su cuenta (si la limpieza de cuentas no verificadas está activada).',
    'user_organizations'                   => 'Organizaciones de usuarios',
    'user_orgrestrictautoadd'              => 'Permitir a los usuarios agregarse a las organizaciones <em>compartidas</em>',
    'd_user_orgrestrictautoadd'            => 'Una organización <strong>compartida</strong> permite a todos sus usuarios ver los tickets de los demás. Si se activa esta configuración, los usuarios podrán agregarse a sí mismos a organizaciones compartidas, actualizando su propio perfil. <strong>Esto debería activarse solo en entornos de confianza.</strong>',
    'user_orgselection'                    => 'Permitir a usuarios especificar su propia organización',
    'd_user_orgselection'                  => 'Por defecto, los usuarios pueden introducir el <strong>nombre de una organización</strong> en su perfil. Esta configuración determina cómo actúa el helpdesk.<br /><br /><strong>No permitir</strong> Los usuarios no podrán agregarse a sí mismos a organizaciones.<br /><strong>Crear siempre organización nueva</strong> Se creará una organización nueva cada vez que un usuario introduzca el nombre de una organización (y este usuario será su único miembro).<br /><strong>Unirse a una existente o crear nueva</strong> Si el nombre de la organización ya existe, el usuario será agregado a ella, de lo contrario se creará una nueva organización.',
    'uodontallow'                          => 'No permitir',
    'uocreatenew'                          => 'Crear siempre organización nueva',
    'uocreatemerge'                        => 'Unirse a una existente o crear nueva',
    'user_orgprofileupdate'                => '¿Quién puede actualizar el perfil de la organización?',
    'd_user_orgprofileupdate'              => 'Los usuarios miembros de una organización pueden actualizar el perfil de la organización. Seleccione qué tipo de usuarios puede hacerlo.',
    'uoallusers'                           => 'Todos los usuarios',
    'uomanagersonly'                       => 'Usuarios designados como managers',
    'user_orgdefaultclassification'        => 'Designación de usuario por defecto',
    'd_user_orgdefaultclassification'      => 'Seleccione la designación por defecto para nuevos registros de usuario.<br /><br /><strong>Usuario regular</strong> Un usuario regular sin designación especial.<br /><strong>Manager</strong> Un usuario designado como manager podrá acceder a todos los tickets creados por usuarios de su misma organización.',
    'uouser'                               => 'Usuario regular',
    'uomanager'                            => 'Manager',
    'user_dispatchregemail'                => 'Enviar correo electrónico de confirmación de registro',
    'd_user_dispatchregemail'              => 'Los nuevos usuarios recibirán un correo electrónico de confirmación de su registro.',
    'user_delcleardays_invalid'            => 'Número no válido de días de limpieza para cuentas no verificadas',
    'd_user_delcleardays_invalid'          => 'El número de días debe ser un número entero positivo',
    'security_loginattempts_invalid'       => 'Número no válido de intentos de inicio de sesión bloqueo',
    'd_security_loginattempts_invalid'     => 'El número de intentos debe ser un entero positivo',

    // ======= NEWS =======
    'nw_general'                           => 'Configuración de noticias',
    'nw_sendstaffemail'                    => 'Enviar artículos publicados recientemente al personal por correo electrónico',
    'd_nw_sendstaffemail'                  => 'El personal recibirá una notificación por correo electrónico cuando se publique un artículo de noticias.',
    'nw_sync'                              => 'Configuración de la sincronización de RSS',
    'nw_globalsync'                        => 'Feed de artículos de noticia globales',
    'd_nw_globalsync'                      => 'El helpdesk puede monitorear un feed RSS y crear artículos de noticias de ello. Este feed se utilizará para crear artículos <strong>globales</strong> (centro de soporte y panel de control del personal).',
    'nw_publicsync'                        => 'Feed público de artículos de noticias',
    'd_nw_publicsync'                      => 'Este feed se utilizará para crear artículos de noticas <strong>públicos</strong> (solo en el centro de soporte).',
    'nw_privatesync'                       => 'Feed de artículos de noticias privados',
    'd_nw_privatesync'                     => 'Este feed se utilizará para crear artículos <strong>privados</strong> (solo en el panel de control del personal).',
    'nw_newsstaffcp'                       => 'Configuración de noticias del panel de control del personal',
    'nw_newsclient'                        => 'Configuración de noticias del centro de soporte de usuarios',
    'nw_enablestaffdashboard'              => 'Mostrar las últimas noticias en la página de inicio',
    'd_nw_enablestaffdashboard'            => '',
    'nw_maxdashboardnewslist'              => 'Número máximo de artículos de noticias que mostrar',
    'd_nw_maxdashboardnewslist'            => '',
    'nw_enablenewsnav'                     => 'Mostrar las últimas noticias en la página de inicio del centro de soporte',
    'd_nw_enablenewsnav'                   => '',
    'nw_maxnewslist'                       => 'Número máximo de artículos de noticias que mostrar',
    'd_nw_maxnewslist'                     => '',
    'nw_rss'                               => 'Configuración de sindicación RSS',
    'nw_enablerss'                         => 'Activar feed RSS de noticias del helpdesk',
    'd_nw_enablerss'                       => 'Los usuarios podrán suscribirse a un feed RSS de noticias publicadas en el helpdesk.',
    'nw_maxrss'                            => 'Número máximo de los artículos que publicar en el feed RSS',
    'd_nw_maxrss'                          => 'El feed RSS contendrá hasta este número de artículos de noticias recientes.',
    'nw_svalidate'                         => 'Validar la dirección de correo electrónico del suscriptor de noticias',
    'd_nw_svalidate'                       => 'El helpdesk verificará las direcciones de correo electrónico de los suscriptores, eviándoles un enlace de activación a su dirección.',
    'nw_pageno'                            => 'Número de artículos que mostrar por página',
    'd_nw_pageno'                          => 'Cuando se supere este número, los artículos de noticias se repartirán en varias páginas.',
    'nw_staffpageno'                       => 'Número de artículos que mostrar por página',
    'd_nw_staffpageno'                     => 'Cuando se supere este número, los artículos de noticias se repartirán en varias páginas.',

    // ======= KNOWLEDGEBASE =======
    'kb_clientarea'                        => 'Configuración general de base de conocimientos',
    'kb_clientareaindex'                   => 'Configuración del centro de soporte',
    'kb_categoryindex'                     => 'Configuración de categoría',
    'kb_enpopulararticles'                 => 'Lista de artículos más populares',
    'd_kb_enpopulararticles'               => 'Se mostrará una lista de los artículos más populares de la base de conocimientos (por visitas).',
    'kb_maxpopulararticles'                => 'Número de artículos populares que mostrar',
    'kb_enlatestarticles'                  => 'Lista de artículos más actuales',
    'd_kb_enlatestarticles'                => 'Se mostrará una lista de los artículos de la base de conocimientos publicados más recientemente.',
    'kb_maxlatestarticles'                 => 'Número de los artículos más recientes que mostrar',
    'kb_maxcatarticles'                    => 'Número de artículos que mostrar bajo una categoría',
    'd_kb_maxcatarticles'                  => '',
    'kb_alphabetical'                      => 'Ordenar alfabéticamente',
    'kb_chrono'                            => 'Ordenar de forma cronológica',
    'kb_catdisplayorder'                   => 'Anular el orden de visualización de categoría',
    'd_kb_catdisplayorder'                 => 'Por defecto, las categorías se muestran según su número del orden de visualización, de menor a mayor.',
    'kb_catorder'                          => 'Orden de visualización de categoría',
    'd_kb_catorder'                        => '',
    'kb_asc'                               => 'De menor a mayor (a z)',
    'kb_desc'                              => 'De mayor a menor (z a)',
    'kb_arorder'                           => 'Orden de visualización de artículos',
    'd_kb_arorder'                         => '',
    'd_kb_ardisplayorder'                  => 'Por defecto, los artículos se muestran según su número del orden de visualización, de menor a mayor.',
    'kb_ardisplayorder'                    => 'Anular el orden de visualización del artículo',
    'kb_datemodified'                      => 'Fecha de última actualización',
    'kb_views'                             => 'Ordenar por total de visitas',
    'kb_rating'                            => 'Ordenar por calificación del artículo',
    'kb_defaultdisp'                       => 'Utilizar orden de visualización de categoría',
    'kb_enrss'                             => 'Activar feeds RSS',
    'kb_rss'                               => 'Configuración de feed RSS',
    'd_kb_enrss'                           => 'Los usuarios podrán suscribirse a los feeds RSS de entradas de artículos en la base de conocimientos.',
    'kb_climit'                            => 'Límite de caracteres en vista previa de artículo',
    'd_kb_climit'                          => 'El número máximo de caracteres que se muestran en la vista previa del artículo.',
    'kb_rssclimit'                         => 'Límite de artículos del feed RSS',
    'd_kb_rssclimit'                       => 'El número máximo de caracteres que se mostrará en los feeds RSS.',
    'kb_enrating'                          => 'Permitir calificación de artículo',
    'd_kb_enrating'                        => 'El personal y los usuarios podrán calificar artículos (pulgar hacia arriba o hacia abajo).',
    'kb_categorycolumns'                   => 'Número de columnas de categoría',
    'd_kb_categorycolumns'                 => 'El número de columnas de la categoría que se mostrarán. Esta configuración puede anularse por categoría.',
    'kb_parcount'                          => 'Contar artículos en subcategorías',
    'd_kb_parcount'                        => 'El helpdesk mostrará el número de artículos al lado de cada categoría. Active esta configuración para incluir el número de artículos en todas las subcategorías en este recuento.',

    // Potentialy unused phrases in settings.php
    'desc_settings'                        => 'From here you can manage all functional and system-related settings and configurations.',
    'systemsettings'                       => 'System Settings',
    'settingsfor'                          => 'Settings for: %s',
    'updatesettings'                       => 'Update Settings',
    'settingsupdatedfor'                   => 'Updated all settings for group "%s"',
    'settings_livesupport'                 => 'Live Chat',
    'settings_reports'                     => 'Reports',
    'g_whmcstgroup'                        => 'WHMCS Template Group',
    'd_g_whmcstgroup'                      => 'Select a default template group for WHMCS integration. This group will override the default template group. This can be used to display a different template group when Kayako is used via WHMCS and another when accessed normally.',
    'g_supportcenter'                      => 'Support Center Settings',
    'g_returnlogout'                       => 'After Logout Return To Default Template Group',
    'd_g_returnlogout'                     => 'Redirect the user to the default template group after logout.',
    'g_overrideswiftpath'                  => 'Override $swiftpath and $themepath variables automatically',
    'd_g_overrideswiftpath'                => 'If enabled, the system tries to determine the $swiftpath and $themepath variables for templates from the URL. This allows you to create multi-point installations of helpdesk based off a single database.',
    'livesupport_usehttps'                 => 'Always Use Secure Connection (https) For Chat',
    'd_livesupport_usehttps'               => 'If this setting is enabled, all chat sessions will always be conducted over https.',
    'tr_captcha'                           => 'Enable CAPTCHA for Comments',
    'd_tr_captcha'                         => 'If enabled, users will be required to verify a CAPTCHA image before submitting a comment.',
    'nw_captcha'                           => 'Enable CAPTCHA for Comments',
    'd_nw_captcha'                         => 'If enabled, users will be required to verify a CAPTCHA image before submitting a comment.',
    'dl_captcha'                           => 'Enable CAPTCHA for Comments',
    'd_dl_captcha'                         => 'If enabled, users will be required to verify a CAPTCHA image before submitting a comment.',
    'kb_captcha'                           => 'Enable CAPTCHA for Comments',
    'd_kb_captcha'                         => 'If enabled, users will be required to verify a CAPTCHA image before submitting a comment.',
    'general_redirecttype'                 => 'Redirect Type',
    'd_general_redirecttype'               => 'Select <i>HTML Meta Refresh</i> to present a confirmation of an action before redirecting to the next page.',
    'refreshunix'                          => 'Header Refresh',
    'refreshwindows'                       => 'HTML META Refresh',
    'general_defaultlanguage'              => 'Default Language',
    'g_cpmenu'                             => 'Tab Menu Navigation Style',
    'd_g_cpmenu'                           => 'Choose the <i>Hover</i> navigation style to activate a tab by placing the mouse cursor over it.',
    'navleft'                              => 'Left',
    'navright'                             => 'Right',
    'g_commentsapproval'                   => 'Moderate Comments',
    'd_g_commentsapproval'                 => 'Require manual approval of comments entered by users.',
    'menuhover'                            => 'Hover',
    'menuclick'                            => 'Click',
    'g_jscache'                            => 'Javascript Cache for Theme Items',
    'd_g_jscache'                          => 'Cache heavy-output items such as the menu and navigation bar to a file so that pages load faster (rather than loading from the database each time). This disables the real-time view of comments and private message counts in the menu.',
    'cpu_smsgateway'                       => 'SMS Gateway',
    'gateway_enable'                       => 'Enable SMS Gateway',
    'd_gateway_enable'                     => 'The Kayako SMS Gateway can send alerts directly to mobile phones. For more information, see the <a target="_blank" href="http://support.gfi.com" rel="noopener noreferrer">GFI Support</a>.',
    'gateway_username'                     => 'Gateway Username',
    'd_gateway_username'                   => 'Your SMS Gateway username. This is the same as the email address used to log in to the <a target="_blank" href="https://support.gfi.com" rel="noopener noreferrer">GFI Support</a>.',
    'gateway_password'                     => 'Gateway Password',
    'd_gateway_password'                   => 'Your SMS Gateway password. This is the same as the password used to log in to the <a target="_blank" href="https://support.gfi.com" rel="noopener noreferrer">GFI Support</a>.',
    'gat_emailfailure'                     => 'Email Failure Reports',
    'd_gat_emailfailure'                   => 'Send delivery failure reports to the primary administrator email address.',
    'dt_timezone'                          => 'Time Zone',
    'd_dt_timezone'                        => 'Select the Default Time Zone. The Staff users have an option to override this Time Zone in their Preferences.',
    'livesupport_enableuseristyping'       => 'Show "User is Typing..."',
    'd_livesupport_enableuseristyping'     => 'If enabled, both visitors and staff users will be able to see when the other is typing. Disable this option to reduce server load.',
    'livesupport_messagesettings'          => 'Offline Messages Settings',
    'livesupport_enablemessagefw'          => 'Enable Forwarding',
    'd_livesupport_enablemessagefw'        => 'Forward offline messages received by Kayako to the email address entered below.',
    'livesupport_deletemessageafterfw'     => 'Delete After Forward',
    'd_livesupport_deletemessageafterfw'   => 'Automatically delete the forwarded message.',
    'livesupport_fwmessageemail'           => 'Forwarding Email Addresses',
    'd_livesupport_fwmessageemail'         => 'Forward offline messages to these semi-colon separated email addresses.  This will only take effect if the above option, <i>Enable Forwarding</i>, is enabled.<br/><br/>Example: <i>jane.doe@company.com;john.smith@company.com</i>',
    'ls_adbgcolor'                         => 'Ad Tracking Visitor Background Color',
    'd_ls_adbgcolor'                       => 'The background color for a visitor that has been referred to the site by an <b>Ad Campaign</b> (configured within the Staff Control Panel).',
    'ls_adfrcolor'                         => 'Ad Tracking Visitor Foreground Color',
    'd_ls_adfrcolor'                       => 'The foreground color for a visitor that has been referred to the site by an <b>Ad Campaign</b> (configured within the Staff Control Panel).',
    'ls_staffcp'                           => 'Live Support Staff CP Settings',
    'ls_entab'                             => 'Display Live Support Tab In Staff CP',
    'd_ls_entab'                           => 'Show the Live Support tab within the staff control panel.',
    'pr_allowhtml'                         => 'Allow HTML Tags',
    'd_pr_allowhtml'                       => 'Whether or not Parser should allow HTML Tags in the Content.',
    'pr_allowabletags'                     => 'Valid HTML Tags',
    'd_pr_allowabletags'                   => 'Specify the Tags that the Parser will not remove for the incoming email.',
    'desc_pr_conversion'                   => 'If enabled, Kayako will automatically attempt to convert incoming emails to the default encoding of the help desk (<i>e.g. If the help desk is set to UTF-8 and an email is sent in ISO-8859-1, it will be converted to UTF-8 before being added to the system</i>).',
    't_rvalemail'                          => 'Require Valid Email Address',
    'd_t_rvalemail'                        => 'Require users to provide a valid email address when submitting tickets.',
    'tickets_search'                       => 'Search Options',
    't_searchsortdate'                     => 'Sort Results According to Last Activity (Descending)',
    'd_t_searchsortdate'                   => 'Sort search results according to last activity time (descending). Otherwise, the default view sort order is used.',
    't_cntrelevance'                       => 'Advanced Ticket Searching',
    'd_t_cntrelevance'                     => 'Use a more advanced algorithm for searching and determining relevance of results. This setting will increase the search time by up to 40%, but the relevancy of the results will be much higher.',
    'tickets_searchtype'                   => 'Search Index Type',
    'postindex'                            => 'Bulletin Post Index',
    'fulltext'                             => 'MySQL Full Text',
    'tickets_minwordlength'                => 'Minimum Word Length',
    'd_tickets_minwordlength'              => 'Specify the minimum length of a word that will be indexed for search. Any word that does not meet this criteria will be ignored by the indexer and will not be searchable. Shorter words tend to occur more frequently, so allowing their indexing will cause a larger, slower index and thus slower per-word searches.',
    'tickets_maxwordlength'                => 'Maximum Word Length',
    'd_tickets_maxwordlength'              => 'Specify the maximum length of a word that will be indexed for search. Any word that does not meet this criteria will be ignored by the indexer and will not be searchable.',
    'tickets_indexnumbers'                 => 'Index Numbers',
    'd_tickets_indexnumbers'               => 'If enabled, numbers will be indexed and will be searchable.',
    'tickets_minnumberlength'              => 'Minimum Number Length',
    'd_tickets_minnumberlength'            => 'The minimum length of a number, in characters, that will be indexed. Any number shorter than this number of characters will be ignored by the indexer and will not be searchable.',
    'tickets_faulttolerance'               => 'Word Fault Tolerance',
    'd_tickets_faulttolerance'             => 'If a word occurs in a ticket post more than the times specified here, it will be ignored and will not be indexed.',
    't_floodprotection'                    => 'Flood Protection',
    't_fresponder'                         => 'Dont Send Autoresponder Message',
    'd_t_fresponder'                       => 'If Enabled, No Autoresponder Message will be sent when the Flood Protection is triggered.',
    't_fnoadd'                             => 'Dont add the Ticket/Reply',
    'd_t_fnoadd'                           => 'If Enabled, The Incoming Email will be simply ignored if Flood Protection is triggered. It is recommended that you do not enable this option as simply disabling the Autoresponder message should stop any potential mail loop.',
    't_fthreshold'                         => 'Timing Threshold (In Seconds)',
    'd_t_fthreshold'                       => 'Threshold for checking for Potential Flood Protection cases.<BR /><BR /><span class="tabletitle"><i>How Flood Protection Works?</i></span><BR />Whenever an incoming email is received, Kayako checks the Tickets table to see if the user created a ticket with the same subject in the given threshold time, If this check succeeds, Flood Protection gets triggered and the specified actions are carried out.',
    't_enfp'                               => 'Enable/Disable Flood Protection',
    'd_t_enfp'                             => 'Toggle the Status for Flood Protection. It is recommended that you never disable this option as it prevents mail loops that can happen if your client has an autoresponder message set.',
    't_rss'                                => 'RSS View Syndication',
    't_enrss'                              => 'Enable RSS Syndication for Ticket Views',
    'd_t_enrss'                            => 'Allow ticket views (from within the staff control panel) to be syndicated as RSS feeds.',
    't_tidinsub'                           => 'Set Ticket ID in Subject for Outgoing Email',
    'd_t_tidinsub'                         => 'Insert a ticket ID into the subject of emails sent when staff create new tickets. Although it is highly recommended that this option be enabled, Kayako can still check which ticket a message belongs to by searching for the ticket ID within the email body, by comparing the subject or by checking the Message-ID email header.',
    't_stmsgid'                            => 'Check the Message-ID for Staff Replies',
    'd_t_stmsgid'                          => 'Kayako can check the Message-ID header to confirm the identity of a staff user replying to a ticket alert. This adds an extra layer of security and makes sure the replier is a valid staff user. However, it requires that the end mailing client sends the In-Reply-To header, which is not supported by all email clients (in particular, wireless email clients).',
    't_csccrecipients'                     => 'Enable Support Center Users to Specify Custom Recipients',
    'd_t_csccrecipients'                   => 'Allow support center users to specify custom recipients (CC) while creating tickets.',
    't_entab'                              => 'Display Tickets Tab',
    'd_t_entab'                            => 'Display the Tickets tab within the staff control panel.',
    't_cperpage'                           => 'Tickets to Display Per Page',
    'd_t_cperpage'                         => 'The number of tickets that will be listed to users when viewing their ticket list.',
    't_maxattach'                          => 'Maximum Number of Attachments When Replying',
    'd_t_maxattach'                        => 'The maximum number of files that can be attached to a ticket reply. If particularly large files are allowed, it is recommended that the <i>upload_max_filesize</i> setting in your php.ini (PHP configuration file) be edited to reflect the size.',
    't_cmaxattach'                         => 'Maximum Number of Attachments',
    'd_t_cmaxattach'                       => 'The number of attachments a user can add to a new ticket or ticket reply.',
    't_pdainterf'                          => 'PDA Staff Control Panel Interface',
    't_pdenpagin'                          => 'Split Ticket Posts by Page',
    'd_t_pdenpagin'                        => 'Display ticket posts for a ticket will be displayed on separate pages instead of a single page. You may choose how many ticket posts to display per page below.',
    't_pdpostlimit'                        => 'Number of Tickets Posts Per Page',
    'd_t_pdpostlimit'                      => 'If you have enabled the <i>"Split Ticket Posts By Page"</i> option, this specifies how many ticket posts to display on a single page. This applies only to the PDA staff control panel interface.',
    't_pdpostorder'                        => 'Display Order For Ticket Posts',
    'd_t_pdpostorder'                      => 'Whether to display the oldest or newest ticket posts first.',
    't_signores'                           => 'Ignore Words Containing Symbols',
    'd_t_signores'                         => 'If enabled, words containing any of the following symbols will be ignored:<br /><br /><i>- ~ ` @ # $ ^ & * ( ) _ = + [ ] { } | / < > , . ; \' " \\</i>',
    't_autoclose'                          => 'Ticket Automatic Close Settings',
    't_enautoclose'                        => 'Enable Auto Closure System',
    'd_t_enautoclose'                      => 'Automatically change the status of tickets that have lingered in the system for the specified amount of time.',
    't_acstatus'                           => 'Affected Ticket Statuses',
    'd_t_acstatus'                         => 'Select the ticket statuses the automatic close system will affect.  Select multiple statuses by holding the CTRL key and selecting multiple entries.',
    't_acdep'                              => 'Affected Departments',
    'd_t_acdep'                            => 'Select the departments that the automatic close system will affect. Select multiple departments by holding the CTRL key and selecting multiple entries.',
    't_acstatusch'                         => 'Target Status',
    'd_t_acstatusch'                       => 'Select the status to which tickets will be changed automatically once they have lingered for the specified time.',
    't_acinactive'                         => 'Automatic Closure Inactivity Threshold',
    'd_t_acinactive'                       => 'After a ticket has remained inactive for this amount of time (in hours), the system will send a notice to the user created the ticket, warning the user of the pending automatic status change.',
    't_acnoticeclose'                      => 'Final Automatic Close Threshold',
    'd_t_acnoticeclose'                    => 'After this amount of time (in hours) has elapsed (this starts after the \\"Automatic Closure Inactivity Threshold\\" has been reached), the target tickets status will automatically be changed.',
    't_entlock'                            => 'Enable/Disable Ticket Locking',
    't_entplock'                           => 'Enable Reply Ticket Locking',
    'd_t_entplock'                         => 'Allow staff users to see other staff user\'s replies in real-time (as they draft their reply) when viewing the same ticket.',
    'd_t_entlock'                          => 'The ticket locking feature in Kayako will lock a ticket when a staff user opens the ticket. Other staff users will still be able to access the ticket, but a lock icon will be displayed letting other staff users know that the ticket is being viewed.',
    't_reciplist'                          => 'List Recipients Before Replying',
    'd_t_reciplist'                        => 'Display the list of added recipients in a ticket. This adds an overhead of additional database queries in the ticket listing page.',
    't_staffcp'                            => 'Staff Control Panel Settings',
    't_scanirs'                            => 'Enable Instant Response System (IRS)',
    'd_t_scanirs'                          => 'Like the IRS in the client support interface, Kayako will suggest knowledgebase articles as staff users draft their replies.',
    't_advanced'                           => 'Advanced Ticket Settings',
    't_postlist'                           => 'Assign Post List Variable to Staff Replies',
    'd_t_postlist'                         => 'Include the entire history of the ticket to date in replies sent by staff members.  This does add overhead and could potentially slow down replies.',

    // ======= TROUBLESHOOTER =======
    'tr_staffcp'                           => 'Troubleshooter Staff Control Panel Settings',
    'tr_general'                           => 'Client Support Interface Troubleshooter Settings',
    'tr_staffwysiwyg'                      => 'Enable WYSIWYG Editor',
    'd_tr_staffwysiwyg'                    => 'Use the advanced WYSIWYG editor (rich text) for creating troubleshooter articles.',
    'tr_enableclient'                      => 'Display Troubleshooter Widget',
    'd_tr_enableclient'                    => 'Show the troubleshooter icon and link on the index.php page of the client support interface.',
    'tr_enablepopularcat'                  => 'Enable Popular Troubleshooters Box',
    'd_tr_enablepopularcat'                => 'Show a list of the most popular troubleshooters on the index.php page of the client support interface.',
    'tr_maxpopularcat'                     => 'Maximum Number Of Troubleshooters To Display',
    'd_tr_maxpopularcat'                   => 'The maximum number of troubleshooters to display in the popular troubleshooters box.',
    'tr_displaynavbar'                     => 'Display Troubleshooters in Navigation Bar',
    'd_tr_displaynavbar'                   => 'Display troubleshooters at every step in the navigation bar.',
    'tr_entab'                             => 'Display Troubleshooter Tab',
    'd_tr_entab'                           => 'Show the Troubleshooter tab within the Staff Control Panel.',
    'tsnochange'                           => '-- Do Not Change --',
    't_canrecip'                           => 'Users Can Specify Custom Recipients',
    'd_t_canrecip'                         => 'Allow users to specify custom CC Recipients to tickets that they create.',
    'u_sendpw'                             => 'Send Password in Auto Responder (Ticket Receipt)',
    'd_u_sendpw'                           => 'Send the user\'s password to them whenever they create a new ticket.',
    'nw_wysiwyg'                           => 'Enable WYSIWYG Editor',
    'd_nw_wysiwyg'                         => 'Use the advanced WYSIWYG editor (rich text) for creating news articles.',
    'nw_enableclient'                      => 'Display News Widget',
    'd_nw_enableclient'                    => 'Display the news icon and link on the index.php page of the client support interface.',
    'nw_navdisplaydate'                    => 'Display Date Beside News Items',
    'd_nw_navdisplaydate'                  => 'Display the date a news posting was made alongside the title of the posting.',
    'nw_navdateformat'                     => 'Navigation News Date Format',
    'd_nw_navdateformat'                   => 'The format in which the posting date of news items is displayed. For more information, see the documentation for the PHP <a href=\\"http://www.php.net/date\\" target=\\"_blank\\">date()</a> function.',
    'nw_entab'                             => 'Display News Tab',
    'd_nw_entab'                           => 'Display the News tab within the Staff Control Panel.',
    'kb_enableclient'                      => 'Display Knowledgebase Widget',
    'd_kb_enableclient'                    => 'Show the knowledgebase icon and link on the index.php page of the client support interface.',
    'kb_dispviews'                         => 'Display View Count Next To Popular Articles',
    'kb_displayarticledate'                => 'Display Creation Date Next To Latest Articles',
    'kb_dateformat'                        => 'Creation Date Format',
    'd_kb_dateformat'                      => 'Specify the format used to display creation dates in articles. For more information, see the documentation for the PHP <a href=\\"http://www.php.net/date\\" target=\\"_blank\\">date()</a> function.',
    'kb_displaymore'                       => 'Display \\"More Topics\\" Link Under Category List',
    'kb_catarticledetails'                 => 'Display Article Details Under Category List',
    'kb_totalarticles'                     => 'Total Articles',
    'kb_staffcp'                           => 'Knowledgebase Staff Control Panel Settings',
    'kb_staffwysiwyg'                      => 'Enable WYSIWYG Editor',
    'd_kb_staffwysiwyg'                    => 'Use the advanced WYSIWYG editor (rich text) for creating new articles.',
    'kb_entab'                             => 'Display Knowledgebase Tab',
    'd_kb_entab'                           => 'Enable the Knowledgebase tab within the Staff Control Panel.',
    'settings_purchase'                    => 'Ticket Purchaser',
    'purchase_admin_email'                 => 'Billing Email',
    'purchase_money_format'                => 'Currency Symbol Position',
    'purchase_number_format_style'         => 'Number Format',
    'purchase_money_sign'                  => 'Currency Symbol',
    'purchase_bluepay_account'             => 'Bluepay Account Number',
    'purchase_bluepay_key'                 => 'Bluepay Secret Key',
    'purchase_bluepay_mode'                => 'Bluepay Transaction Mode',
    'purchase_bluepay_mode_test'           => 'Test',
    'purchase_bluepay_mode_live'           => 'Live',
    'purchase_invoice_address'             => 'Billing address to display on invoices',
    'ons_xmpphost_2'                       => 'XMPP Host',
    'ons_xmppport_2'                       => 'XMPP Port',
    'd_ons_xmppport_2'                     => '',
    'ons_stunhost_2'                       => 'STUN Host',
    'd_ons_stunhost_2'                     => '',
    'ons_stunport_2'                       => 'STUN Port',
    'd_ons_stunport_2'                     => '',
    'ons_turnhost_2'                       => 'TURN Host',
    'd_ons_turnhost_2'                     => '',
    'ons_turnportudp_2'                    => 'TURN Port (UDP)',
    'd_ons_turnportudp_2'                  => '',
    'ons_turnporttcp_2'                    => 'TURN Port (TCP)',
    'd_ons_turnporttcp_2'                  => '',
    'rep_general'                          => 'Reports Settings',
    'rep_maxrows'                          => 'Max Rows',
    'd_rep_maxrows'                        => 'The maximum number of rows to display in a page for tabular/summary reports',
    'pr_enablelog_notification'            => 'Enable failure notifications',
    'd_pr_enablelog_notification'          => 'The helpdesk will send all the failure logs to admin email address. if they occur. This does add overhead and could potentially slow down parsing.',
);



return $__LANG;
