<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Knowledgebase\Rss;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;

/**
 * Class Controller_FeedTest
 */
#[\PHPUnit\Framework\Attributes\Group('knowledgebase')]
class Controller_FeedTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsInstance()
    {
        $obj = new Controller_FeedMock();
        $this->assertInstanceOf(\Knowledgebase\Rss\Controller_Feed::class, $obj);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testIndexReturnsTrue(): never
    {
        $obj = new Controller_FeedMock();

        $settings = $this->createMock('SWIFT_Settings');

        $settings->method('Get')->willReturnOnConsecutiveCalls(0, 1);

        $mgr = $this->getMockBuilder(\Knowledgebase\Library\Rss\SWIFT_KnowledgebaseRSSManager::class)
            ->disableOriginalConstructor()
            ->disableProxyingToOriginalMethods()
            ->onlyMethods(['Dispatch'])
            ->getMock();

        $obj->KnowledgebaseRSSManager = $mgr;

        $this->mockProperty($obj, 'Settings', $settings);

        $this->assertFalse($obj->Index(),
            'Returns false with kb_enrss = 0');

        $this->assertTrue($obj->Index(),
            'Returns true with kb_enrss = 1');

        $obj->SetIsClassLoaded(false);
        $this->expectExceptionMessage(SWIFT_CLASSNOTLOADED);
        $this->expectException('SWIFT_Exception');
        $obj->Index();
    }
}

class Controller_FeedMock extends Controller_Feed
{
    public function __construct()
    {
        $this->Load = new LoaderMock();
        parent::__construct();
    }

    protected function Initialize()
    {
        return true;
    }
}
