<?php

namespace LiveChat\Library\Canned;

use Base\Models\Staff\SWIFT_Staff;
use LiveChat\Models\Canned\SWIFT_CannedCategory;
use PHPUnit\Framework\TestCase;

class SWIFT_CannedManagerTest extends TestCase
{
	public static function providerDispatchXML()
	{
		$withCategories = <<<XML
<canned>
<category id="0" title="root">
<category id="1" title="Testing Canned">
</category>
<response id="1" title="Private response">
<message><![CDATA[This is the private response]]></message>
</response>
</category>
</canned>

XML;

		$empty = <<<XML
<canned>
<category id="0" title="root">
</category>
</canned>

XML;

		return [
			[2, SWIFT_CannedCategory::TYPE_PUBLIC, $withCategories],
			[1, SWIFT_CannedCategory::TYPE_PRIVATE, $withCategories],
			[2, SWIFT_CannedCategory::TYPE_PRIVATE, $empty],
		];
	}

	/**
  * @param $staffId
  * @param $public
  * @param $expected
  * @throws SWIFT_Canned_Exception
  */
 #[\PHPUnit\Framework\Attributes\DataProvider('providerDispatchXML')]
 public function testDispatchXML($staffId, $public, $expected)
	{
		$xmlObj = new \SWIFT_XML();
		$xmlObj->SetIsClassLoaded(true);
		$_SWIFT = \SWIFT::GetInstance();
		$_SWIFT->Staff = $this->getMockBuilder(SWIFT_Staff::class)
		->disableOriginalConstructor()
		->getMock();

		$_SWIFT->Staff
			->method('GetID')
			->willReturn(1);

		$reflection = new \ReflectionClass(SWIFT_CannedManager::class);
		$_cannedCategoryCache = $reflection->getProperty('_cannedCategoryCache');
		$_cannedCategoryCache->setAccessible(true);
		$_cannedCategoryCache->setValue([
			'_cannedCategoryContainer' => [
				[
					'cannedcategoryid' => '1',
					'parentcategoryid' => '0',
					'categorytype' => $public,
					'staffid' => $staffId,
					'title' => 'Testing Canned',
				],
			],
			'_cannedParentMap' =>
				[
					[
						[
							'cannedcategoryid' => '1',
							'parentcategoryid' => '0',
							'categorytype' => $public,
							'staffid' => $staffId,
							'title' => 'Testing Canned',
						],
					],
				],
		]);

		$_cannedResponseCache = $reflection->getProperty('_cannedResponseCache');
		$_cannedResponseCache->setAccessible(true);
		$_cannedResponseCache->setValue([
			'_cannedResponsesContainer' =>
				[
					[
						'cannedresponseid' => '1',
						'cannedcategoryid' => '1',
						'staffid' => $staffId,
						'title' => 'Private response',
						'urldata' => '',
						'imagedata' => '',
						'responsetype' => '3',
						'dateline' => '0',
						'contents' => 'This is the private response',
					],
				],
			'_responseParentMap' =>
				[
					[
						[
							'cannedresponseid' => '1',
							'cannedcategoryid' => '1',
							'staffid' => $staffId,
							'title' => 'Private response',
							'urldata' => '',
							'imagedata' => '',
							'responsetype' => '3',
							'dateline' => '0',
							'contents' => 'This is the private response',
						],
					],
				],
		]);
		$s = SWIFT_CannedManager::DispatchXML($xmlObj);

		$this->assertTrue($s);
		$expect = '<?xml version="1.0" encoding="UTF-8"?>'.PHP_EOL.$expected;		
		$this->assertEquals($expect, $xmlObj->ReturnXML());
	}
}