<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace News\Admin;

/**
 * Class View_ImpExTest
 */
#[\PHPUnit\Framework\Attributes\Group('news')]
class View_ImpExTest extends \SWIFT_TestCase
{
    public function getView()
    {
        $mockLang = $this->createMock('SWIFT_LanguageEngine');

        $mockLang->method('Get')->willReturnArgument(0);

        $mockView = $this->createMock(\News\Admin\View_ImpEx::class);

        $mockInt = $this->createMock(\Base\Library\UserInterface\SWIFT_UserInterfaceControlPanel::class);

        $mockTab = $this->createMock(\Base\Library\UserInterface\SWIFT_UserInterfaceTab::class);

        $mockTb = $this->createMock(\Base\Library\UserInterface\SWIFT_UserInterfaceToolbar::class);

        $this->mockProperty($mockTab, 'Toolbar', $mockTb);

        $mockInt->method('AddTab')->willReturn($mockTab);

        $mockCache = $this->createMock('SWIFT_CacheStore');

        $mockCache->method('Get')->willReturn([
            [
                'title' => 'title',
                'tgroupid' => '1',
            ]
        ]);

        return new View_ImpExMock([
            'Language' => $mockLang,
            'UserInterface' => $mockInt,
            'View' => $mockView,
            'Cache' => $mockCache,
        ]);
    }

    public function testRenderImpExTrue()
    {
        $obj = $this->getView();
        $this->assertTrue($obj->RenderImpEx(true));

        $obj->SetIsClassLoaded(false);
        $this->assertFalse($obj->RenderImpEx());
    }
}

class View_ImpExMock extends View_ImpEx
{
    /**
     * View_ImpExMock constructor.
     * @param array $services
     */
    public function __construct(array $services = [])
    {
        $this->Load = new LoaderMock();

        parent::__construct();

        foreach ($services as $prop => $service) {
            $this->$prop = $service;
        }
    }
}
