<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace News\Cron;

use News\Admin\LoaderMock;
use SWIFT;

/**
 * Class Controller_NewsMinuteTest
 */
#[\PHPUnit\Framework\Attributes\Group('news')]
class Controller_NewsMinuteTest extends \SWIFT_TestCase
{
    public function setUp(): void
    {
        parent::setUp();

        $mockDb = $this->createMock('SWIFT_Database');

        $mockDb->method('AutoExecute')->willReturn(true);
        $mockDb->method('Insert_ID')->willReturn(1);
        $mockDb->method('QueryFetch')->willReturn([
            'cronid' => 1,
            'name' => 'name',
        ]);

        SWIFT::GetInstance()->Database = $mockDb;
    }

    /**
     * @throws \SWIFT_Exception
     */
    public function testSyncReturnsTrue()
    {
        $mockSettings = $this->createMock('SWIFT_Settings');

        $mockSettings->method('Get')->willReturn('1');

        $mockMgr = $this->createMock(\News\Library\Sync\SWIFT_NewsSyncManager::class);

        $obj = new Controller_NewsMinuteMock([
            'Settings' => $mockSettings,
            'NewsSyncManager' => $mockMgr,
        ]);

        SWIFT::Set('iscron', false);

        $obj->SetIsClassLoaded(true);
        $this->assertTrue($obj->Sync());

        $obj->SetIsClassLoaded(false);
        $this->expectExceptionMessage(SWIFT_CLASSNOTLOADED);
        $this->expectException('SWIFT_Exception');
        $obj->Sync();
    }
}

class Controller_NewsMinuteMock extends Controller_NewsMinute
{
    /**
     * Controller_NewsMinuteMock constructor.
     * @param array $services
     */
    public function __construct(array $services = [])
    {
        $this->Load = new LoaderMock();
        foreach ($services as $prop => $service) {
            $this->$prop = $service;
        }
        parent::__construct();
    }

    public function Initialize()
    {
        return true;
    }
}
