<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Abdulrahman Suleiman <abdulrahman.suleiman@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Parser;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;

/**
 * Class KQLSchema_parserTest
 */
#[\PHPUnit\Framework\Attributes\Group('parser')]
#[\PHPUnit\Framework\Attributes\Group('parser-config')]
class KQLSchema_parserTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = $this->getMocked();
        $this->assertInstanceOf(\Parser\SWIFT_KQLSchema_parser::class, $obj);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testGetSchemaReturnsArray()
    {
        $obj = $this->getMocked();

        $this->assertTrue(is_array($obj->GetSchema()),
            'Returns array');

        $this->assertClassNotLoaded($obj, 'GetSchema');
    }

    private function getMocked(): \PHPUnit\Framework\MockObject\MockObject|\Parser\SWIFT_KQLSchema_parserMock
    {
        return $this->getMockObject(\Parser\SWIFT_KQLSchema_parserMock::class);
    }
}

class SWIFT_KQLSchema_parserMock extends SWIFT_KQLSchema_parser
{
    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct();
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

