<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Banjo Mofesola Paul <banjo.paul@aurea.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Parser\Library\MailParser;

use Knowledgebase\Admin\LoaderMock;
use Parser\Models\EmailQueue\SWIFT_EmailQueue;
use PHPUnit\Framework\Constraint\IsType;
use SWIFT_Exception;

/**
 * Class MailParserIMAPTest
 */
#[\PHPUnit\Framework\Attributes\Group('parser-library')]
class MailParserIMAPTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = $this->getMocked();
        $this->assertInstanceOf(\Parser\Library\MailParser\SWIFT_MailParserIMAP::class, $obj);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testProcessReturnsString()
    {
        $obj = $this->getMocked();

        $count = 0;
        static::$nextRecordType = \SWIFT_TestCase::NEXT_RECORD_RETURN_CALLBACK;
        static::$databaseCallback['NextRecord'] = function () use (&$count) {
            $count++;
            \SWIFT::GetInstance()->Database->Record['emailqueueid'] = 1;
            \SWIFT::GetInstance()->Database->Record['email'] = 'email@address.com';
            \SWIFT::GetInstance()->Database->Record['userpassword'] = 'cXUKb5GFraI/dEXavA9RwEbMtabj9gqbxHuIkQ==';
            \SWIFT::GetInstance()->Database->Record['host'] = 'localhost';
            \SWIFT::GetInstance()->Database->Record['port'] = '143';
            \SWIFT::GetInstance()->Database->Record['username'] = 'username';
            if ($count == 1) {
                \SWIFT::GetInstance()->Database->Record['fetchtype'] = SWIFT_EmailQueue::FETCH_PIPE;
            } elseif ($count == 3) {
                \SWIFT::GetInstance()->Database->Record['fetchtype'] = SWIFT_EmailQueue::FETCH_IMAP;
            } elseif ($count == 5) {
                \SWIFT::GetInstance()->Database->Record['fetchtype'] = SWIFT_EmailQueue::FETCH_IMAPSSL;
            } elseif ($count == 7) {
                \SWIFT::GetInstance()->Database->Record['fetchtype'] = SWIFT_EmailQueue::FETCH_IMAPTLS;
            } elseif ($count == 9) {
                \SWIFT::GetInstance()->Database->Record['fetchtype'] = SWIFT_EmailQueue::FETCH_POP3SSL;
            } elseif ($count == 11) {
                \SWIFT::GetInstance()->Database->Record['fetchtype'] = SWIFT_EmailQueue::FETCH_POP3TLS;
            } elseif ($count == 13) {
                \SWIFT::GetInstance()->Database->Record['fetchtype'] = SWIFT_EmailQueue::FETCH_POP3;
            }
            return $count % 2;
        };

        $this->assertFalse($obj->Process());

        $this->assertIsString($obj->Process());
        $this->assertIsString($obj->Process());
        $this->assertIsString($obj->Process());
        $this->assertIsString($obj->Process());
        $this->assertIsString($obj->Process());
        $this->assertIsString($obj->Process());

        $obj->SetIsClassLoaded(false);
        $this->assertClassNotLoaded($obj, 'Process');
    }

    private function getMocked(): \PHPUnit\Framework\MockObject\MockObject|\Parser\Library\MailParser\SWIFT_MailParserIMAPMock
    {
        return $this->getMockObject(\Parser\Library\MailParser\SWIFT_MailParserIMAPMock::class);
    }
}

class SWIFT_MailParserIMAPMock extends SWIFT_MailParserIMAP
{
    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct();
    }

    public function ProcessMailbox($_fetchType, $_isPOP3, $_emailQueueContainer)
    {
        return parent::ProcessMailbox($_fetchType, $_isPOP3, $_emailQueueContainer); // TODO: Change the autogenerated stub
    }

    public function Initialize()
    {
        // override
        $this->Cryptor = new \SWIFT_Cryptor();
        return true;
    }
}

