<?php
/**
* ###############################################
*
* Kayako Classic
* _______________________________________________
*
* @author        Werner Garcia <werner.garcia@crossover.com>
*
* @package       swift
* @copyright     Copyright (c) 2001-2018, Trilogy
* @license       http://kayako.com/license
* @link          http://kayako.com
*
* ###############################################
*/

namespace Tickets\Admin;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;
use Base\Library\UserInterface\SWIFT_UserInterfaceGrid;

/**
* Class View_FileTypeTest
*/
#[\PHPUnit\Framework\Attributes\Group('tickets')]
class View_FileTypeTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testRenderReturnsTrue()
    {
        $_POST['_isDialog'] = 1;

        $obj = $this->getView();
        $this->assertTrue($obj->Render(2),
            'Returns true in insert mode');

        $mock = $this->createMock(\Tickets\Models\FileType\SWIFT_TicketFileType::class);
        $this->assertTrue($obj->Render(1, $mock),
            'Returns true in edit mode');

        $obj->SetIsClassLoaded(false);
        $this->assertFalse($obj->Render(1),
            'Returns false if class is not loaded');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testRenderGridReturnsTrue()
    {
        $obj = $this->getView();
        $obj->UserInterfaceGrid->method('GetMode')->willReturn(2);
        $this->assertTrue($obj->RenderGrid(),
            'Returns true');

        $obj->SetIsClassLoaded(false);
        $this->assertFalse($obj->RenderGrid(),
            'Returns false if class is not loaded');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testGridRenderReturnsArray()
    {
        $obj = $this->getView();
        $arr = ['extension' => 'gif'];
        $this->assertCount(3, $obj::GridRender($arr), 'Returns array');
    }

    private function getView(): \PHPUnit\Framework\MockObject\MockObject|\Tickets\Admin\View_FileTypeMock
    {
        return $this->getMockObject(\Tickets\Admin\View_FileTypeMock::class);
    }
}

/**
 * Class View_FileTypeMock
 *
 * @property \PHPUnit_Framework_MockObject_MockObject|SWIFT_UserInterfaceGrid UserInterfaceGrid
 * @package Tickets\Admin
 */
class View_FileTypeMock extends View_FileType
{

    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct();
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

