<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Tickets\Models\Draft;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;

/**
 * Class TicketDraftTest
 */
#[\PHPUnit\Framework\Attributes\Group('tickets')]
class TicketDraftTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = $this->getMocked();
        $this->assertInstanceOf(\Tickets\Models\Draft\SWIFT_TicketDraft::class, $obj);
    }

    private function getMocked(): \PHPUnit\Framework\MockObject\MockObject|\Tickets\Models\Draft\SWIFT_TicketDraftMock
    {
        return $this->getMockObject(\Tickets\Models\Draft\SWIFT_TicketDraftMock::class);
    }
}

class SWIFT_TicketDraftMock extends SWIFT_TicketDraft
{
    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct();
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

