<?php
/**
* ###############################################
*
* Kayako Classic
* _______________________________________________
*
* @author        Werner Garcia <werner.garcia@crossover.com>
*
* @package       swift
* @copyright     Copyright (c) 2001-2018, Trilogy
* @license       http://kayako.com/license
* @link          http://kayako.com
*
* ###############################################
*/

namespace Tickets\Models\Recipient;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;

/**
* Class TicketRecipientTest
*/
#[\PHPUnit\Framework\Attributes\Group('tickets')]
class TicketRecipientTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $this->getMockServices();
        /** @var \PHPUnit\Framework\MockObject\MockObject|\SWIFT_Database $mockDb */
        $mockDb = $this->mockServices['Database'];
        $mockDb->method('QueryFetch')->willReturn([
            'ticketrecipientid' => 1,
        ]);
        $obj = $this->getMockObject(\Tickets\Models\Recipient\SWIFT_TicketRecipientMock::class);
        $this->assertInstanceOf(\Tickets\Models\Recipient\SWIFT_TicketRecipient::class, $obj);
    }
}

class SWIFT_TicketRecipientMock extends SWIFT_TicketRecipient
{

    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct(1);
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

