<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Troubleshooter;

/**
 * Class App_troubleshooterTest
 */
#[\PHPUnit\Framework\Attributes\Group('troubleshooter')]
class App_troubleshooterTest extends \SWIFT_TestCase
{
    /**
     * @throws \SWIFT_Exception
     */
    public function testInitializeReturnsTrue()
    {
        $obj = new SWIFT_App_troubleshooter('troubleshooter');
        $this->assertInstanceOf(\Troubleshooter\SWIFT_App_troubleshooter::class, $obj);

        $obj->SetIsClassLoaded(true);
        $this->assertTrue($obj->Initialize());

        $obj->SetIsClassLoaded(false);
        $this->expectExceptionMessage(SWIFT_CLASSNOTLOADED);
        $this->expectException('SWIFT_Exception');
        $this->assertFalse($obj->Initialize());
    }
}
