<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Troubleshooter;

use SWIFT;
use SWIFT_Exception;
use Troubleshooter\Admin\LoaderMock;

/**
 * Class SetupDatabase_troubleshooterTest
 */
#[\PHPUnit\Framework\Attributes\Group('troubleshooter')]
class SetupDatabase_troubleshooterTest extends \SWIFT_TestCase
{
    public function setUp(): void
    {
        parent::setUp();

        SWIFT::GetInstance()->Load = new LoaderMock();
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = new SetupDatabaseMock();
        $this->assertInstanceOf(\Troubleshooter\SWIFT_SetupDatabase_troubleshooter::class, $obj);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testPageCountReturnsOne()
    {
        $obj = new SetupDatabaseMock();
        $this->assertEquals($obj->GetPageCount(), SWIFT_SetupDatabase_troubleshooter::PAGE_COUNT);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testUpgradeThrowsException() {
        $obj = new SetupDatabaseMock();
        $obj->SetIsClassLoaded(false);
        $this->expectExceptionMessage(SWIFT_CLASSNOTLOADED);
        $this->expectException('SWIFT_Exception');
        $obj->Upgrade();
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testUninstallReturnsTrue() {
        $mockDb = $this->createMock('SWIFT_Database');

        $mockAdo = $this->createMock(ADODBDictionary::class);

        $mockAdo->method('DropTableSQL')
            ->willReturn([]);

        $mockAdo->method('ExecuteSQLArray')
            ->willReturn(false);

        $mockDb->method('GetADODBDictionaryObject')
            ->willReturn($mockAdo);

        \SWIFT::GetInstance()->Database = $mockDb;

        $obj = new SetupDatabaseMock();
        $this->assertTrue($obj->Uninstall());
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testInstallReturnsTrue() {
        $mockDb = $this->createMock('SWIFT_Database');

        $mockLang = $this->createMock('SWIFT_LanguageEngine');

        $mockLang->method('Get')
            ->willReturnArgument(0);

        $mockDb->method('Insert_ID')
            ->willReturn(true);

        \SWIFT::GetInstance()->Database = $mockDb;

        $obj = new SetupDatabaseMock();
        $this->mockProperty($obj, 'Language', $mockLang);
        $this->assertTrue($obj->Install(-1));
    }

}

class SetupDatabaseMock extends SWIFT_SetupDatabase_troubleshooter {
    protected function LoadModels() {
        // do nothing
    }
}

class ADODBDictionary {

    public function DropTableSQL() {
        return [];
    }

    public function ExecuteSQLArray() {
        return true;
    }
}