<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Base\Console;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;

/**
 * Class Controller_GeoIPTest
 */
#[\PHPUnit\Framework\Attributes\Group('base')]
#[\PHPUnit\Framework\Attributes\Group('base-console')]
class Controller_GeoIPTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = $this->getMocked();
        $this->assertInstanceOf(\Base\Console\Controller_GeoIP::class, $obj);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testRebuildReturnsTrue()
    {
        $obj = $this->getMocked();

        fclose(fopen('./__swift/geoip/lite/isp.csv', 'w'));
        fclose(fopen('./__swift/geoip/lite/netspeed.csv', 'w'));
        fclose(fopen('./__swift/geoip/lite/organization.csv', 'w'));
        fclose(fopen('./__swift/geoip/lite/citylocation.csv', 'w'));
        fclose(fopen('./__swift/geoip/lite/cityblocks.csv', 'w'));

        $this->assertTrue($obj->Rebuild(),
            'Returns true');

        $this->assertClassNotLoaded($obj, 'Rebuild');
    }

    private function getMocked(): \PHPUnit\Framework\MockObject\MockObject|\Base\Console\Controller_GeoIPMock
    {
        return $this->getMockObject(\Base\Console\Controller_GeoIPMock::class, [
            'Console' => new ConsoleMock()
        ]);
    }
}

class Controller_GeoIPMock extends Controller_GeoIP
{
    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct();
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

