<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */
/**
 * Class SetupDatabaseInsertSQLTest
 */
#[\PHPUnit\Framework\Attributes\Group('library_setup')]
class SetupDatabaseInsertSQLTest extends SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $_tableName = '';
        $_insertFields = [];
        $this->expectExceptionMessage(SWIFT_INVALIDDATA);
        $this->expectException('SWIFT_Setup_Exception');
        new SWIFT_SetupDatabaseInsertSQL($_tableName, $_insertFields);
        $this->expectExceptionMessage(SWIFT_INVALIDDATA);
        $this->expectException('SWIFT_Setup_Exception');
        $this->expectException('SWIFT_Setup_Exception');
        new SWIFT_SetupDatabaseInsertSQL($_tableName, $_insertFields);

        $_insertFields = ['id' => 1];
        $obj = new SWIFT_SetupDatabaseInsertSQL($_tableName, $_insertFields);
        $this->expectExceptionMessage(SWIFT_CLASSNOTLOADED);
        $this->expectException('SWIFT_Setup_Exception');

        $obj->SetIsClassLoaded(false);
        $this->expectException('SWIFT_Setup_Exception');
        new SWIFT_SetupDatabaseInsertSQL($_tableName, $_insertFields);
    }
}
