<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */
/**
 * Class SetupDatabaseTableTest
 */
#[\PHPUnit\Framework\Attributes\Group('library_setup')]
class SetupDatabaseTableTest extends SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $_tblName = '';
        $_tblFields = '';
        $this->expectExceptionMessage(SWIFT_INVALIDDATA);
        $this->expectException('SWIFT_Setup_Exception');
        new SWIFT_SetupDatabaseTable($_tblName, $_tblFields);
        $this->expectExceptionMessage(SWIFT_INVALIDDATA);
        $this->expectException('SWIFT_Setup_Exception');
        $this->expectException('SWIFT_Setup_Exception');
        new SWIFT_SetupDatabaseTable($_tblName, $_tblFields);

        $_tblFields = 'id I PRIMARY AUTO NOTNULL';
        $obj = new SWIFT_SetupDatabaseTable($_tblName, $_tblFields);
        $this->expectExceptionMessage(SWIFT_CLASSNOTLOADED);
        $this->expectException('SWIFT_Setup_Exception');

        $obj->SetIsClassLoaded(false);
        $this->expectException('SWIFT_Setup_Exception');
        new SWIFT_SetupDatabaseTable($_tblName, $_tblFields);
    }
}
