<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Tickets;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;

/**
 * Class KQLSchema_ticketsTest
 */
#[\PHPUnit\Framework\Attributes\Group('tickets')]
#[\PHPUnit\Framework\Attributes\Group('tickets-config')]
class KQLSchema_ticketsTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = $this->getMocked();
        $this->assertInstanceOf(\Tickets\SWIFT_KQLSchema_tickets::class, $obj);
    }

    public function testGetSchemaThrowsException() {
        $obj = $this->getMocked();
        $this->assertClassNotLoaded($obj, 'GetSchema');
    }

    private function getMocked(): \PHPUnit\Framework\MockObject\MockObject|\Tickets\SWIFT_KQLSchema_ticketsMock
    {
        return $this->getMockObject(\Tickets\SWIFT_KQLSchema_ticketsMock::class);
    }
}

class SWIFT_KQLSchema_ticketsMock extends SWIFT_KQLSchema_tickets
{
    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct();
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

