<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Base;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;

/**
 * Class KQLSchema_baseTest
 */
#[\PHPUnit\Framework\Attributes\Group('base')]
class KQLSchema_baseTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = $this->getMocked();
        $this->assertInstanceOf(\Base\SWIFT_KQLSchema_base::class, $obj);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testGetSchemaReturnsArray()
    {
        $obj = $this->getMocked();

        $this->assertArrayHasKey('departments', $obj->GetSchema(), 'Hes departments');
        $this->assertArrayHasKey('taglinks', $obj->GetSchema(), 'Hes taglinks');

        $this->assertClassNotLoaded($obj, 'GetSchema');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testGetClausesReturnsArray()
    {
        $obj = $this->getMocked();
//        fwrite(STDERR, print_r($obj->GetClauses(), TRUE));
        $this->assertArrayHasKey('SELECT', $obj->GetClauses(), 'Hes SELECT');
        $this->assertArrayHasKey('LIMIT', $obj->GetClauses(), 'Hes LIMIT');

        $this->assertClassNotLoaded($obj, 'GetClauses');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testGetOperatorsReturnsArray()
    {
        $obj = $this->getMocked();
        $this->assertArrayHasKey('+', $obj->GetOperators(), 'Hes +');
        $this->assertArrayHasKey('=', $obj->GetOperators(), 'Hes =');

        $this->assertClassNotLoaded($obj, 'GetOperators');
    }


    /**
     * @throws SWIFT_Exception
     */
    public function testGetFunctionsReturnsArray()
    {
        $obj = $this->getMocked();
        $this->assertArrayHasKey('COUNT', $obj->GetFunctions(), 'Hes COUNT');
        $this->assertArrayHasKey('SUM', $obj->GetFunctions(), 'Hes SUM');

        $this->assertClassNotLoaded($obj, 'GetFunctions');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testGetSelectorsReturnsArray()
    {
        $obj = $this->getMocked();

        $this->assertArrayHasKey('MINUTE', $obj->GetSelectors(), 'Has MINUTE');
        $this->assertArrayHasKey('YEAR', $obj->GetSelectors(), 'Has YEAR');

        $this->assertClassNotLoaded($obj, 'GetSelectors');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testGetPreModifiersReturnsArray()
    {
        $obj = $this->getMocked();

        $this->assertArrayHasKey('DISTINCT', $obj->GetPreModifiers(), 'Has DISTINCT');
        $this->assertArrayHasKey('INTERVAL', $obj->GetPreModifiers(), 'Has INTERVAL');

        $this->assertClassNotLoaded($obj, 'GetPreModifiers');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testGetPostModifiersReturnsArray()
    {
        $obj = $this->getMocked();

        $this->assertArrayHasKey('AS', $obj->GetPostModifiers(), 'Has AS');
        $this->assertArrayHasKey('DESC', $obj->GetPostModifiers(), 'Has DESC');

        $this->assertClassNotLoaded($obj, 'GetPostModifiers');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testGetIdentifiersReturnsArray()
    {
        $obj = $this->getMocked();

        $this->assertArrayHasKey('NULL', $obj->GetIdentifiers(), 'Has NULL');
        $this->assertArrayHasKey('FALSE', $obj->GetIdentifiers(), 'Has FALSE');
        $this->assertClassNotLoaded($obj, 'GetIdentifiers');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testGetVariablesReturnsArray()
    {
        $obj = $this->getMocked();

        $this->assertArrayHasKey('_STAFF', $obj->GetVariables(), 'Has _STAFF');
        $this->assertArrayHasKey('_NOW', $obj->GetVariables(), 'Has _NOW');

        $this->assertClassNotLoaded($obj, 'GetVariables');
    }

    private function getMocked(): \PHPUnit\Framework\MockObject\MockObject|\Base\SWIFT_KQLSchema_baseMock
    {
        return $this->getMockObject(\Base\SWIFT_KQLSchema_baseMock::class);
    }
}

class SWIFT_KQLSchema_baseMock extends SWIFT_KQLSchema_base
{
    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct();
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

