<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Base\Console;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;
use Tickets\Models\Ticket\SWIFT_Ticket;

/**
 * Class Controller_StatisticsTest
 */
#[\PHPUnit\Framework\Attributes\Group('base')]
#[\PHPUnit\Framework\Attributes\Group('base-console')]
class Controller_StatisticsTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = $this->getMocked();
        $this->assertInstanceOf(\Base\Console\Controller_Statistics::class, $obj);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testIndexReturnsTrue()
    {
        $obj = $this->getMocked();

        $mockDb = $this->createMock('SWIFT_Database');

        $mockDb->method('QueryFetch')->willReturn(['totalitems' => 5]);
        $mockDb->method('QueryFetchAll')->willReturn([['Name' => TABLE_PREFIX . SWIFT_Ticket::TABLE_NAME, 'Rows' => 5]]);

        $_SWIFT = \SWIFT::GetInstance();
        $_SWIFT->Database = $mockDb;
        $obj->Database = $mockDb;

        $this->expectOutputRegex('/{[\"\w\":.+\,+]*}/');

        $this->assertTrue($obj->Index(),
            'Returns true');

        $this->assertClassNotLoaded($obj, 'Index');
    }

    private function getMocked(): \PHPUnit\Framework\MockObject\MockObject|\Base\Console\Controller_StatisticsMock
    {
        return $this->getMockObject(\Base\Console\Controller_StatisticsMock::class);
    }
}

class Controller_StatisticsMock extends Controller_Statistics
{
    public $Database;

    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct();
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

