<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */
/**
 * Class SetupDatabaseIndexTest
 */
#[\PHPUnit\Framework\Attributes\Group('library_setup')]
class SetupDatabaseIndexTest extends SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = null;
        $_idxName = '';
        $_tblName = '';
        $_idxFields = '';
        $this->expectExceptionMessage(SWIFT_INVALIDDATA);
        $this->expectException('SWIFT_Setup_Exception');
        new SWIFT_SetupDatabaseIndex($_idxName, $_tblName, $_idxFields);
        $this->expectExceptionMessage(SWIFT_INVALIDDATA);
        $this->expectException('SWIFT_Setup_Exception');
        $this->expectException('SWIFT_Setup_Exception');
        $this->expectExceptionMessage(SWIFT_INVALIDDATA);
        $this->expectException('SWIFT_Setup_Exception');

        $_tblName = 'tbl';
        $this->expectException('SWIFT_Setup_Exception');
        new SWIFT_SetupDatabaseIndex($_idxName, $_tblName, $_idxFields);

        $_idxFields = 'id';
        $this->expectExceptionMessage(SWIFT_CLASSNOTLOADED);
        $this->expectException('SWIFT_Setup_Exception');
        $this->assertInstanceOf('SWIFT_SetupDatabaseIndex', $obj);

        $obj->SetIsClassLoaded(false);
        $this->expectException('SWIFT_Setup_Exception');
        new SWIFT_SetupDatabaseIndex($_idxName, $_tblName, $_idxFields);
    }
}
