<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Knowledgebase\Admin;

use SWIFT_Exception;

/**
 * Class Controller_MaintenanceTest
 */
#[\PHPUnit\Framework\Attributes\Group('knowledgebase')]
class Controller_MaintenanceTest extends \SWIFT_TestCase
{
    /**
     * @return Controller_MaintenanceMock
     * @throws SWIFT_Exception
     */
    public function getController() {
        $mockDb = $this->createMock('SWIFT_Database');

        $mockDb->method('NextRecord')->willReturnOnConsecutiveCalls(true, false);

        $mockDb->Record = [
          'kbarticleid' => 1,
          'kbarticledataid' => 1,
          'subject' => 'subject',
          'contentstext' => 'contentstext',
        ];

        $mockStaff = $this->createMock(\Base\Models\Staff\SWIFT_Staff::class);

        $mockStaff->method('GetPermission')
            ->willReturnOnConsecutiveCalls('0', '1');

        $_SWIFT = \SWIFT::GetInstance();
        $_SWIFT->Staff = $mockStaff;
        $_SWIFT->Database = $mockDb;

        $mockInt = $this->createMock(\Base\Library\UserInterface\SWIFT_UserInterfaceControlPanel::class);

        $mockLang = $this->createMock('SWIFT_LanguageEngine');

        $mockView = $this->createMock(\Knowledgebase\Admin\View_Maintenance::class);

        $obj = new Controller_MaintenanceMock($mockLang, $mockView, $mockDb);
        $obj->SetIsClassLoaded(true);
        $this->mockProperty($obj, 'UserInterface', $mockInt);

        return $obj;
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = new Controller_Maintenance();
        $this->assertInstanceOf(\Knowledgebase\Admin\Controller_Maintenance::class, $obj);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testIndexReturnsTrue()
    {
        $obj = $this->getController();

        $this->assertTrue($obj->Index(),
            'Returns true with admin_tcanrunmaintenance = 0');

        $this->assertTrue($obj->Index(),
            'Returns true with admin_tcanrunmaintenance = 1');

        $obj->SetIsClassLoaded(false);
        $this->expectException('SWIFT_Exception');
        $obj->Index();
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testReIndexReturnsTrue()
    {
        $obj = $this->getController();

        $this->assertTrue($obj->ReIndex(0, 'no'));

        $this->assertTrue($obj->ReIndex(1, 1, 0, 1, 0));
        $this->assertTrue($obj->ReIndex(1, 2, 0, 1, 0));

        $obj->SetIsClassLoaded(false);
        $this->expectExceptionMessage(SWIFT_CLASSNOTLOADED);
        $this->expectException('SWIFT_Exception');
        $obj->ReIndex(0);
    }
}

class Controller_MaintenanceMock extends Controller_Maintenance
{
    protected $SettingsManager;

    public function __construct($lang, $view, $db)
    {
        $this->Load = new LoaderMock();
        $this->Language = $lang;
        $this->View = $view;
        $this->Database = $db;

        parent::__construct();
    }

    public function Initialize()
    {
        return true;
    }
}
