<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Abdulrahman Suleiman <abdulrahman.suleiman@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Parser\Console;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;

/**
 * Class Controller_FetchDaemonTest
 */
#[\PHPUnit\Framework\Attributes\Group('parser')]
#[\PHPUnit\Framework\Attributes\Group('parser-console')]
class Controller_FetchDaemonTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = $this->getMocked();
        $this->assertInstanceOf(\Parser\Console\Controller_FetchDaemon::class, $obj);
    }

    public function setUp(): void
    {
        parent::setUp();

        $mockRouter = $this->createMock('SWIFT_Router');

        $mockApp = $this->createMock('SWIFT_App');

        $mockApp->method('GetName')->willReturn(APP_PARSER);

        $mockRouter->method('GetApp')->willReturn($mockApp);

        \SWIFT::GetInstance()->Router = $mockRouter;
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testIndexReturnsTrue()
    {
        $obj = $this->getMocked();

        static::$databaseCallback['CacheGet'] = function ($x) {
            if ($x == 'queuecache')
                return [
                    'pointer' => [1],
                    'list' => [
                        1 => [
                            'fetchtype' => 'imap',
                            'isenabled' => 1
                        ]
                    ]
                ];
        };

        $this->expectOutputRegex('/\{.*\}/');

        $this->assertTrue($obj->Index(),
            'Returns true');

        $this->assertClassNotLoaded($obj, 'Index');
    }

    private function getMocked(): \PHPUnit\Framework\MockObject\MockObject|\Parser\Console\Controller_FetchDaemonMock
    {
        return $this->getMockObject(\Parser\Console\Controller_FetchDaemonMock::class);
    }
}

class Controller_FetchDaemonMock extends Controller_FetchDaemon
{
    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct();
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

