<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Abdulrahman Suleiman <abdulrahman.suleiman@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Parser\Cron;

use Knowledgebase\Admin\LoaderMock;
use Parser\Library\MailParser\SWIFT_MailParserIMAP;
use SWIFT_Exception;

/**
 * Class Controller_ParserMinuteTest
 */
#[\PHPUnit\Framework\Attributes\Group('parser')]
#[\PHPUnit\Framework\Attributes\Group('parser-cron')]
class Controller_ParserMinuteTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = $this->getMocked();
        $this->assertInstanceOf(\Parser\Cron\Controller_ParserMinute::class, $obj);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testPOP3IMAPReturnsTrue()
    {
        $obj = $this->getMocked();

        \SWIFT::GetInstance()->Database->method('QueryFetch')->willReturn(['cronid' => 1, 'name' => 'test']);

        $mailParserIMAPMock = $this->createMock(SWIFT_MailParserIMAP::class);

        $mailParserIMAPMock->method('Process')->willReturn(true);

        $obj->MailParserIMAP = $mailParserIMAPMock;

        $this->expectOutputRegex('/.*/');

        $this->assertTrue($obj->POP3IMAP(),
            'Returns true');

        $this->assertClassNotLoaded($obj, 'POP3IMAP');
    }

    private function getMocked(): \PHPUnit\Framework\MockObject\MockObject|\Parser\Cron\Controller_ParserMinuteMock
    {
        return $this->getMockObject(\Parser\Cron\Controller_ParserMinuteMock::class);
    }
}

class Controller_ParserMinuteMock extends Controller_ParserMinute
{
    public $MailParserIMAP;

    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct();
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

