<?php
/**
* ###############################################
*
* Kayako Classic
* _______________________________________________
*
* @author        Werner Garcia <werner.garcia@crossover.com>
*
* @package       swift
* @copyright     Copyright (c) 2001-2018, Trilogy
* @license       http://kayako.com/license
* @link          http://kayako.com
*
* ###############################################
*/

namespace Tickets\Models\Ticket;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;

/**
* Class TicketForwardTest
*/
#[\PHPUnit\Framework\Attributes\Group('tickets')]
class TicketForwardTest extends \SWIFT_TestCase
{
    public function testConstructorReturnsClassInstance()
    {
        $obj = $this->getMocked();

        $this->assertInstanceOf(\Tickets\Models\Ticket\SWIFT_TicketForward::class, $obj);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testCreateFromEmailListReturnsArray()
    {
        $obj = $this->getMocked();

        $this->assertEmpty($obj::CreateFromEmailList(0, []),
            'Returns empty array');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testRetrieveEmailListOnTicketPostReturnsArray()
    {
        $obj = $this->getMocked();

        $_post = $this->createMock(SWIFT_TicketPost::class);
        $_post->method('GetIsClassLoaded')->willReturnOnConsecutiveCalls([true, false]);

        $this->assertCount(0, $obj::RetrieveEmailListOnTicketPost($_post),
            'Returns filled array');

        $this->expectException(SWIFT_Exception::class);
        $obj::RetrieveEmailListOnTicketPost($_post);
    }

    private function getMocked(): \PHPUnit\Framework\MockObject\MockObject|\Tickets\Models\Ticket\SWIFT_TicketForwardMock
    {
        $this->getMockServices();
        /** @var \PHPUnit\Framework\MockObject\MockObject|\SWIFT_Database $mockDb */
        $mockDb = $this->mockServices['Database'];
        $mockDb->method('QueryFetch')->willReturn([
            'ticketforwardid' => 1
        ]);

        return $this->getMockObject(\Tickets\Models\Ticket\SWIFT_TicketForwardMock::class);
    }
}

class SWIFT_TicketForwardMock extends SWIFT_TicketForward
{

    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct(1);
    }

    public function Initialize()
    {
        // override
        return true;
    }
}
