<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Base\Cron;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;

/**
 * Class Controller_BaseDailyTest
 */
#[\PHPUnit\Framework\Attributes\Group('base')]
#[\PHPUnit\Framework\Attributes\Group('base-cron')]
class Controller_BaseDailyTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = $this->getMocked();
        $this->assertInstanceOf(\Base\Cron\Controller_BaseDaily::class, $obj);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testCleanupReturnsTrue()
    {
        $obj = $this->getMocked();

        \SWIFT::GetInstance()->Database->method('QueryFetch')->willReturn(['cronid' => 1, 'name' => 'Test']);


        $this->assertTrue($obj->Cleanup(),
            'Returns true');

        $this->assertClassNotLoaded($obj, 'Cleanup');
    }

    private function getMocked(): \PHPUnit\Framework\MockObject\MockObject|\Base\Cron\Controller_BaseDailyMock
    {
        return $this->getMockObject(\Base\Cron\Controller_BaseDailyMock::class);
    }
}

class Controller_BaseDailyMock extends Controller_BaseDaily
{
    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct();
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

