<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Tickets\Models\TimeTrack;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;

/**
 * Class TicketTimeTrackTest
 */
#[\PHPUnit\Framework\Attributes\Group('tickets')]
class TicketTimeTrackTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = $this->getMocked();
        $this->assertInstanceOf(\Tickets\Models\TimeTrack\SWIFT_TicketTimeTrack::class, $obj);
    }

    private function getMocked(): \PHPUnit\Framework\MockObject\MockObject|\Tickets\Models\TimeTrack\SWIFT_TicketTimeTrackMock
    {
        return $this->getMockObject(\Tickets\Models\TimeTrack\SWIFT_TicketTimeTrackMock::class);
    }
}

class SWIFT_TicketTimeTrackMock extends SWIFT_TicketTimeTrack
{
    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct();
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

