<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Tickets\Staff;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;

/**
 * Class View_SearchTest
 */
#[\PHPUnit\Framework\Attributes\Group('tickets')]
#[\PHPUnit\Framework\Attributes\Group('tickets-staff')]
#[\PHPUnit\Framework\Attributes\Group('tickets-search')]
class View_SearchTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testRenderReturnsTrue()
    {
        $obj = $this->getMocked();
        $this->expectOutputRegex('/script/');
        $this->assertTrue($obj->Render());
        $obj->SetIsClassLoaded(false);
        $this->assertFalse($obj->Render());
    }

    private function getMocked(): \PHPUnit\Framework\MockObject\MockObject|\Tickets\Staff\View_SearchMock
    {
        return $this->getMockObject(\Tickets\Staff\View_SearchMock::class);
    }
}

class View_SearchMock extends View_Search
{
    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct();
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

