<?php
/**
* ###############################################
*
* Kayako Classic
* _______________________________________________
*
* @author        Werner Garcia <werner.garcia@crossover.com>
*
* @package       swift
* @copyright     Copyright (c) 2001-2018, Trilogy
* @license       http://kayako.com/license
* @link          http://kayako.com
*
* ###############################################
*/

namespace Troubleshooter\Admin;

/**
* Class AdminController_SettingsManagerTest
*/
#[\PHPUnit\Framework\Attributes\Group('troubleshooter')]
class AdminController_SettingsManagerTest extends \SWIFT_TestCase
{
    /**
     * @throws \SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = new Controller_SettingsManager();
        $this->assertInstanceOf(\Troubleshooter\Admin\Controller_SettingsManager::class, $obj);
    }

    /**
     * @throws \SWIFT_Exception
     */
    public function testIndexShowsView() {
        $mockStaff = $this->createMock(\Base\Models\Staff\SWIFT_Staff::class);

        $mockStaff
            ->expects($this->exactly(2))
            ->method('GetPermission')
            ->willReturnOnConsecutiveCalls('0', '1');

        $_SWIFT = \SWIFT::GetInstance();
        $_SWIFT->Staff = $mockStaff;

        $mockInt = $this->createMock(\Base\Library\UserInterface\SWIFT_UserInterfaceControlPanel::class);

        $mockLang = $this->createMock('SWIFT_LanguageEngine');

        $mockMgr = $this->createMock('SWIFT_SettingsManager');

        $mockMgr->method('Render')->willReturn(true);

        $obj = new Controller_SettingsManagerMock($mockLang, $mockMgr);
        $obj->SetIsClassLoaded(true);
        $this->mockProperty($obj, 'UserInterface', $mockInt);

        // will display error if permission = 0
        $this->assertTrue($obj->Index());

        // will display correctly if permission = 1
        $this->assertTrue($obj->Index());

        $obj->SetIsClassLoaded(false);
        $this->expectException('SWIFT_Exception');
        $obj->Index();
    }
}

class Controller_SettingsManagerMock  extends Controller_SettingsManager {
    public function __construct($lang, public $SettingsManager)
    {
        $this->Load = new LoaderMock();
        $this->Language = $lang;
    }
}

class LoaderMock {
    public function Library($name) {
        // empty
    }

    public function Model($name) {
        // empty
    }
}
