<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Abdulrahman Suleiman <abdulrahman.suleiman@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Parser\Admin;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;

/**
 * Class Controller_SettingsManagerTest
 */
#[\PHPUnit\Framework\Attributes\Group('parser')]
#[\PHPUnit\Framework\Attributes\Group('parser-admin')]
class Controller_SettingsManagerTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = $this->getMocked();
        $this->assertInstanceOf(\Parser\Admin\Controller_SettingsManager::class, $obj);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testIndexReturnsTrue()
    {
        $obj = $this->getMocked();

        $mockStaff = $this->createMock(\Base\Models\Staff\SWIFT_Staff::class);

        $mockStaff->method('GetPermission')->willReturn('0', '1', '1');

        \SWIFT::GetInstance()->Staff = $mockStaff;

        $this->assertTrue($obj->Index(),
            'Returns true');

        $this->assertTrue($obj->Index(),
            'Returns true');

        $_POST['pr_sizelimit'] = 1;

        $this->assertTrue($obj->Index(),
            'Returns true');

        $this->assertClassNotLoaded($obj, 'Index');
    }

    private function getMocked(): \PHPUnit\Framework\MockObject\MockObject|\Parser\Admin\Controller_SettingsManagerMock
    {
        $settingManagerMock = $this->createMock(\SWIFT_SettingsManager::class);
        $settingManagerMock->method('Render')->willReturn(true);

        return $this->getMockObject(\Parser\Admin\Controller_SettingsManagerMock::class, ['SettingsManager' => $settingManagerMock]);
    }
}

class Controller_SettingsManagerMock extends Controller_SettingsManager
{
    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct();
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

