<?php
/**
* ###############################################
*
* Kayako Classic
* _______________________________________________
*
* @author        Werner Garcia <werner.garcia@crossover.com>
*
* @package       swift
* @copyright     Copyright (c) 2001-2018, Trilogy
* @license       http://kayako.com/license
* @link          http://kayako.com
*
* ###############################################
*/

namespace Tickets\Models\Merge;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;

/**
* Class TicketMergeLogTest
*/
#[\PHPUnit\Framework\Attributes\Group('tickets')]
class TicketMergeLogTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $this->getMockServices();
        /** @var \PHPUnit\Framework\MockObject\MockObject|\SWIFT_Database $mockDb */
        $mockDb = $this->mockServices['Database'];
        $mockDb->method('QueryFetch')->willReturn([
            'ticketmergelogid' => 1,
        ]);
        $obj = $this->getMockObject(\Tickets\Models\Merge\SWIFT_TicketMergeLogMock::class);
        $this->assertInstanceOf(\Tickets\Models\Merge\SWIFT_TicketMergeLog::class, $obj);
    }
}

class SWIFT_TicketMergeLogMock extends SWIFT_TicketMergeLog
{

    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct(1);
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

