<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Tickets\Staff;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;

/**
 * Class Controller_SearchTest
 */
#[\PHPUnit\Framework\Attributes\Group('tickets')]
#[\PHPUnit\Framework\Attributes\Group('tickets-staff')]
#[\PHPUnit\Framework\Attributes\Group('tickets-search')]
class Controller_SearchTest extends \SWIFT_TestCase
{
    public function testConstructorReturnsClassInstance()
    {
        $obj = $this->getMocked();
        $this->assertInstanceOf(\Tickets\Staff\Controller_Search::class, $obj);
    }

    public function testLoadDisplayDataReturnsTrue()
    {
        $obj = $this->getMocked();

        $this->assertClassNotLoaded($obj, '_LoadDisplayData');
    }

    /**
     * @throws \ReflectionException
     */
    public function testLoadSearchReturnsTrue()
    {
        $obj = $this->getMocked();
        $class = new \ReflectionClass($obj);
        $method = $class->getMethod('LoadSearch');
        $method->setAccessible(true);

        $this->assertTrue($method->invoke($obj, []));
        $this->assertTrue($method->invoke($obj, [1]));

        $obj->SetIsClassLoaded(false);
        $this->expectExceptionMessage(SWIFT_CLASSNOTLOADED);
        $this->expectException('SWIFT_Exception');
        $method->invoke($obj, []);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testNewTicketsReturnsTrue()
    {
        $obj = $this->getMocked();

        $this->assertTrue($obj->NewTickets(),
            'Returns true with staff_tcansearch = 0');

        $this->assertTrue($obj->NewTickets(),
            'Returns true with staff_tcansearch = 1');

        $this->assertClassNotLoaded($obj, 'NewTickets');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testUnresolvedOwnerReturnsTrue()
    {
        $obj = $this->getMocked();

        $this->assertTrue($obj->UnresolvedOwner(1),
            'Returns true with staff_tcansearch = 0');

        $this->assertTrue($obj->UnresolvedOwner(1),
            'Returns true with staff_tcansearch = 1');

        $this->assertClassNotLoaded($obj, 'UnresolvedOwner', 1);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testUnresolvedStatusReturnsTrue()
    {
        $obj = $this->getMocked();

        $this->assertTrue($obj->UnresolvedStatus(1),
            'Returns true with staff_tcansearch = 0');

        $this->assertTrue($obj->UnresolvedStatus(1),
            'Returns true with staff_tcansearch = 1');

        $this->assertClassNotLoaded($obj, 'UnresolvedStatus', 1);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testUnresolvedTypeReturnsTrue()
    {
        $obj = $this->getMocked();

        $this->assertTrue($obj->UnresolvedType(1),
            'Returns true with staff_tcansearch = 0');

        $this->assertTrue($obj->UnresolvedType(1),
            'Returns true with staff_tcansearch = 1');

        $this->assertClassNotLoaded($obj, 'UnresolvedType', 1);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testUnresolvedPriorityReturnsTrue()
    {
        $obj = $this->getMocked();

        $this->assertTrue($obj->UnresolvedPriority(1),
            'Returns true with staff_tcansearch = 0');

        $this->assertTrue($obj->UnresolvedPriority(1),
            'Returns true with staff_tcansearch = 1');

        $this->assertClassNotLoaded($obj, 'UnresolvedPriority', 1);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testOverdueReturnsTrue()
    {
        $obj = $this->getMocked();

        $this->assertTrue($obj->Overdue(),
            'Returns true with staff_tcansearch = 0');

        $this->assertTrue($obj->Overdue(),
            'Returns true with staff_tcansearch = 1');

        $this->assertClassNotLoaded($obj, 'Overdue');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testTicketIdReturnsTrue()
    {
        $obj = $this->getMocked();

        $_POST['query'] = 'query';

        $this->assertTrue($obj->TicketID(),
            'Returns true with staff_tcansearch = 0');

        $this->assertTrue($obj->TicketID(),
            'Returns true with staff_tcansearch = 1');

        $this->assertClassNotLoaded($obj, 'TicketID');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testCreatorReturnsTrue()
    {
        $obj = $this->getMocked();

        $_POST['query'] = 'query';

        $this->assertTrue($obj->Creator(),
            'Returns true with staff_tcansearch = 0');

        $this->assertTrue($obj->Creator(),
            'Returns true with staff_tcansearch = 1');

        $this->assertClassNotLoaded($obj, 'Creator');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testQuickSearchReturnsTrue()
    {
        $obj = $this->getMocked();

        $_POST['query'] = ' ';

        $this->assertTrue($obj->QuickSearch(),
            'Returns true with staff_tcansearch = 0');

        $this->assertTrue($obj->QuickSearch(),
            'Returns true with staff_tcansearch = 1');

        $this->assertClassNotLoaded($obj, 'QuickSearch');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testAdvancedReturnsTrue()
    {
        $obj = $this->getMocked();

        $_POST['query'] = 'query';

        $this->assertTrue($obj->Advanced(),
            'Returns true with staff_tcansearch = 0');

        $this->assertTrue($obj->Advanced(),
            'Returns true with staff_tcansearch = 1');

        $this->assertClassNotLoaded($obj, 'Advanced');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testSearchSubmitReturnsTrue()
    {
        $obj = $this->getMocked();

        $_POST['query'] = 'query';

        $this->assertTrue($obj->SearchSubmit(),
            'Returns true with staff_tcansearch = 0');

        $this->assertTrue($obj->SearchSubmit(),
            'Returns true with staff_tcansearch = 1');

        $this->assertClassNotLoaded($obj, 'SearchSubmit');
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testFilterReturnsTrue()
    {
        $mockDb = $this->createMock('SWIFT_Database');
        $mockDb->method('NextRecord')->willReturnOnConsecutiveCalls(true, false, true, false, true, false);
        $mockDb->method('QueryFetch')->willReturn([
            'ticketfilterid' => 1,
            'criteriaoptions' => 1,
            'title' => 'title',
        ]);
        $mockDb->method('Insert_ID')
            ->willReturnOnConsecutiveCalls(1, 0);

        $obj = $this->getMocked([
            'Database' => $mockDb,
        ]);

        \SWIFT::GetInstance()->Database = $mockDb;

        $this->assertTrue($obj->Filter(1));

        $this->assertClassNotLoaded($obj, 'Filter', 1);
    }

    private function getMocked(array $services = []): \PHPUnit\Framework\MockObject\MockObject|\Tickets\Staff\Controller_SearchMock
    {
        $view = $this->createMock(\Tickets\Staff\View_Search::class);

        $mockStaff = $this->createMock(\Base\Models\Staff\SWIFT_Staff::class);

        $mockStaff->method('GetIsClassLoaded')->willReturn(true);
        $mockStaff->method('GetStaffID')->willReturn(1);
        $mockStaff->method('GetAssignedDepartments')->willReturn([1]);
        $mockStaff->method('GetPermission')->willReturnOnConsecutiveCalls('0', '1', '0', '0', '0', '0');

        $mockObject = $this->getMockObject(\Tickets\Staff\Controller_SearchMock::class, array_merge($services, [
            'View' => $view,
            'Staff' => $mockStaff,
        ]));

        \SWIFT::GetInstance()->Staff = $mockStaff;

        return $mockObject;
    }
}

class Controller_SearchMock extends Controller_Search
{
    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct();
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

