<?php
/**
 * ###############################################
 *
 * Kayako Classic
 * _______________________________________________
 *
 * @author        Werner Garcia <werner.garcia@crossover.com>
 *
 * @package       swift
 * @copyright     Copyright (c) 2001-2018, Trilogy
 * @license       http://kayako.com/license
 * @link          http://kayako.com
 *
 * ###############################################
 */

namespace Base\Console;

use Knowledgebase\Admin\LoaderMock;
use SWIFT_Exception;

/**
 * Class Controller_AttachmentsTest
 */
#[\PHPUnit\Framework\Attributes\Group('base')]
#[\PHPUnit\Framework\Attributes\Group('base-console')]
class Controller_AttachmentsTest extends \SWIFT_TestCase
{
    /**
     * @throws SWIFT_Exception
     */
    public function testConstructorReturnsClassInstance()
    {
        $obj = $this->getMocked();
        $this->assertInstanceOf(\Base\Console\Controller_Attachments::class, $obj);
    }

    /**
     * @throws SWIFT_Exception
     */
    public function testRenameReturnsTrue()
    {
        $obj = $this->getMocked();

        $_SWIFT = \SWIFT::GetInstance();

        static::$nextRecordType = static::NEXT_RECORD_QUERY_RESET;

        $_SWIFT->Database->Record = ['attachmentid' => 1, 'storefilename' => 'testfile'];

        $this->assertTrue($obj->Rename(),
            'Returns true');

        $f = fopen('./__swift/files/testfile', 'w');
        fputs($f, 'test');

        $this->assertTrue($obj->Rename(),
            'Returns true');

        fclose($f);

        if(file_exists('./__swift/files/testfile'))
            unlink('./__swift/files/testfile');

        $this->assertClassNotLoaded($obj, 'Rename');
    }

    private function getMocked(): \PHPUnit\Framework\MockObject\MockObject|\Base\Console\Controller_AttachmentsMock
    {
        $consoleMock = new ConsoleMock();
        return $this->getMockObject(\Base\Console\Controller_AttachmentsMock::class, [
            'Console' => $consoleMock
        ]);
    }
}

class ConsoleMock
{
    public $prompt = false;

    function WriteLine()
    {
        return true;
    }

    function Green()
    {
        return true;
    }

    function Yellow()
    {
        return true;
    }

    function Red()
    {
        return true;
    }

    function Message()
    {
        return true;
    }

    function Prompt($x)
    {
        if (!$this->prompt)
            return true;

        if (preg_match('/.*Database\sHost.*/', (string) $x))
            return DB_HOSTNAME;

        if (preg_match('/.*Database\sName.*/', (string) $x))
            return DB_NAME;

        if (preg_match('/.*Database\sPort.*/', (string) $x))
            return '';

        if (preg_match('/.*Database\sSocket.*/', (string) $x))
            return '';

        if (preg_match('/.*Database\sUsername.*/', (string) $x))
            return DB_USERNAME;

        if (preg_match('/.*Database\sPassword.*/', (string) $x))
            return DB_PASSWORD;


        return true;
    }
}

class Controller_AttachmentsMock extends Controller_Attachments
{
    public function __construct($services = [])
    {
        $this->Load = new LoaderMock();

        foreach ($services as $key => $service) {
            $this->$key = $service;
        }

        $this->SetIsClassLoaded(true);

        parent::__construct();
    }

    public function Initialize()
    {
        // override
        return true;
    }
}

